/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.w3c.dom.Document;
import weblogic.jms.extensions.ClientSAF;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.admin.ConfigurationUtils;
import weblogic.jms.safclient.agent.DestinationImpl;
import weblogic.jms.safclient.jndi.Shutdownable;

public class ContextImpl
implements Context {
    private ClientSAF provider = null;
    private HashMap contextMap = new HashMap();
    private HashMap jmsMap = new HashMap();

    public ContextImpl(ClientSAF clientSAF, Document document, ClientSAFDelegate clientSAFDelegate) throws JMSException {
        this.provider = clientSAF;
        ConfigurationUtils.doJNDIConnectionFactories(document, clientSAFDelegate, this.contextMap);
        ConfigurationUtils.doJNDIDestinations(document, this.jmsMap, this.contextMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl getDestination(String string, String string2) {
        HashMap hashMap = this.jmsMap;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this.jmsMap.get(string);
            if (hashMap2 == null) {
                return null;
            }
            return (DestinationImpl)hashMap2.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl getDestination(String string) {
        HashMap hashMap = this.jmsMap;
        synchronized (hashMap) {
            Iterator iterator = this.jmsMap.keySet().iterator();
            while (iterator.hasNext()) {
                HashMap hashMap2 = (HashMap)this.jmsMap.get(iterator.next());
                DestinationImpl destinationImpl = (DestinationImpl)hashMap2.get(string);
                if (destinationImpl == null) continue;
                return destinationImpl;
            }
        }
        return null;
    }

    public Map getDestinationMap() {
        return this.jmsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int howManyDestinationsWithThisName(String string) {
        int n = 0;
        HashMap hashMap = this.jmsMap;
        synchronized (hashMap) {
            Iterator iterator = this.jmsMap.keySet().iterator();
            while (iterator.hasNext()) {
                HashMap hashMap2 = (HashMap)this.jmsMap.get(iterator.next());
                if (!hashMap2.containsKey(string)) continue;
                ++n;
            }
        }
        return n;
    }

    public Object lookup(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String string) throws NamingException {
        HashMap hashMap = this.contextMap;
        synchronized (hashMap) {
            if (!this.contextMap.containsKey(string)) {
                throw new NamingException("No element with key \"" + string + "\" was bound into the JNDI context");
            }
            return this.contextMap.get(string);
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void bind(String string, Object object) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void rebind(String string, Object object) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void unbind(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void unbind(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void rename(Name name, Name name2) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void rename(String string, String string2) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NamingEnumeration list(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Object lookupLink(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NameParser getNameParser(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public String composeName(String string, String string2) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new NamingException("Not implemented");
    }

    public void close() throws NamingException {
        if (this.provider != null) {
            this.provider.close();
        }
    }

    public String getNameInNamespace() throws NamingException {
        throw new NamingException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(JMSException jMSException) {
        HashMap hashMap = this.contextMap;
        synchronized (hashMap) {
            Iterator iterator = this.contextMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object v = this.contextMap.get(iterator.next());
                if (!(v instanceof Shutdownable)) continue;
                Shutdownable shutdownable = (Shutdownable)v;
                shutdownable.shutdown(jMSException);
            }
            this.contextMap.clear();
        }
        hashMap = this.jmsMap;
        synchronized (hashMap) {
            this.jmsMap.clear();
        }
    }
}

