/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.store;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.store.PersistentStoreException;
import weblogic.store.StoreWritePolicy;
import weblogic.store.io.PersistentStoreIO;
import weblogic.store.io.file.FileStoreIO;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.store.xa.internal.PersistentStoreXAImpl;

public final class StoreUtils {
    private static final String STORE_PFX = "SAFSTORE";
    private static final String STORE_APX = "V";
    private static int storeNum;
    private static Object lock;
    private static HashMap stores;

    private static PersistentStoreXA makeStore(String string, String string2) throws JMSException {
        if (string == null || string2 == null) {
            throw new JMSException("Name and directory name may not be null");
        }
        String string3 = string + "_RESOURCE";
        try {
            FileStoreIO fileStoreIO = new FileStoreIO(string, string2, true);
            return new PersistentStoreXAImpl(string, (PersistentStoreIO)fileStoreIO, string3);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new JMSException(persistentStoreException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getStoreNumber(File file) {
        if (!file.exists() || !file.isDirectory()) {
            Object object = lock;
            synchronized (object) {
                return storeNum++;
            }
        }
        String[] stringArray = file.list(new FileFilter());
        if (stringArray == null || stringArray.length <= 0) {
            Object object = lock;
            synchronized (object) {
                return storeNum++;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n;
            String string = stringArray[i];
            int n2 = string.indexOf(86);
            if (n2 <= STORE_PFX.length()) continue;
            String string2 = string.substring(STORE_PFX.length(), STORE_PFX.length() + (n2 - STORE_PFX.length()));
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            int n3 = n;
            Object object = lock;
            synchronized (object) {
                if (storeNum <= n3) {
                    storeNum = n3 + 1;
                }
                return n3;
            }
        }
        Object object = lock;
        synchronized (object) {
            return storeNum++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initStores(File file, File file2, String string) throws JMSException {
        HashMap hashMap;
        String string2 = STORE_PFX + StoreUtils.getStoreNumber(file2) + STORE_APX;
        PersistentStoreXA persistentStoreXA = StoreUtils.makeStore(string2, file2.toString());
        try {
            hashMap = new HashMap();
            hashMap.put("SynchronousWritePolicy", StoreWritePolicy.getPolicy((String)string));
            persistentStoreXA.open(hashMap);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException(persistentStoreException);
        }
        hashMap = stores;
        synchronized (hashMap) {
            stores.put(file, persistentStoreXA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentStoreXA getStore(File file) {
        HashMap hashMap = stores;
        synchronized (hashMap) {
            return (PersistentStoreXA)stores.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStore(File file) {
        HashMap hashMap = stores;
        synchronized (hashMap) {
            stores.remove(file);
        }
    }

    static {
        lock = new Object();
        stores = new HashMap();
    }

    private static class FileFilter
    implements FilenameFilter {
        private FileFilter() {
        }

        public boolean accept(File file, String string) {
            if (string == null) {
                return false;
            }
            return string.startsWith(StoreUtils.STORE_PFX);
        }
    }
}

