/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.transaction.jta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.jms.safclient.transaction.jta.SimpleTransactionManager;
import weblogic.jms.safclient.transaction.jta.SimpleXid;
import weblogic.transaction.nonxa.NonXAResource;

public final class SimpleTransaction
implements Transaction,
weblogic.transaction.Transaction {
    private String name;
    private SimpleTransactionManager manager;
    private SimpleXid xid = new SimpleXid();
    private int status = 0;
    private boolean suspended;
    private ArrayList resources;
    private LinkedHashSet synchronizations;
    private HashMap properties;
    private Throwable rollbackReason;
    private long startTime;

    SimpleTransaction(String string, SimpleTransactionManager simpleTransactionManager) {
        this.name = string;
        this.manager = simpleTransactionManager;
        this.startTime = System.currentTimeMillis();
        simpleTransactionManager.addTransaction(this);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Xid getXID() {
        return this.xid;
    }

    public Xid getXid() {
        return this.xid;
    }

    public long getMillisSinceBegin() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getTimeToLiveMillis() {
        return Long.MAX_VALUE;
    }

    public boolean isTimedOut() {
        return false;
    }

    public boolean isTxAsyncTimeout() {
        return false;
    }

    private synchronized void setPropertyInternal(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public void setProperty(String string, Serializable serializable) {
        this.setPropertyInternal(string, serializable);
    }

    public void setLocalProperty(String string, Object object) {
        this.setPropertyInternal(string, object);
    }

    public synchronized void addProperties(Map map) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.putAll(map);
    }

    public void addLocalProperties(Map map) {
        this.addProperties(map);
    }

    private synchronized Object getPropertyInternal(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Serializable getProperty(String string) {
        return (Serializable)this.getPropertyInternal(string);
    }

    public Object getLocalProperty(String string) {
        return this.getPropertyInternal(string);
    }

    public synchronized Map getProperties() {
        return new HashMap(this.properties);
    }

    public Map getLocalProperties() {
        return this.getProperties();
    }

    public synchronized int getStatus() {
        return this.status;
    }

    private synchronized void setStatus(int n) {
        this.status = n;
    }

    synchronized boolean isSuspended() {
        return this.suspended;
    }

    private synchronized void setSuspended(boolean bl) {
        this.suspended = bl;
    }

    public synchronized void setRollbackOnly() {
        if (this.status != 0) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.status = 1;
    }

    public synchronized void setRollbackOnly(Throwable throwable) {
        this.setRollbackOnly();
        this.rollbackReason = throwable;
    }

    public synchronized void setRollbackOnly(String string, Throwable throwable) {
        this.setRollbackOnly();
        this.rollbackReason = new Exception(string, throwable);
    }

    public synchronized Throwable getRollbackReason() {
        return this.rollbackReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, SystemException {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        SimpleTransaction simpleTransaction = this;
        synchronized (simpleTransaction) {
            if (this.status == 1) {
                this.rollback();
                throw new RollbackException();
            }
            if (this.status != 0 && this.status != 2) {
                throw new IllegalStateException("Transaction not active");
            }
            this.status = 7;
            if (this.synchronizations != null) {
                arrayList = new ArrayList(this.synchronizations);
            }
            if (this.resources != null) {
                arrayList2 = new ArrayList(this.resources);
            }
        }
        if (arrayList != null) {
            this.beforeCompletion(arrayList);
        }
        if (arrayList2 == null || arrayList2.size() <= 1) {
            this.driveOnePhaseCommit(arrayList, arrayList2);
        } else {
            this.driveTwoPhaseCommit(arrayList, arrayList2);
        }
        this.manager.removeTransaction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare() throws RollbackException, SystemException {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        SimpleTransaction simpleTransaction = this;
        synchronized (simpleTransaction) {
            if (this.status == 1) {
                this.rollback();
                throw new RollbackException();
            }
            if (this.status != 0) {
                throw new IllegalStateException("Transaction not active");
            }
            this.status = 7;
            if (this.synchronizations != null) {
                arrayList = new ArrayList(this.synchronizations);
            }
            if (this.resources != null) {
                arrayList2 = new ArrayList(this.resources);
            }
        }
        if (arrayList != null) {
            this.beforeCompletion(arrayList);
        }
        boolean bl = this.drivePrepare(arrayList2);
        this.setStatus(2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SystemException {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        SimpleTransaction simpleTransaction = this;
        synchronized (simpleTransaction) {
            if (this.status != 0 && this.status != 1 && this.status != 2) {
                throw new IllegalStateException("Transaction not active");
            }
            this.status = 9;
            if (this.synchronizations != null) {
                arrayList = new ArrayList(this.synchronizations);
            }
            if (this.resources != null) {
                arrayList2 = new ArrayList(this.resources);
            }
        }
        if (this.status != 2 && arrayList != null) {
            this.beforeCompletion(arrayList);
        }
        this.driveRollback(arrayList, arrayList2);
        this.manager.removeTransaction(this);
    }

    private void driveOnePhaseCommit(ArrayList arrayList, ArrayList arrayList2) throws SystemException {
        this.setStatus(8);
        if (arrayList2 != null) {
            for (XAResourceHolder xAResourceHolder : arrayList2) {
                try {
                    this.delist(xAResourceHolder);
                    xAResourceHolder.getResource().commit(this.xid, true);
                }
                catch (XAException xAException) {
                    SystemException systemException = new SystemException("XA error on commit: " + xAException.errorCode);
                    systemException.initCause((Throwable)xAException);
                    throw systemException;
                }
            }
        }
        this.setStatus(3);
        if (arrayList != null) {
            this.afterCompletion(arrayList, 3);
        }
    }

    private boolean drivePrepare(ArrayList arrayList) throws SystemException {
        SystemException systemException = null;
        if (arrayList != null) {
            for (Object object : arrayList) {
                try {
                    this.delist((XAResourceHolder)object);
                }
                catch (XAException xAException) {
                    systemException = new SystemException("XA error preparing transaction: " + xAException.errorCode);
                    systemException.initCause((Throwable)xAException);
                }
            }
        }
        if (systemException != null) {
            throw systemException;
        }
        boolean bl = false;
        if (arrayList != null) {
            for (XAResourceHolder xAResourceHolder : arrayList) {
                try {
                    if (xAResourceHolder.getResource().prepare(this.xid) != 3) continue;
                    xAResourceHolder.setReadOnly(true);
                }
                catch (XAException xAException) {
                    bl = true;
                }
            }
        }
        return !bl;
    }

    private void driveTwoPhaseCommit(ArrayList arrayList, ArrayList arrayList2) throws SystemException, HeuristicMixedException, RollbackException {
        boolean bl;
        boolean bl2 = bl = !this.drivePrepare(arrayList2);
        if (bl) {
            this.driveRollback(arrayList, arrayList2);
            throw new RollbackException();
        }
        XAException xAException = null;
        for (Object object : arrayList2) {
            try {
                if (object.isReadOnly()) continue;
                object.getResource().commit(this.xid, false);
            }
            catch (XAException xAException2) {
                xAException = xAException2;
            }
        }
        if (xAException != null) {
            Object object;
            this.setStatus(5);
            object = new HeuristicMixedException("Error commiting XA transaction: " + xAException.errorCode);
            object.initCause(xAException);
            throw object;
        }
        this.setStatus(3);
        if (arrayList != null) {
            this.afterCompletion(arrayList, 3);
        }
    }

    private void driveRollback(ArrayList arrayList, ArrayList arrayList2) throws SystemException {
        SystemException systemException = null;
        if (arrayList2 != null) {
            for (XAResourceHolder xAResourceHolder : arrayList2) {
                try {
                    this.delist(xAResourceHolder);
                    xAResourceHolder.getResource().rollback(this.xid);
                }
                catch (XAException xAException) {
                    systemException = new SystemException("XA error on rollback: " + xAException.errorCode);
                    systemException.initCause((Throwable)xAException);
                }
            }
        }
        this.setStatus(4);
        if (arrayList != null) {
            this.afterCompletion(arrayList, 4);
        }
        if (systemException != null) {
            throw systemException;
        }
    }

    private void delist(XAResourceHolder xAResourceHolder) throws XAException {
        if (xAResourceHolder.isEnlisted()) {
            xAResourceHolder.getResource().end(this.xid, 0x4000000);
            xAResourceHolder.setEnlisted(false);
        } else if (xAResourceHolder.isSuspended()) {
            xAResourceHolder.getResource().end(this.xid, 0x4000000);
            xAResourceHolder.setSuspended(false);
        }
    }

    private void beforeCompletion(ArrayList arrayList) {
        for (Synchronization synchronization : arrayList) {
            synchronization.beforeCompletion();
        }
    }

    private void afterCompletion(ArrayList arrayList, int n) {
        for (Synchronization synchronization : arrayList) {
            synchronization.afterCompletion(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xAResource) throws RollbackException, SystemException {
        Object object;
        XAResourceHolder xAResourceHolder;
        int n = 0;
        SimpleTransaction simpleTransaction = this;
        synchronized (simpleTransaction) {
            if (this.status == 1) {
                throw new RollbackException();
            }
            if (this.status != 0) {
                throw new IllegalStateException("Transaction not active");
            }
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            if ((xAResourceHolder = this.findResource(xAResource)) == null) {
                object = null;
                try {
                    object = this.manager.findResource(xAResource);
                }
                catch (XAException xAException) {
                    throw new SystemException(xAException.toString());
                }
                if (object == null) {
                    throw new SystemException("XAResource was not registered");
                }
                xAResourceHolder = new XAResourceHolder((SimpleTransactionManager.ResourceRec)object);
                this.resources.add(xAResourceHolder);
            } else {
                if (xAResourceHolder.isEnlisted()) {
                    return true;
                }
                if (xAResourceHolder.isSuspended()) {
                    n = 0x8000000;
                }
            }
        }
        try {
            xAResource.start(this.xid, n);
        }
        catch (XAException xAException) {
            object = new SystemException("XA failure: " + xAException.errorCode);
            object.initCause(xAException);
            throw object;
        }
        xAResourceHolder.setSuspended(false);
        xAResourceHolder.setEnlisted(true);
        return true;
    }

    public boolean enlistResource(XAResource xAResource, String string) throws IllegalStateException, SystemException {
        throw new SystemException("Not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xAResource, int n) throws SystemException {
        XAResourceHolder xAResourceHolder;
        SimpleTransaction simpleTransaction = this;
        synchronized (simpleTransaction) {
            if (this.status != 0 && this.status != 1) {
                throw new IllegalStateException("Transaction not active");
            }
            xAResourceHolder = this.findResource(xAResource);
            if (xAResourceHolder == null || !xAResourceHolder.isEnlisted()) {
                throw new IllegalStateException("Resource not enlisted");
            }
        }
        try {
            xAResource.end(this.xid, n);
        }
        catch (XAException xAException) {
            SystemException systemException = new SystemException("XA failure: " + xAException.errorCode);
            systemException.initCause((Throwable)xAException);
            throw systemException;
        }
        xAResourceHolder.setEnlisted(false);
        if (n == 0x2000000) {
            xAResourceHolder.setSuspended(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendAll() throws SystemException {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = this.resources == null ? new ArrayList() : new ArrayList(this.resources);
        }
        object = null;
        for (XAResourceHolder xAResourceHolder : arrayList) {
            try {
                if (!xAResourceHolder.isEnlisted() || xAResourceHolder.isSuspended()) continue;
                xAResourceHolder.getResource().end(this.xid, 0x2000000);
                xAResourceHolder.setEnlisted(false);
                xAResourceHolder.setSuspended(true);
            }
            catch (XAException xAException) {
                object = new SystemException("XA error suspending transaction: " + xAException.errorCode);
                object.initCause(xAException);
            }
        }
        this.setSuspended(true);
        if (object != null) {
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeAll() throws SystemException {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = this.resources == null ? new ArrayList() : new ArrayList(this.resources);
        }
        object = null;
        for (XAResourceHolder xAResourceHolder : arrayList) {
            try {
                if (!xAResourceHolder.isSuspended()) continue;
                xAResourceHolder.getResource().start(this.xid, 0x8000000);
                xAResourceHolder.setEnlisted(true);
                xAResourceHolder.setSuspended(false);
            }
            catch (XAException xAException) {
                object = new SystemException("XA error resuming transaction: " + xAException.errorCode);
                object.initCause(xAException);
            }
        }
        this.setSuspended(false);
        if (object != null) {
            throw object;
        }
    }

    public synchronized void registerSynchronization(Synchronization synchronization) throws RollbackException {
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException("Transaction not active");
        }
        if (this.synchronizations == null) {
            this.synchronizations = new LinkedHashSet();
        }
        this.synchronizations.add(synchronization);
    }

    public String getStatusAsString() {
        switch (this.status) {
            case 0: {
                return "Active";
            }
            case 3: {
                return "Committed";
            }
            case 8: {
                return "Committing";
            }
            case 1: {
                return "Marked Rollback";
            }
            case 6: {
                return "No Transaction";
            }
            case 2: {
                return "Prepared";
            }
            case 7: {
                return "Preparing";
            }
            case 4: {
                return "Rolled Back";
            }
            case 9: {
                return "Rolling Back";
            }
        }
        return "Unknown";
    }

    public String getHeuristicErrorMessage() {
        return null;
    }

    public Object invokeCoordinatorService(String string, Object object) throws SystemException {
        throw new SystemException("Not implemented");
    }

    public boolean isCoordinatorLocal() {
        return true;
    }

    public boolean isCoordinatorAssigned() {
        return true;
    }

    public boolean enlistResource(NonXAResource nonXAResource) throws SystemException {
        throw new SystemException("Not implemented");
    }

    private synchronized XAResourceHolder findResource(XAResource xAResource) {
        try {
            for (XAResourceHolder xAResourceHolder : this.resources) {
                if (!xAResourceHolder.isSameRM(xAResource)) continue;
                return xAResourceHolder;
            }
            return null;
        }
        catch (XAException xAException) {
            return null;
        }
    }

    private static final class XAResourceHolder {
        private SimpleTransactionManager.ResourceRec res;
        private boolean suspended;
        private boolean enlisted;
        private boolean readOnly;

        XAResourceHolder(SimpleTransactionManager.ResourceRec resourceRec) {
            this.res = resourceRec;
        }

        XAResource getResource() {
            return this.res.getResource();
        }

        synchronized boolean isSuspended() {
            return this.suspended;
        }

        synchronized void setSuspended(boolean bl) {
            this.suspended = bl;
        }

        synchronized boolean isEnlisted() {
            return this.enlisted;
        }

        synchronized void setEnlisted(boolean bl) {
            this.enlisted = bl;
        }

        synchronized boolean isReadOnly() {
            return this.readOnly;
        }

        synchronized void setReadOnly(boolean bl) {
            this.readOnly = bl;
        }

        public boolean isSameRM(XAResource xAResource) throws XAException {
            return this.res.getResource() == xAResource || this.res.getResource().isSameRM(xAResource);
        }
    }
}

