/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.transaction.jta;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.jms.safclient.transaction.jta.SimpleTransaction;
import weblogic.transaction.CoordinatorService;
import weblogic.transaction.TransactionInterceptor;
import weblogic.transaction.UserTransaction;
import weblogic.transaction.loggingresource.LoggingResource;
import weblogic.transaction.nonxa.NonXAResource;

public class SimpleTransactionManager
implements TransactionManager,
weblogic.transaction.TransactionManager,
UserTransaction {
    private final ThreadLocal tls = new ThreadLocal();
    private final Map transactions = new HashMap();
    private final Map resources = new LinkedHashMap();

    public void registerStaticResource(String string, XAResource xAResource) throws SystemException {
        throw new SystemException("Not implemented");
    }

    public void registerDynamicResource(String string, XAResource xAResource) {
        this.registerResource(string, xAResource);
    }

    public void registerResource(String string, XAResource xAResource, Hashtable hashtable) {
        this.registerResource(string, xAResource);
    }

    public synchronized void registerResource(String string, XAResource xAResource) {
        ResourceRec resourceRec = (ResourceRec)this.resources.get(string);
        if (resourceRec == null) {
            resourceRec = new ResourceRec(string, xAResource);
            this.resources.put(string, resourceRec);
        } else {
            resourceRec.setResource(xAResource);
        }
    }

    public void registerDynamicResource(String string, NonXAResource nonXAResource) throws SystemException {
        throw new SystemException("Not implemented");
    }

    public void unregisterResource(String string) {
        this.unregisterResource(string, false);
    }

    public synchronized void unregisterResource(String string, boolean bl) {
        ResourceRec resourceRec = (ResourceRec)this.resources.get(string);
        resourceRec.setResource(null);
    }

    public void setTransactionTimeout(int n) {
    }

    private SimpleTransaction getTran() {
        return (SimpleTransaction)this.tls.get();
    }

    public Transaction getTransaction() {
        return this.getTran();
    }

    public Transaction getTransaction(Xid xid) {
        return null;
    }

    public int getStatus() {
        SimpleTransaction simpleTransaction = this.getTran();
        if (simpleTransaction == null) {
            return 6;
        }
        return simpleTransaction.getStatus();
    }

    public void setRollbackOnly() {
        SimpleTransaction simpleTransaction = this.getTran();
        if (simpleTransaction == null) {
            throw new IllegalStateException();
        }
        simpleTransaction.setRollbackOnly();
    }

    public void begin() throws NotSupportedException {
        this.begin("Client SAF", 0);
    }

    public void begin(String string) throws NotSupportedException {
        this.begin(string, 0);
    }

    public void begin(int n) throws NotSupportedException {
        this.begin("Client SAF", n);
    }

    public void begin(String string, int n) throws NotSupportedException {
        if (this.getTran() != null) {
            throw new NotSupportedException();
        }
        SimpleTransaction simpleTransaction = new SimpleTransaction(string, this);
        this.tls.set(simpleTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, SystemException {
        SimpleTransaction simpleTransaction = this.getTran();
        if (simpleTransaction == null) {
            throw new IllegalStateException();
        }
        try {
            simpleTransaction.commit();
        }
        finally {
            this.tls.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SystemException {
        SimpleTransaction simpleTransaction = this.getTran();
        if (simpleTransaction == null) {
            throw new IllegalStateException();
        }
        try {
            simpleTransaction.rollback();
        }
        finally {
            this.tls.set(null);
        }
    }

    public Transaction suspend() throws SystemException {
        SimpleTransaction simpleTransaction = this.getTran();
        if (simpleTransaction != null) {
            simpleTransaction.suspendAll();
            this.tls.set(null);
        }
        return simpleTransaction;
    }

    public Transaction forceSuspend() {
        SimpleTransaction simpleTransaction = this.getTran();
        if (simpleTransaction != null) {
            this.tls.set(null);
        }
        return simpleTransaction;
    }

    public void resume(Transaction transaction) throws SystemException, InvalidTransactionException {
        if (this.getTran() != null) {
            throw new IllegalStateException();
        }
        try {
            SimpleTransaction simpleTransaction = (SimpleTransaction)transaction;
            if (simpleTransaction.isSuspended()) {
                simpleTransaction.resumeAll();
            }
            this.tls.set(simpleTransaction);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidTransactionException();
        }
    }

    public void forceResume(Transaction transaction) {
        if (this.getTran() != null) {
            throw new IllegalStateException();
        }
        SimpleTransaction simpleTransaction = (SimpleTransaction)transaction;
        this.tls.set(simpleTransaction);
    }

    public void registerLoggingResourceTransactions(LoggingResource loggingResource) throws SystemException {
        throw new SystemException("Not implemented");
    }

    public void registerFailedLoggingResource(Throwable throwable) {
    }

    public void registerCoordinatorService(String string, CoordinatorService coordinatorService) {
    }

    public TransactionInterceptor getInterceptor() {
        return null;
    }

    synchronized void addTransaction(SimpleTransaction simpleTransaction) {
        this.transactions.put(simpleTransaction.getXID(), simpleTransaction);
    }

    synchronized void removeTransaction(SimpleTransaction simpleTransaction) {
        this.transactions.remove(simpleTransaction.getXID());
        this.tls.set(null);
    }

    synchronized ResourceRec findResource(XAResource xAResource) throws XAException {
        for (ResourceRec resourceRec : this.resources.values()) {
            if (resourceRec.getResource() != xAResource && !resourceRec.getResource().isSameRM(xAResource)) continue;
            return resourceRec;
        }
        return null;
    }

    static final class ResourceRec {
        private String name;
        private XAResource resource;

        ResourceRec(String string, XAResource xAResource) {
            this.name = string;
            this.resource = xAResource;
        }

        XAResource getResource() {
            return this.resource;
        }

        void setResource(XAResource xAResource) {
            this.resource = xAResource;
        }

        public boolean equals(Object object) {
            try {
                return this.name.equals(((ResourceRec)object).name);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

