/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.transaction.jta;

import java.nio.ByteBuffer;
import javax.transaction.xa.Xid;

public final class SimpleXid
implements Xid {
    private static final int FORMAT_ID = 8675309;
    private static final int DEFAULT_BQUAL = 1;
    private static final IDRoller idRoller = new IDRoller();
    private long timestamp = System.currentTimeMillis();
    private short counter = idRoller.getNextID();
    private int branch = 1;

    SimpleXid() {
    }

    public int getFormatId() {
        return 8675309;
    }

    public byte[] getGlobalTransactionId() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.putLong(this.timestamp);
        byteBuffer.putShort(this.counter);
        byteBuffer.flip();
        return byteBuffer.array();
    }

    public byte[] getBranchQualifier() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(this.branch);
        byteBuffer.flip();
        return byteBuffer.array();
    }

    public int hashCode() {
        return (int)this.timestamp;
    }

    public boolean equals(Object object) {
        try {
            SimpleXid simpleXid = (SimpleXid)object;
            return simpleXid.timestamp == this.timestamp && simpleXid.counter == this.counter && simpleXid.branch == this.branch;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private static final class IDRoller {
        private short counter;

        private IDRoller() {
        }

        synchronized short getNextID() {
            this.counter = (short)(this.counter + 1);
            return this.counter;
        }
    }
}

