/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;

public class SequenceData
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 7571220896297616034L;
    private static final int EXTVERSION1 = 65536;
    private static final int VERSION_MASK = 983040;
    private static final int PROPERTY_UOO = 1;
    private static final int SAF_STICKY_ROUTING = 4096;
    String uooName;
    boolean safStickyRouting;

    public void setSAFStickyRouting(boolean bl) {
        this.safStickyRouting = bl;
    }

    public void setUnitOfOrder(String string) {
        this.uooName = string;
    }

    public boolean getSAFStickyRouting() {
        return this.safStickyRouting;
    }

    public String getUnitOfOrder() {
        return this.uooName;
    }

    public SequenceData copy() {
        try {
            return (SequenceData)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SequenceData)) {
            return false;
        }
        SequenceData sequenceData = (SequenceData)object;
        if (this.safStickyRouting != sequenceData.safStickyRouting) {
            return false;
        }
        if (this.uooName == null) {
            return sequenceData.uooName == null;
        }
        return this.uooName.equals(sequenceData.uooName);
    }

    public int hashCode() {
        int n = 0;
        if (this.safStickyRouting) {
            n = 4096;
        }
        if (this.uooName != null) {
            n |= this.uooName.hashCode();
        }
        return n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.uooName;
        int n = string == null ? 65536 : 65537;
        if (this.safStickyRouting) {
            n = 4096;
        }
        objectOutput.writeInt(n);
        if (string != null) {
            objectOutput.writeUTF(string);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xF0000;
        if (n2 != 65536) {
            throw JMSUtilities.versionIOException(n2, 65536, 65536);
        }
        boolean bl = this.safStickyRouting = (n & 0x1000) != 0;
        if ((n & 1) != 0) {
            this.uooName = objectInput.readUTF();
        }
    }
}

