/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.tracing;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import weblogic.jms.utils.Simple;
import weblogic.jms.utils.tracing.PreciseTimerFactory;
import weblogic.jms.utils.tracing.SubBuffer;
import weblogic.utils.time.Timer;

public class DataLog {
    private static Object lock = new Object();
    private static int maxCount = 0x600000;
    private static boolean beenHere = false;
    private static RecordFile recordFile;
    private static final int RECORD_SIZE = 9;
    private static String base;
    private static boolean initDone;
    private static Timer timer;

    public static void init(int n) {
        if (!initDone) {
            initDone = true;
            maxCount = n;
            DataLog.init();
        }
    }

    public static void init() {
        if (maxCount != 0) {
            timer = PreciseTimerFactory.newTimer();
        }
        recordFile = new RecordFile(base + Math.abs(new Random().nextInt() % 10000), maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToHeader(String string) {
        if (!beenHere) {
            Object object = lock;
            synchronized (object) {
                if (!beenHere) {
                    DataLog.init();
                    beenHere = true;
                }
            }
        }
        recordFile.addToHeader(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void record(int n, int n2) {
        if (!beenHere) {
            Object object = lock;
            synchronized (object) {
                if (!beenHere) {
                    DataLog.init();
                    beenHere = true;
                }
            }
        }
        recordFile.record(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubBuffer newDataArea(String string, int n) {
        if (!beenHere) {
            Object object = lock;
            synchronized (object) {
                if (!beenHere) {
                    DataLog.init();
                    beenHere = true;
                }
            }
        }
        return recordFile.newDataArea(string, n);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 100000; ++i) {
            DataLog.record(0, 1234);
            DataLog.record(1, 1234);
            DataLog.record(2, 1234);
            DataLog.record(3, 1234);
            DataLog.record(4, 1234);
            DataLog.record(5, 1234);
            DataLog.record(6, 1234);
        }
    }

    static {
        base = "/tmp/timer_";
        initDone = false;
        String string = Simple.getenv("weblogic.jms.PerformanceMaxCount");
        if (string != null) {
            maxCount = Integer.decode(string);
        }
        if ((string = Simple.getenv("weblogic.jms.PerformanceFileBase")) != null) {
            base = string;
        }
    }

    private static class RecordFile {
        private MappedByteBuffer buffer;
        private AtomicInteger position = new AtomicInteger(40960);
        private AtomicInteger headerPosition = new AtomicInteger();
        private int maxPosition;
        private long baseTime;

        RecordFile(String string, int n) {
            this.maxPosition = n * 9 + 40960;
            File file = new File(string + ".out");
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                byte[] byArray = new byte[1024];
                for (int i = 0; i < this.maxPosition; i += 1024) {
                    randomAccessFile.write(byArray);
                }
                FileChannel fileChannel = randomAccessFile.getChannel();
                this.buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.maxPosition);
            }
            catch (Exception exception) {
                System.err.println("Failed!: " + exception);
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            if (n != 0) {
                long l = new Date().getTime();
                for (int i = 0; i < 2; ++i) {
                    long l2;
                    do {
                        l2 = new Date().getTime();
                        this.baseTime = timer.timestamp() / 1000L;
                    } while (l2 == l);
                    l = l2;
                }
                System.out.println("Base time is " + this.baseTime);
                this.buffer.putLong(l * 1000L);
            }
            this.headerPosition.addAndGet(8);
        }

        void addToHeader(String string) {
            char[] cArray = (string + "\n").toCharArray();
            int n = this.headerPosition.addAndGet(2 + cArray.length * 2);
            int n2 = n - 2 - cArray.length * 2;
            this.buffer.putShort(n2, (short)(cArray.length * 2));
            n2 += 2;
            for (int i = 0; i < cArray.length; ++i) {
                this.buffer.putChar(n2, cArray[i]);
                n2 += 2;
            }
        }

        void record(int n, int n2) {
            int n3 = this.position.addAndGet(9);
            if (n3 <= this.maxPosition) {
                int n4 = n3 - 9;
                n = n == 128 ? 127 : (n -= 128);
                this.buffer.put(n4++, (byte)n);
                long l = timer.timestamp() / 1000L - this.baseTime;
                this.buffer.put(n4++, (byte)((l & 0xFFL) - 128L));
                this.buffer.put(n4++, (byte)(((l >>= 8) & 0xFFL) - 128L));
                this.buffer.put(n4++, (byte)(((l >>= 8) & 0xFFL) - 128L));
                this.buffer.put(n4++, (byte)(((l >>= 8) & 0xFFL) - 128L));
                this.buffer.putInt(n4, n2);
            }
        }

        public SubBuffer newDataArea(String string, int n) {
            char[] cArray = (string + "\n").toCharArray();
            int n2 = this.headerPosition.addAndGet(2 + cArray.length * 2 + 2 + n);
            int n3 = n2 - 2 - cArray.length * 2 - 2 - n;
            this.buffer.putShort(n3, (short)(cArray.length * 2));
            n3 += 2;
            for (int i = 0; i < cArray.length; ++i) {
                this.buffer.putChar(n3, cArray[i]);
                n3 += 2;
            }
            this.buffer.putShort(n3, (short)n);
            return new SubBuffer(this.buffer, n3 + 2, n);
        }
    }
}

