/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.tracing;

import java.util.Random;
import javax.jms.JMSException;
import javax.jms.Message;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.utils.Simple;
import weblogic.jms.utils.tracing.AggregationCounter;
import weblogic.jms.utils.tracing.DataLog;

public class MessageTimeStamp {
    private static Object lock = new Object();
    public static final int SEND_RESPONSE = 1;
    public static final int ACK = 2;
    public static final int ACK_RESPONSE = 3;
    public static final int PUSH = 4;
    public static final int SEND = 5;
    public static final int NMESSAGE_TYPES = 6;
    public static final int CLIENT_PRODUCER = 0;
    public static final int FE_PRODUCER = 1;
    public static final int BE_PRODUCER = 2;
    public static final int KERNEL = 3;
    public static final int BE_CONSUMER = 4;
    public static final int FE_CONSUMER = 5;
    public static final int CLIENT_CONSUMER = 6;
    public static final int AGGREGATION = 7;
    public static final int RESPONSE_PATH_START = 8;
    public static final int ACK_PATH_START = 9;
    public static final int READ = 10;
    public static final int WRITE = 16;
    public static final int SERIALIZE_START = 22;
    public static final int SERIALIZE_END = 28;
    public static final int DESERIALIZE_START = 34;
    public static final int DESERIALIZE_END = 40;
    private static boolean serverOnly = true;
    private static boolean aggregationOnly = false;
    private static boolean on = true;
    private static Random random = new Random();
    private static boolean beenHere = false;

    private static void makeHeader() {
        DataLog.addToHeader("FLOW CLIENT_PRODUCER 0 CLIENT FIRST PATH1");
        DataLog.addToHeader("FLOW SERIALIZE_START_SEND 27 CLIENT NO_DYE PATH1");
        DataLog.addToHeader("FLOW SERIALIZE_END_SEND 33 CLIENT NO_DYE PATH1");
        DataLog.addToHeader("FLOW WRITE_SEND 21 CLIENT NO_DYE PATH1");
        DataLog.addToHeader("FLOW READ_SEND 15 FIRST NO_DYE PATH1");
        DataLog.addToHeader("FLOW DESERIALIZE_START_SEND 39 NO_DYE PATH1");
        DataLog.addToHeader("FLOW DESERIALIZE_END_SEND 45 NO_DYE PATH1");
        DataLog.addToHeader("FLOW FE_PRODUCER 1 PATH1 FIRST_DYED");
        DataLog.addToHeader("FLOW BE_PRODUCER 2 PATH1");
        DataLog.addToHeader("FLOW KERNEL 3 PATH1");
        DataLog.addToHeader("FLOW BE_CONSUMER 4 PATH1");
        DataLog.addToHeader("FLOW FE_CONSUMER 5 PATH1");
        DataLog.addToHeader("FLOW SERIALIZE_START_PUSH 26 NO_DYE PATH1");
        DataLog.addToHeader("FLOW SERIALIZE_END_PUSH 32 NO_DYE PATH1");
        DataLog.addToHeader("FLOW WRITE_PUSH 20 NO_DYE PATH1");
        DataLog.addToHeader("FLOW READ_PUSH 14 CLIENT NO_DYE PATH1");
        DataLog.addToHeader("FLOW DESERIALIZE_START_PUSH 38 CLIENT NO_DYE PATH1");
        DataLog.addToHeader("FLOW DESERIALIZE_END_PUSH 44 CLIENT NO_DYE PATH1");
        DataLog.addToHeader("FLOW CLIENT_CONSUMER 6 CLIENT LAST PATH1");
        DataLog.addToHeader("FLOW SEND_RESPONSE_PATH_START 8 PATH2 FIRST");
        DataLog.addToHeader("FLOW WRITE_SEND_RESPONSE 17 LAST NO_DYE PATH2");
        DataLog.addToHeader("FLOW READ_SEND_RESPONSE 11 CLIENT NO_DYE PATH2 LAST");
        DataLog.addToHeader("FLOW ACK_PATH_START 9 CLIENT PATH3 FIRST");
        DataLog.addToHeader("FLOW WRITE_ACK 18 CLIENT NO_DYE PATH3");
        DataLog.addToHeader("FLOW READ_ACK 12 NO_DYE PATH3 FIRST");
        DataLog.addToHeader("FLOW WRITE_ACK_RESPONSE 19 NO_DYE PATH3");
        DataLog.addToHeader("FLOW READ_ACK_RESPONSE 13 CLIENT NO_DYE PATH3 LAST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void record(int n, int n2) {
        if (!on || aggregationOnly) {
            return;
        }
        if (serverOnly && (n == 0 || n == 6)) {
            return;
        }
        if (!beenHere) {
            Object object = lock;
            synchronized (object) {
                if (!beenHere) {
                    MessageTimeStamp.makeHeader();
                    beenHere = true;
                }
            }
        }
        DataLog.record(n, n2);
    }

    public static void record(int n, Message message) {
        if (!on) {
            return;
        }
        if (serverOnly && (n == 0 || n == 6)) {
            return;
        }
        MessageImpl messageImpl = (MessageImpl)message;
        int n2 = 0;
        try {
            if (n == 0 || serverOnly && n == 1) {
                byte[] byArray = new byte[6];
                n2 = Math.abs(random.nextInt());
                byArray[0] = 68;
                byArray[1] = 89;
                byArray[2] = (byte)((n2 & 0x3F) + 32);
                byArray[3] = (byte)(((n2 & 0x3F00) >> 8) + 32);
                byArray[4] = (byte)(((n2 & 0x3F0000) >> 16) + 32);
                byArray[5] = (byte)(((n2 & 0x3F000000) >> 24) + 32);
                messageImpl.setJMSCorrelationIDAsBytes(byArray);
                n2 = byArray[2] + (byArray[3] << 8) + (byArray[4] << 16) + (byArray[5] << 24);
            } else {
                byte[] byArray = messageImpl.getJMSCorrelationIDAsBytes();
                n2 = byArray == null ? 0 : byArray[2] + (byArray[3] << 8) + (byArray[4] << 16) + (byArray[5] << 24);
            }
            if (n2 != 0) {
                MessageTimeStamp.record(n, n2);
            }
        }
        catch (JMSException jMSException) {
            System.err.println("Exception at point " + n + ": " + (Object)((Object)jMSException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AggregationCounter newAggregationCounter(String string, int n) {
        if (!on) {
            return null;
        }
        if (!beenHere && aggregationOnly) {
            Object object = lock;
            synchronized (object) {
                if (!beenHere) {
                    DataLog.init(0);
                    beenHere = true;
                }
            }
        }
        return new AggregationCounter(string, n);
    }

    static {
        String string = Simple.getenv("weblogic.jms.PerformanceCounters");
        on = string != null;
        string = Simple.getenv("weblogic.jms.PerformanceCounters.ServerOnly");
        serverOnly = string != null;
        string = Simple.getenv("weblogic.jms.PerformanceCounters.AggregationOnly");
        aggregationOnly = string != null;
        boolean bl = on = on || serverOnly || aggregationOnly;
        if (on) {
            System.out.println("Performance counters: on = " + on + ", serverOnly = " + serverOnly + ", aggregationOnly = " + aggregationOnly);
        }
    }
}

