/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jndi.ClientEnvironment;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.SSL.SSLProxy;
import weblogic.jndi.spi.EnvironmentManager;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerURL;
import weblogic.rmi.spi.HostID;
import weblogic.security.SSL.TrustManager;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;

public final class Environment
implements Externalizable,
ClientEnvironment {
    private static final long serialVersionUID = 6539137427459606294L;
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String LOCAL_URL = "local://";
    public static final String LOCAL_URL_PROTOCOL = "t3";
    private static final boolean cantReadSystemProperties = KernelStatus.isApplet();
    private transient boolean copyOnWrite;
    private transient Context initialContext = null;
    private Hashtable env;
    private boolean enableDefaultUser = false;
    private static final SSLProxy sslProxy = JNDIEnvironment.getJNDIEnvironment().getSSLProxy();
    private static Class factoryReference = WLInitialContextFactory.class;
    private UserInfo securityUser = null;
    private AuthenticatedSubject subject;
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();

    public Environment() {
        this.env = new Hashtable();
        this.copyOnWrite = false;
    }

    public Environment(Hashtable hashtable) {
        this.env = hashtable;
        if (hashtable != null) {
            try {
                if (hashtable.get("weblogic.jndi.ssl.root.ca.fingerprints") != null) {
                    Object v = hashtable.get("weblogic.jndi.ssl.root.ca.fingerprints");
                    if (v instanceof String) {
                        this.setSSLRootCAFingerprints((String)v);
                    } else if (v instanceof byte[][]) {
                        this.setSSLRootCAFingerprints((byte[][])v);
                    }
                }
                if (hashtable.get("weblogic.jndi.ssl.server.name") != null) {
                    this.setSSLServerName((String)hashtable.get("weblogic.jndi.ssl.server.name"));
                }
                if (hashtable.get("weblogic.jndi.ssl.client.certificate") != null) {
                    this.setSSLClientCertificate((InputStream[])hashtable.get("weblogic.jndi.ssl.client.certificate"));
                }
                if (hashtable.get("weblogic.jndi.enableDefaultUser") != null) {
                    this.setEnableDefaultUser(true);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.copyOnWrite = true;
    }

    private SSLProxy findOrCreateSSLProxy() {
        return sslProxy;
    }

    public Hashtable getProperties() {
        return this.env;
    }

    public final Context getInitialContext() throws NamingException {
        return this.getInitialContext(true);
    }

    public final Context getInitialContext(boolean bl) throws NamingException {
        Context context = this.initialContext;
        if (this.initialContext == null) {
            this.initialContext = this.createInitialContext();
            return this.initialContext;
        }
        if (bl) {
            return context;
        }
        return this.createInitialContext();
    }

    private Context createInitialContext() throws NamingException {
        String string = this.getInitialContextFactory();
        if (string.equals(DEFAULT_INITIAL_CONTEXT_FACTORY)) {
            return this.getContext(null);
        }
        return new InitialContext(this.env);
    }

    public final Context getContext() throws NamingException {
        return this.getInitialContext();
    }

    public final Remote getInitialReference(Class clazz) throws NamingException {
        String string;
        String string2 = this.getString("java.naming.provider.url");
        if (string2 != null) {
            try {
                string = string2.substring(0, string2.indexOf(58));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NamingException(indexOutOfBoundsException.getMessage());
            }
        } else {
            string = KernelStatus.isServer() ? "local" : ServerURL.DEFAULT_URL.getProtocol();
        }
        return EnvironmentManager.getInstance(string).getInitialReference(this, clazz);
    }

    public final void setProviderChannel(String string) {
        if (string != null) {
            this.setProperty("weblogic.jndi.provider.channel", string);
        }
    }

    public final String getProviderChannel() {
        return this.getString("weblogic.jndi.provider.channel");
    }

    public final Context getContext(String string) throws NamingException {
        return this.getContext(string, null);
    }

    public final Context getContext(String string, HostID hostID) throws NamingException {
        String string2;
        String string3 = this.getString("java.naming.provider.url");
        if (string3 != null) {
            try {
                string2 = string3.substring(0, string3.indexOf(58));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NamingException(indexOutOfBoundsException.getMessage());
            }
        } else {
            string2 = KernelStatus.isServer() ? "local" : ServerURL.DEFAULT_URL.getProtocol();
        }
        return EnvironmentManager.getInstance(string2).getInitialContext(this, string, hostID);
    }

    public String getInitialContextFactory() throws IllegalArgumentException {
        String string = this.getString("java.naming.factory.initial");
        return string != null ? string : DEFAULT_INITIAL_CONTEXT_FACTORY;
    }

    public final void setInitialContextFactory(String string) {
        this.setProperty("java.naming.factory.initial", string);
    }

    public final String getProviderUrl() {
        String string = this.getString("java.naming.provider.url");
        if (string != null) {
            return string;
        }
        if (KernelStatus.isServer()) {
            return LOCAL_URL;
        }
        return ServerURL.DEFAULT_URL.toString();
    }

    public final void setProviderUrl(String string) {
        if (string != null) {
            this.setProperty("java.naming.provider.url", string);
        }
    }

    public final void setProviderURL(String string) {
        this.setProviderUrl(string);
    }

    public final Hashtable getDelegateEnvironment() throws IllegalArgumentException {
        try {
            Hashtable hashtable = (Hashtable)this.getProperty("weblogic.jndi.delegate.environment");
            if (hashtable == null) {
                hashtable = (Hashtable)this.getObsoleteProperty("java.naming.provider.delegate.environment", "WLContext.DELEGATE_ENVIRONMENT");
            }
            return hashtable;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Value of 'weblogic.jndi.delegate.environment' is not a Hashtable as expected");
        }
    }

    public final void setDelegateEnvironment(Hashtable hashtable) {
        this.setProperty("weblogic.jndi.delegate.environment", hashtable);
    }

    public final boolean getForceResolveDNSName() throws IllegalArgumentException {
        return this.getBoolean("weblogic.jndi.forceResolveDNSName", false);
    }

    public final String getSecurityPrincipal() throws IllegalArgumentException {
        return (String)this.getPropertyFromEnv("java.naming.security.principal");
    }

    public final void setSecurityPrincipal(String string) {
        this.setProperty("java.naming.security.principal", string);
    }

    public final Object getSecurityCredentials() throws IllegalArgumentException {
        return this.getPropertyFromEnv("java.naming.security.credentials");
    }

    public final void setSecurityCredentials(Object object) {
        this.setProperty("java.naming.security.credentials", object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final UserInfo getSecurityUser() throws IllegalArgumentException {
        if (this.securityUser != null) {
            return this.securityUser;
        }
        Object object = this.getSecurityCredentials();
        if (object instanceof UserInfo) {
            this.securityUser = (UserInfo)object;
            return this.securityUser;
        } else if (object instanceof String) {
            String string = this.getSecurityPrincipal();
            if (string == null) throw new IllegalArgumentException("The 'java.naming.security.principal' property has not been specified");
            this.securityUser = new DefaultUserInfoImpl(string, object);
            return this.securityUser;
        } else if (object == null) {
            String string = this.getSecurityPrincipal();
            if (string == null) return this.securityUser;
            this.securityUser = new DefaultUserInfoImpl(string, object);
            return this.securityUser;
        } else {
            if (object == null) return this.securityUser;
            throw new IllegalArgumentException("The 'java.naming.security.credentials' property must be either a password String or an instance of UserInfo.");
        }
    }

    public final void setSecurityUser(UserInfo userInfo) {
        this.securityUser = userInfo;
        this.setSecurityCredentials(userInfo);
    }

    public void setSecuritySubject(AuthenticatedSubject authenticatedSubject) {
        this.subject = authenticatedSubject;
    }

    public AuthenticatedSubject getSecuritySubject() {
        return this.subject;
    }

    public AbstractSubject getSubject() {
        return this.subject;
    }

    public final boolean getCreateIntermediateContexts() throws IllegalArgumentException {
        return this.getBoolean("weblogic.jndi.createIntermediateContexts", false);
    }

    public final void setCreateIntermediateContexts(boolean bl) throws IllegalArgumentException {
        this.setBoolean("weblogic.jndi.createIntermediateContexts", bl);
    }

    public final boolean getReplicateBindings() throws IllegalArgumentException {
        return this.getBoolean("weblogic.jndi.replicateBindings", true);
    }

    public final void setReplicateBindings(boolean bl) {
        this.setBoolean("weblogic.jndi.replicateBindings", bl);
    }

    public final boolean getPinToPrimaryServer() throws IllegalArgumentException {
        if (!this.getReplicateBindings() || this.getProviderIdentity() != null) {
            return true;
        }
        return this.getBoolean("weblogic.jndi.pinToPrimaryServer", false);
    }

    public final void setPinToPrimaryServer(boolean bl) {
        this.setBoolean("weblogic.jndi.pinToPrimaryServer", bl);
    }

    public final void setEnableServerAffinity(boolean bl) {
        this.setBoolean("weblogic.jndi.enableServerAffinity", bl);
    }

    public final boolean getEnableServerAffinity() {
        return this.getBoolean("weblogic.jndi.enableServerAffinity", false);
    }

    public final void setRequestTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot have -ve timeout");
        }
        this.env.put("weblogic.jndi.requestTimeout", new Long(l));
    }

    public final long getRequestTimeout() {
        if (this.env == null) {
            return 0L;
        }
        Object v = this.env.get("weblogic.jndi.requestTimeout");
        long l = v == null ? 0L : (v instanceof String ? Long.parseLong((String)v) : (Long)v);
        return l;
    }

    public final void setRMIClientTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot have -ve timeout");
        }
        this.env.put("weblogic.rmi.clientTimeout", new Long(l));
    }

    public final long getRMIClientTimeout() {
        if (this.env == null) {
            return 0L;
        }
        Object v = this.env.get("weblogic.rmi.clientTimeout");
        long l = v == null ? 0L : (v instanceof String ? Long.parseLong((String)v) : (Long)v);
        return l;
    }

    public final String getString(String string) throws IllegalArgumentException {
        try {
            return (String)this.getProperty(string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Value of '" + string + "' is not a String as expected");
        }
    }

    public final boolean getBoolean(String string, boolean bl) throws IllegalArgumentException {
        String string2 = this.getString(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase(TRUE)) {
            return true;
        }
        if (string2.equalsIgnoreCase(FALSE)) {
            return false;
        }
        throw new IllegalArgumentException("Value of '" + string + "' is not \"" + TRUE + "\" or \"" + FALSE + "\" as expected");
    }

    public final void setSSLRootCAFingerprints(String string) {
        this.findOrCreateSSLProxy().setRootCAfingerprints(string);
    }

    public final void setSSLRootCAFingerprints(byte[][] byArray) {
        this.findOrCreateSSLProxy().setRootCAfingerprints(byArray);
    }

    public final byte[][] getSSLRootCAFingerprints() {
        return this.findOrCreateSSLProxy().getRootCAfingerprints();
    }

    public final void setSSLServerName(String string) {
        this.findOrCreateSSLProxy().setExpectedName(string);
    }

    public final String getSSLServerName() {
        return this.findOrCreateSSLProxy().getExpectedName();
    }

    public final Object getSSLClientCertificate() throws IOException {
        return this.findOrCreateSSLProxy().getSSLClientCertificate();
    }

    public final void setSSLClientCertificate(InputStream[] inputStreamArray) {
        this.findOrCreateSSLProxy().setSSLClientCertificate(inputStreamArray);
    }

    public final void setSSLClientKeyPassword(String string) {
        this.findOrCreateSSLProxy().setSSLClientKeyPassword(string);
    }

    public final Object getSSLClientKeyPassword() {
        return this.findOrCreateSSLProxy().getSSLClientKeyPassword();
    }

    public final void setSSLClientTrustManager(TrustManager trustManager) {
        this.findOrCreateSSLProxy().setTrustManager(trustManager);
    }

    public final TrustManager getSSLClientTrustManager() {
        return this.findOrCreateSSLProxy().getTrustManager();
    }

    public final void setBoolean(String string, boolean bl) {
        this.setProperty(string, bl ? TRUE : FALSE);
    }

    public final Object getProperty(String string) {
        String string2 = null;
        if (this.env != null) {
            string2 = (String)this.env.get(string);
        }
        if (string2 == null && !cantReadSystemProperties) {
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return string2;
    }

    public final Object getPropertyFromEnv(String string) {
        if (this.env != null) {
            return this.env.get(string);
        }
        return null;
    }

    private final Object getObsoleteProperty(String string, String string2) {
        Object object = this.getPropertyFromEnv(string);
        if (object != null) {
            JNDILogger.logObsoleteProp((String)string, (String)string2);
        }
        return object;
    }

    public final Object setProperty(String string, Object object) {
        Object object2;
        if (this.env == null && object == null) {
            return null;
        }
        this.initialContext = null;
        if (this.copyOnWrite) {
            object2 = this.env;
            this.env = new Hashtable();
            if (object2 != null) {
                Enumeration enumeration = ((Hashtable)object2).keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    this.env.put(k, ((Hashtable)object2).get(k));
                }
            }
            this.copyOnWrite = false;
        }
        if (object == null) {
            return this.env.remove(string);
        }
        object2 = this.env.put(string, object);
        switch (string.length()) {
            case 38: {
                if (!string.equals("weblogic.jndi.ssl.root.ca.fingerprints")) break;
                if (object instanceof String) {
                    this.setSSLRootCAFingerprints((String)object);
                    break;
                }
                if (!(object instanceof byte[][])) break;
                this.setSSLRootCAFingerprints((byte[][])object);
                break;
            }
            case 29: {
                if (!string.equals("weblogic.jndi.ssl.server.name") || !(object instanceof String)) break;
                this.setSSLServerName((String)object);
                break;
            }
            case 36: {
                if (!string.equals("weblogic.jndi.ssl.client.certificate") || !(object instanceof InputStream[])) break;
                this.setSSLClientCertificate((InputStream[])object);
                break;
            }
            case 37: {
                if (!string.equals("weblogic.jndi.ssl.client.key_password") || !(object instanceof String)) break;
                this.setSSLServerName((String)object);
            }
        }
        return object2;
    }

    public final Object removeProperty(String string) {
        return this.setProperty(string, null);
    }

    public final ServerIdentity getProviderIdentity() throws IllegalArgumentException {
        try {
            return (ServerIdentity)this.getPropertyFromEnv("weblogic.jndi.provider.rjvm");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Value of 'weblogic.jndi.provider.rjvm' is not a ServerIdentity object as expected");
        }
    }

    public final void setProviderIdentity(ServerIdentity serverIdentity) {
        this.setProperty("weblogic.jndi.provider.rjvm", serverIdentity);
    }

    Hashtable getRemoteProperties() {
        if (this.env == null) {
            return this.env;
        }
        Object v = this.env.get("weblogic.jndi.ssl.client.certificate");
        if (this.env.get("java.naming.security.principal") == null && this.env.get("java.naming.security.credentials") == null && this.env.get("weblogic.jndi.provider.rjvm") == null && v == null) {
            return this.env;
        }
        Hashtable hashtable = (Hashtable)this.env.clone();
        hashtable.remove("weblogic.jndi.provider.rjvm");
        hashtable.remove("java.naming.security.principal");
        hashtable.remove("java.naming.security.credentials");
        hashtable.remove("weblogic.jndi.ssl.client.certificate");
        return hashtable;
    }

    public void setEnableDefaultUser(boolean bl) {
        this.enableDefaultUser = bl;
    }

    public boolean getEnableDefaultUser() {
        return this.enableDefaultUser;
    }

    public final void loadLocalIdentity(Certificate[] certificateArray, PrivateKey privateKey) {
        this.findOrCreateSSLProxy().loadLocalIdentity(certificateArray, privateKey);
    }

    public final boolean isClientCertAvailable() {
        return this.findOrCreateSSLProxy().isClientCertAvailable();
    }

    public final boolean isLocalIdentitySet() {
        return this.findOrCreateSSLProxy().isLocalIdentitySet();
    }

    public final void setDisableLoggingOfWarningMsg(boolean bl) {
        this.setBoolean("weblogic.jndi.disableLoggingOfWarningMsg", bl);
    }

    public final boolean getDisableLoggingOfWarningMsg() {
        return this.getBoolean("weblogic.jndi.disableLoggingOfWarningMsg", false);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getRemoteProperties());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.env = (Hashtable)objectInput.readObject();
    }
}

