/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;

public class InitialContextFactoryWrapper
implements InitialContextFactory {
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final WeakHashMap factoryCache = new WeakHashMap(11);

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private Properties getProperties(final ClassLoader classLoader, final String string) throws IOException {
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
            }
        });
        Properties properties = new Properties();
        if (inputStream != null) {
            properties.load(inputStream);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInitialContextFactory() throws NamingException {
        ClassLoader classLoader = this.getContextClassLoader();
        WeakHashMap weakHashMap = factoryCache;
        synchronized (weakHashMap) {
            String string = (String)factoryCache.get(classLoader);
            if (string != null) {
                return string;
            }
            if (factoryCache.containsKey(classLoader)) {
                return null;
            }
            try {
                string = this.getProperties(classLoader, APP_RESOURCE_FILE_NAME).getProperty("java.naming.factory.initial");
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            factoryCache.put(classLoader, string);
            return string;
        }
    }

    public final Context getInitialContext(Hashtable hashtable) throws NamingException {
        InitialContextFactory initialContextFactory = null;
        String string = this.getInitialContextFactory();
        if (string == null) {
            string = DEFAULT_INITIAL_CONTEXT_FACTORY;
        }
        try {
            ClassLoader classLoader = this.getContextClassLoader();
            initialContextFactory = (InitialContextFactory)Class.forName(string, true, classLoader).newInstance();
        }
        catch (Exception exception) {
            NoInitialContextException noInitialContextException = new NoInitialContextException("Cannot instantiate class: " + string);
            noInitialContextException.setRootCause(exception);
            throw noInitialContextException;
        }
        return initialContextFactory.getInitialContext(hashtable);
    }
}

