/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ExceptionTranslator;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.NamingNodeReplicaHandler;
import weblogic.jndi.internal.WLContextImpl;
import weblogic.jndi.internal.WLEventContextImpl;
import weblogic.jndi.internal.WLInternalContext;
import weblogic.jndi.spi.EnvironmentFactory;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ProtocolStack;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.ServerURL;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.ClientMethodDescriptor;
import weblogic.rmi.internal.ClientRuntimeDescriptor;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.Utilities;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.RemoteAuthenticate;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public class WLInitialContextFactoryDelegate
implements InitialContextFactory,
EnvironmentFactory {
    private static final DebugLogger debugConnection;
    private static final AuthenticatedSubject kernelId;
    private static Class preload;
    private static final String ROOT_NAMING_NODE_CLASS_NAME = "weblogic.jndi.internal.ServerNamingNode";
    private static NamingNode rootNode;
    private static final String[] ROOT_NODE_INTERFACES;
    private static final ClientMethodDescriptor DESC;
    private static final Class[] STUB_INFO_CLASS;
    private static final ClientRuntimeDescriptor ROOT_NODE_DESCRIPTOR;
    private static final ReplicaAwareInfo NAMING_NODE_RA_INFO;
    private static boolean keepEnvironmentUntilContextClose;

    public static final WLInitialContextFactoryDelegate theOne() {
        return SingletonMaker.singleton;
    }

    public WLInitialContextFactoryDelegate() {
        JNDIEnvironment.getJNDIEnvironment().prepareKernel();
        JNDIEnvironment.getJNDIEnvironment().prepReferenceHelper();
    }

    public final Context getInitialContext(Hashtable hashtable) throws NamingException {
        Environment environment = new Environment(hashtable);
        return this.getInitialContext(environment, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Context getInitialContext(final Environment environment, String string, final HostID hostID) throws NamingException {
        CommunicationException communicationException = null;
        String string2 = environment.getProviderUrl();
        ServerIdentity serverIdentity = environment.getProviderIdentity();
        int n = serverIdentity != null ? 0 : 1;
        int i = 0;
        while (true) {
            if (i > n) {
                throw communicationException;
            }
            Object object = null;
            if (serverIdentity != null) {
                object = serverIdentity;
            } else if (string2 == "local://") {
                object = LocalServerIdentity.getIdentity();
            } else {
                Object var13_15;
                JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(environment);
                try {
                    try {
                        boolean bl;
                        final ServerURL serverURL = new ServerURL(environment.getProviderUrl());
                        object = environment.getSecurityPrincipal() != null || environment.getSecurityCredentials() != null ? (ServerIdentity)SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return serverURL.findOrCreateRJVM(environment.getEnableServerAffinity(), environment.getProviderChannel(), hostID, (int)environment.getRequestTimeout(), environment.getForceResolveDNSName()).getID();
                            }
                        }) : serverURL.findOrCreateRJVM(environment.getEnableServerAffinity(), environment.getProviderChannel(), hostID, (int)environment.getRequestTimeout(), environment.getForceResolveDNSName()).getID();
                        if (NamingDebugLogger.isDebugEnabled() && (bl = debugConnection.isDebugEnabled())) {
                            NamingDebugLogger.debug("Bootstrapping context from DNS " + string2);
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw this.toNamingException(privilegedActionException.getException());
                    }
                    catch (Exception exception) {
                        throw this.toNamingException(exception);
                    }
                    var13_15 = null;
                    JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                }
                catch (Throwable throwable) {
                    var13_15 = null;
                    JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                    throw throwable;
                }
            }
            try {
                return this.newContext((ServerIdentity)object, environment, string);
            }
            catch (CommunicationException communicationException2) {
                communicationException = communicationException2;
                ++i;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Remote getInitialReference(Environment environment, Class clazz) throws NamingException {
        String string = environment.getProviderUrl();
        ServerIdentity serverIdentity = environment.getProviderIdentity();
        if (serverIdentity == null) {
            if (string == "local://") {
                serverIdentity = LocalServerIdentity.getIdentity();
            } else {
                JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(environment);
                try {
                    try {
                        boolean bl;
                        serverIdentity = new ServerURL(string).findOrCreateRJVM(environment.getEnableServerAffinity(), environment.getProviderChannel(), null, (int)environment.getRequestTimeout(), environment.getForceResolveDNSName()).getID();
                        if (NamingDebugLogger.isDebugEnabled() && (bl = debugConnection.isDebugEnabled())) {
                            NamingDebugLogger.debug("Bootstrapping reference from DNS " + string);
                        }
                    }
                    catch (IOException iOException) {
                        throw this.toNamingException(iOException);
                    }
                    Object var7_8 = null;
                    JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                    throw throwable;
                }
            }
        }
        try {
            if (environment.getRequestTimeout() > 0L) {
                return (Remote)StubFactory.getStub((Class)clazz, (HostID)serverIdentity, (String)environment.getProviderChannel(), (ClientRuntimeDescriptor)this.getClientRuntimeDescriptor(clazz, environment.getRequestTimeout()));
            }
            return (Remote)StubFactory.getStub((Class)clazz, (HostID)serverIdentity, (String)environment.getProviderChannel());
        }
        catch (RemoteException remoteException) {
            throw this.toNamingException(remoteException);
        }
    }

    public Context getInitialContext(Environment environment, String string) throws NamingException {
        return this.getInitialContext(environment, string, null);
    }

    private ClientRuntimeDescriptor getClientRuntimeDescriptor(Class clazz, long l) {
        String[] stringArray = Utilities.getRemoteInterfaceNames((Class)clazz);
        ClientMethodDescriptor clientMethodDescriptor = new ClientMethodDescriptor("*", false, false, false, false, (int)l);
        return new ClientRuntimeDescriptor(stringArray, null, null, clientMethodDescriptor, ServerHelper.getStubClassName((String)clazz.getName())).intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Context newContext(ServerIdentity serverIdentity, Environment environment, String string) throws NamingException {
        Context context;
        block13: {
            context = null;
            JNDIEnvironment.getJNDIEnvironment().pushThreadEnvironment(environment);
            try {
                this.pushSubject(environment, serverIdentity);
                JNDIEnvironment.getJNDIEnvironment().activateTransactionHelper();
                try {
                    block11: {
                        try {
                            long l;
                            context = serverIdentity.isLocal() ? this.newLocalContext(environment, string) : this.newRemoteContext(serverIdentity, environment, string);
                            if (environment.getSecurityUser() != null || environment.isClientCertAvailable() || environment.isLocalIdentitySet()) {
                                ((WLInternalContext)context).enableLogoutOnClose();
                            }
                            if ((l = environment.getRMIClientTimeout()) <= 0L) break block11;
                            RemoteHelper.setClientTimeout((long)l);
                        }
                        catch (RemoteException remoteException) {
                            throw this.toNamingException(remoteException);
                        }
                        catch (NamingException namingException) {
                            throw namingException;
                        }
                    }
                    Object var8_8 = null;
                    if (context == null) {
                        this.popSubject(environment);
                        JNDIEnvironment.getJNDIEnvironment().deactivateTransactionHelper();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (context == null) {
                        this.popSubject(environment);
                        JNDIEnvironment.getJNDIEnvironment().deactivateTransactionHelper();
                    }
                    throw throwable;
                }
                Object var10_11 = null;
                if (keepEnvironmentUntilContextClose) break block13;
                JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (!keepEnvironmentUntilContextClose) {
                    JNDIEnvironment.getJNDIEnvironment().popThreadEnvironment();
                }
                throw throwable;
            }
            {
            }
        }
        return context;
    }

    private final Context newLocalContext(Environment environment, String string) throws NamingException {
        Debug.assertion((Thread.currentThread().getContextClassLoader() != null ? 1 : 0) != 0, (String)"ContextClassLoader == null");
        Hashtable hashtable = environment.getDelegateEnvironment();
        if (hashtable != null) {
            this.popSubject(environment);
            return NamingManager.getInitialContext(hashtable);
        }
        try {
            NamingNode namingNode = this.getRootNode();
            WLEventContextImpl wLEventContextImpl = null;
            Hashtable hashtable2 = environment.getProperties();
            wLEventContextImpl = new WLEventContextImpl(hashtable2, namingNode);
            if (string == null || string.length() == 0) {
                return wLEventContextImpl;
            }
            return (Context)wLEventContextImpl.lookup(string);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new NoInitialContextException("JNDI subsystem is not ready for use ");
        }
    }

    private NamingNode getRootNode() throws NoSuchObjectException {
        if (rootNode == null) {
            rootNode = (NamingNode)ServerHelper.getRemoteObject((int)9);
        }
        return rootNode;
    }

    private final Context newRemoteContext(ServerIdentity serverIdentity, Environment environment, String string) throws NamingException, RemoteException {
        Hashtable hashtable = environment.getDelegateEnvironment();
        if (hashtable != null) {
            return JNDIEnvironment.getJNDIEnvironment().getDelegateContext(serverIdentity, environment, string);
        }
        BasicRemoteRef basicRemoteRef = new BasicRemoteRef(9, (HostID)serverIdentity, environment.getProviderChannel());
        NamingNode namingNode = this.newRootNamingNodeStub((RemoteReference)basicRemoteRef, (int)environment.getRequestTimeout());
        WLContextImpl wLContextImpl = new WLContextImpl(environment.getRemoteProperties(), namingNode);
        if (string == null || string.length() == 0) {
            return wLContextImpl;
        }
        return (Context)wLContextImpl.lookup(string);
    }

    private NamingNode newRootNamingNodeStub(RemoteReference remoteReference, int n) {
        ClientRuntimeDescriptor clientRuntimeDescriptor = n == 0 ? ROOT_NODE_DESCRIPTOR : this.getClientRuntimeDescriptorWithTimeout(n);
        ClusterableRemoteRef clusterableRemoteRef = new ClusterableRemoteRef(remoteReference);
        clusterableRemoteRef.initialize(NAMING_NODE_RA_INFO);
        StubInfo stubInfo = new StubInfo((RemoteReference)clusterableRemoteRef, clientRuntimeDescriptor, ServerHelper.getStubClassName((String)ROOT_NAMING_NODE_CLASS_NAME));
        try {
            Class<?> clazz = Class.forName(ServerHelper.getStubClassName((String)ROOT_NAMING_NODE_CLASS_NAME));
            Constructor<?> constructor = clazz.getConstructor(STUB_INFO_CLASS);
            return (NamingNode)constructor.newInstance(stubInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private ClientRuntimeDescriptor getClientRuntimeDescriptorWithTimeout(int n) {
        ClientMethodDescriptor clientMethodDescriptor = new ClientMethodDescriptor("*", false, false, false, false, n);
        return new ClientRuntimeDescriptor(ROOT_NODE_INTERFACES, null, null, clientMethodDescriptor, ServerHelper.getStubClassName((String)ROOT_NAMING_NODE_CLASS_NAME));
    }

    private final void pushSubject(Environment environment, ServerIdentity serverIdentity) throws NamingException {
        Protocol protocol = null;
        try {
            protocol = this.getProtocol(environment);
            WLInitialContextFactoryDelegate.pushProtocol(environment, protocol);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
        UserInfo userInfo = environment.getSecurityUser();
        if (userInfo == null && protocol.isSecure() && (environment.isClientCertAvailable() || environment.isLocalIdentitySet())) {
            userInfo = new DefaultUserInfoImpl(null, null);
        }
        Object var5_6 = null;
        boolean bl = serverIdentity.isLocal();
        AuthenticatedSubject authenticatedSubject = null;
        if (userInfo != null) {
            authenticatedSubject = environment.getSecuritySubject();
            if (authenticatedSubject != null) {
                authenticatedSubject = environment.getSecuritySubject();
            } else {
                if (bl) {
                    try {
                        authenticatedSubject = this.authenticateLocally(userInfo);
                    }
                    catch (LoginException loginException) {
                        WLInitialContextFactoryDelegate.popProtocol(environment);
                        throw this.toNamingException(loginException);
                    }
                }
                try {
                    authenticatedSubject = this.authenticateRemotely(protocol, environment, userInfo, serverIdentity);
                }
                catch (SecurityException securityException) {
                    WLInitialContextFactoryDelegate.popProtocol(environment);
                    throw this.toNamingException(securityException);
                }
                catch (RemoteException remoteException) {
                    WLInitialContextFactoryDelegate.popProtocol(environment);
                    throw this.toNamingException(remoteException);
                }
            }
        }
        if (authenticatedSubject != null) {
            environment.setSecuritySubject(authenticatedSubject);
            JNDIEnvironment.getJNDIEnvironment().pushSubject(kernelId, authenticatedSubject);
        }
    }

    private AuthenticatedSubject authenticateLocally(UserInfo userInfo) throws LoginException {
        String string = "weblogicDEFAULT";
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        AuthenticatedSubject authenticatedSubject = null;
        if (userInfo instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(defaultUserInfoImpl.getName(), defaultUserInfoImpl.getPassword());
            authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)simpleCallbackHandler);
        }
        return authenticatedSubject;
    }

    private Protocol getProtocol(Environment environment) throws MalformedURLException {
        String string = environment.getProviderUrl();
        Protocol protocol = null;
        protocol = string == "local://" ? ProtocolManager.getProtocolByName((String)"t3") : ProtocolManager.getProtocolByName((String)new ServerURL(string).getProtocol());
        if (protocol.isUnknown()) {
            throw new MalformedURLException("No support for protocol: " + string);
        }
        return protocol;
    }

    private AuthenticatedSubject authenticateRemotely(Protocol protocol, Environment environment, UserInfo userInfo, ServerIdentity serverIdentity) throws RemoteException {
        RJVM rJVM = RJVMManager.getRJVMManager().findOrCreate((JVMID)serverIdentity);
        AuthenticatedUser authenticatedUser = RemoteAuthenticate.authenticate(userInfo, rJVM, protocol, environment.getProviderChannel(), environment.getRequestTimeout(), environment.getEnableDefaultUser());
        rJVM.setUser(authenticatedUser);
        return JNDIEnvironment.getJNDIEnvironment().getASFromAU(authenticatedUser);
    }

    private void popSubject(Environment environment) {
        WLInitialContextFactoryDelegate.popProtocol(environment);
        if (environment.getSecuritySubject() != null) {
            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
            JNDIEnvironment.getJNDIEnvironment().popSubject(kernelId);
        }
    }

    private static void pushProtocol(Environment environment, Protocol protocol) {
        if (environment.getProviderUrl() != "local://") {
            ProtocolStack.push((Protocol)protocol);
        }
    }

    private static void popProtocol(Environment environment) {
        if (environment.getProviderUrl() != "local://") {
            ProtocolStack.pop();
        }
    }

    private final NamingException toNamingException(Throwable throwable) {
        boolean bl;
        NamingException namingException = ExceptionTranslator.toNamingException(throwable);
        if (NamingDebugLogger.isDebugEnabled() && (bl = debugConnection.isDebugEnabled()) && namingException instanceof CommunicationException) {
            String string = StackTraceUtils.throwable2StackTrace((Throwable)namingException.getRootCause());
            NamingDebugLogger.debug("Failed to create initial context due to: " + string);
        }
        return namingException;
    }

    static {
        String string;
        JNDIEnvironment.getJNDIEnvironment().prepareSubjectManager();
        debugConnection = DebugLogger.getDebugLogger((String)"DebugConnection");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        preload = ExceptionTranslator.class;
        ROOT_NODE_INTERFACES = new String[]{NamingNode.class.getName(), StubInfoIntf.class.getName()};
        DESC = new ClientMethodDescriptor("*", false, false, false, false, 0);
        STUB_INFO_CLASS = new Class[]{StubInfo.class};
        ROOT_NODE_DESCRIPTOR = new ClientRuntimeDescriptor(ROOT_NODE_INTERFACES, null, null, DESC, ServerHelper.getStubClassName((String)ROOT_NAMING_NODE_CLASS_NAME)).intern();
        NAMING_NODE_RA_INFO = new ReplicaAwareInfo("", NamingNodeReplicaHandler.class);
        keepEnvironmentUntilContextClose = false;
        if (KernelStatus.isServer() && (string = System.getProperty("weblogic.jndi.retainenvironment")) != null) {
            keepEnvironmentUntilContextClose = true;
        }
    }

    static class SingletonMaker {
        static final WLInitialContextFactoryDelegate singleton = new WLInitialContextFactoryDelegate();

        SingletonMaker() {
        }
    }
}

