/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.common.internal.ReplacerObjectInputStream;
import weblogic.common.internal.ReplacerObjectOutputStream;
import weblogic.corba.idl.CorbaStub;
import weblogic.corba.server.naming.ReferenceHelperImpl;
import weblogic.iiop.IIOPReplacer;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.BuiltinTransportableObjectFactory;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.JNDIHelper;
import weblogic.jndi.internal.RemoteContextFactory;
import weblogic.jndi.internal.RemoteContextFactoryImpl;
import weblogic.jndi.internal.SSL.SSLProxy;
import weblogic.jndi.internal.SSL.WLSSSLProxyImpl;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.Security;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.SubjectManagerImpl;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.TransactionHelperImpl;
import weblogic.utils.io.Replacer;

public class WLSJNDIEnvironmentImpl
extends JNDIEnvironment {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Replacer iiopReplacer = IIOPReplacer.getReplacer();

    public SSLProxy getSSLProxy() {
        return new WLSSSLProxyImpl();
    }

    public boolean isCorbaObject(Object object) {
        return JNDIHelper.isCorbaObject(object);
    }

    public Object copyObject(Object object) throws IOException, ClassNotFoundException {
        return JNDIHelper.copyObject(object);
    }

    public void prepareKernel() {
        Kernel.ensureInitialized();
    }

    public void prepReferenceHelper() {
        ReferenceHelper.setReferenceHelper((ReferenceHelper)new ReferenceHelperImpl());
    }

    public void nullSSLClientCertificate() {
        Security.setSSLClientCertificate(null);
    }

    public Object iiopReplaceObject(Object object) throws IOException {
        return iiopReplacer.replaceObject(object);
    }

    public Object iiopResolveObject(Object object) throws IOException {
        return iiopReplacer.resolveObject(object);
    }

    public boolean isCorbaStub(Object object) {
        return object instanceof CorbaStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTransportableFactories(List list) throws ConfigurationException {
        String[] stringArray = ManagementService.getRuntimeAccess(kernelId).getServer().getJNDITransportableObjectFactoryList();
        BuiltinTransportableObjectFactory builtinTransportableObjectFactory = new BuiltinTransportableObjectFactory();
        List list2 = list;
        synchronized (list2) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    try {
                        list.add(Class.forName(string).newInstance());
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ConfigurationException configurationException = new ConfigurationException("Failed to find class \"" + string);
                        configurationException.setRootCause(classNotFoundException);
                        throw configurationException;
                    }
                    catch (InstantiationException instantiationException) {
                        ConfigurationException configurationException = new ConfigurationException("Failed to instantiate \"" + string + ".  Make sure it has a public default constructor.");
                        configurationException.setRootCause(instantiationException);
                        throw configurationException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        ConfigurationException configurationException = new ConfigurationException("Failed to instantiate \"" + string + " because the default constuctor is not public.");
                        configurationException.setRootCause(illegalAccessException);
                        throw configurationException;
                    }
                }
            }
            if (builtinTransportableObjectFactory != null) {
                list.add(builtinTransportableObjectFactory);
            }
        }
    }

    public Context getDelegateContext(ServerIdentity serverIdentity, Environment environment, String string) throws RemoteException, NamingException {
        RemoteContextFactory remoteContextFactory = (RemoteContextFactory)StubFactory.getStub(RemoteContextFactoryImpl.class, (HostID)serverIdentity);
        return remoteContextFactory.getContext(environment.getRemoteProperties(), string);
    }

    public void prepareSubjectManager() {
        SubjectManagerImpl.ensureInitialized();
    }

    public void activateTransactionHelper() {
        TransactionHelper.pushTransactionHelper((TransactionHelper)new TransactionHelperImpl());
    }

    public void deactivateTransactionHelper() {
        TransactionHelper.popTransactionHelper();
    }

    public void pushThreadEnvironment(Environment environment) {
        ThreadEnvironment.push(environment);
    }

    public Environment popThreadEnvironment() {
        return ThreadEnvironment.pop();
    }

    public void pushSubject(AuthenticatedSubject authenticatedSubject, AuthenticatedSubject authenticatedSubject2) {
        SecurityServiceManager.pushSubject((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject2);
    }

    public void popSubject(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.popSubject((AuthenticatedSubject)authenticatedSubject);
    }

    public AuthenticatedSubject getCurrentSubject(AuthenticatedSubject authenticatedSubject) {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)authenticatedSubject);
    }

    public AuthenticatedSubject getASFromAU(AuthenticatedUser authenticatedUser) {
        return SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser);
    }

    public ObjectOutput getReplacerObjectOutputStream(ObjectOutput objectOutput) throws IOException {
        ReplacerObjectOutputStream replacerObjectOutputStream = new ReplacerObjectOutputStream((OutputStream)((Object)objectOutput), RemoteObjectReplacer.getReplacer());
        replacerObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
        return replacerObjectOutputStream;
    }

    public ObjectInput getReplacerObjectInputStream(ObjectInput objectInput) throws IOException {
        return new ReplacerObjectInputStream((InputStream)((Object)objectInput), RemoteObjectReplacer.getReplacer(), null);
    }
}

