/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.factories.java;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;

public final class ReadOnlyContextWrapper
implements EventContext {
    private final Context context;
    private final EventContext eventContext;

    public ReadOnlyContextWrapper(Context context) {
        this.context = context;
        this.eventContext = context instanceof EventContext ? (EventContext)context : null;
    }

    public String getNameInNamespace() throws NamingException {
        return this.context.getNameInNamespace();
    }

    public void close() throws NamingException {
        this.context.close();
    }

    public Object lookup(Name name) throws NamingException {
        return this.wrapIfContext(this.context.lookup(name));
    }

    public Object lookup(String string) throws NamingException {
        return this.wrapIfContext(this.context.lookup(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.wrapIfContext(this.context.lookupLink(name));
    }

    public Object lookupLink(String string) throws NamingException {
        return this.wrapIfContext(this.context.lookupLink(string));
    }

    public void bind(Name name, Object object) throws NamingException {
        throw this.newOperationNotSupportedException("bind", name);
    }

    public void bind(String string, Object object) throws NamingException {
        throw this.newOperationNotSupportedException("bind", string);
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw this.newOperationNotSupportedException("rebind", name);
    }

    public void rebind(String string, Object object) throws NamingException {
        throw this.newOperationNotSupportedException("rebind", string);
    }

    public void unbind(Name name) throws NamingException {
        throw this.newOperationNotSupportedException("unbind", name);
    }

    public void unbind(String string) throws NamingException {
        throw this.newOperationNotSupportedException("unbind", string);
    }

    public void rename(Name name, Name name2) throws NamingException {
        throw this.newOperationNotSupportedException("rename", name);
    }

    public void rename(String string, String string2) throws NamingException {
        throw this.newOperationNotSupportedException("rename", string);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.context.list(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.context.list(string);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.context.listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.context.listBindings(string);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.context.getNameParser(name);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.context.getNameParser(string);
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return this.context.composeName(name, name2);
    }

    public String composeName(String string, String string2) throws NamingException {
        return this.context.composeName(string, string2);
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw this.newOperationNotSupportedException("createSubcontext", name);
    }

    public Context createSubcontext(String string) throws NamingException {
        throw this.newOperationNotSupportedException("createSubcontext", string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw this.newOperationNotSupportedException("destroySubcontext", name);
    }

    public void destroySubcontext(String string) throws NamingException {
        throw this.newOperationNotSupportedException("destroySubcontext", string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.context.getEnvironment();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.context.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.context.removeFromEnvironment(string);
    }

    public String toString() {
        return this.context.toString();
    }

    private Object wrapIfContext(Object object) {
        if (!(object instanceof ReadOnlyContextWrapper) && object instanceof Context) {
            return new ReadOnlyContextWrapper((Context)object);
        }
        return object;
    }

    private OperationNotSupportedException newOperationNotSupportedException(String string, Name name) {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException(string + " not allowed in a ReadOnlyContext");
        operationNotSupportedException.setRemainingName(name);
        return operationNotSupportedException;
    }

    private OperationNotSupportedException newOperationNotSupportedException(String string, String string2) {
        CompositeName compositeName = null;
        try {
            compositeName = new CompositeName(string2);
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return this.newOperationNotSupportedException(string, compositeName);
    }

    public void addNamingListener(Name name, int n, NamingListener namingListener) throws NamingException {
        this.addNamingListener(name.toString(), n, namingListener);
    }

    public void addNamingListener(String string, int n, NamingListener namingListener) throws NamingException {
        if (this.eventContext != null) {
            this.eventContext.addNamingListener(string, n, namingListener);
        }
    }

    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        if (this.eventContext != null) {
            this.eventContext.removeNamingListener(namingListener);
        }
    }

    public boolean targetMustExist() throws NamingException {
        return true;
    }
}

