/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.factories.java;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.ejb20.portable.HandleDelegateImpl;
import weblogic.j2eeclient.SimpleContext;
import weblogic.jndi.factories.java.ReadOnlyContextWrapper;
import weblogic.jndi.internal.AbstractURLContext;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.ThreadLocalStack;
import weblogic.management.internal.SecurityHelper;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.transaction.TransactionHelper;
import weblogic.work.j2ee.J2EEWorkManager;
import weblogic.workarea.WorkContextHelper;

public final class javaURLContextFactory
implements ObjectFactory {
    private static Object runtimeMBeanServer = null;
    private static Object domainRuntimeMBeanServer = null;
    private static ThreadLocalStack threadContext = new ThreadLocalStack(true);

    public static void setRuntimeMBeanServer(Object object) {
        if (runtimeMBeanServer != null) {
            throw new AssertionError((Object)"The RuntimeMBeanServer can only be established once.");
        }
        runtimeMBeanServer = object;
    }

    public static void setDomainRuntimeMBeanServer(Object object) {
        if (domainRuntimeMBeanServer != null) {
            throw new AssertionError((Object)"The DomainRuntimeMBeanServer can only be establised once.");
        }
        domainRuntimeMBeanServer = object;
    }

    public static void pushContext(Context context) {
        threadContext.push((Object)context);
    }

    public static void popContext() {
        threadContext.pop();
    }

    public static Context getDefaultContext(AuthenticatedSubject authenticatedSubject) {
        SecurityHelper.assertIfNotKernel(authenticatedSubject);
        return DefaultContextMaker.DEFAULT_CONTEXT;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Context context2 = (Context)threadContext.peek();
        if (context2 == null) {
            context2 = DefaultContextMaker.DEFAULT_CONTEXT;
        }
        if (context2 instanceof JavaURLContext) {
            return context2;
        }
        if (!(context2 instanceof ReadOnlyContextWrapper)) {
            context2 = new ReadOnlyContextWrapper(context2);
        }
        return new JavaURLContext(context2, hashtable);
    }

    public static void main(String[] stringArray) throws Exception {
        new javaURLContextFactory().getObjectInstance((Object)null, (Name)null, (Context)null, (Hashtable)null);
    }

    private static class JavaURLContext
    extends AbstractURLContext {
        private Context actualCtx;

        public JavaURLContext(Context context, Hashtable hashtable) {
            this.actualCtx = context;
        }

        protected String removeURL(String string) throws InvalidNameException {
            if (string.startsWith("java:comp/") || string.startsWith("java:global/")) {
                return string.substring(5);
            }
            return super.removeURL(string);
        }

        protected Context getContext(String string) throws NamingException {
            return this.actualCtx;
        }
    }

    private static final class DefaultContextMaker {
        private static final Context DEFAULT_CONTEXT = DefaultContextMaker.createDefaultContext();

        private DefaultContextMaker() {
        }

        private static final Context createDefaultContext() {
            SimpleContext simpleContext = new SimpleContext();
            HandleDelegateImpl handleDelegateImpl = null;
            try {
                Context context = simpleContext.createSubcontext("comp");
                context.bind("UserTransaction", (Object)new SimpleContext.SimpleReference(){

                    public Object get() throws NamingException {
                        return TransactionHelper.getTransactionHelper().getUserTransaction();
                    }
                });
                context.bind("TransactionSynchronizationRegistry", (Object)new SimpleContext.SimpleReference(){

                    public Object get() throws NamingException {
                        return TransactionHelper.getTransactionHelper().getTransactionManager();
                    }
                });
                if (!KernelStatus.isServer()) {
                    handleDelegateImpl = new weblogic.ejb20.internal.HandleDelegateImpl();
                } else {
                    handleDelegateImpl = new HandleDelegateImpl();
                    Context context2 = context.createSubcontext("jmx");
                    context2.bind("runtime", (Object)new SimpleContext.SimpleReference(){

                        public Object get() throws NamingException {
                            return runtimeMBeanServer;
                        }
                    });
                    context2.bind("domainRuntime", (Object)new SimpleContext.SimpleReference(){

                        public Object get() throws NamingException {
                            return domainRuntimeMBeanServer;
                        }
                    });
                    Context context3 = simpleContext.createSubcontext("global");
                    Context context4 = context3.createSubcontext("wm");
                    context4.bind("default", (Object)new SimpleContext.SimpleReference(){

                        public Object get() throws NamingException {
                            return J2EEWorkManager.getDefault();
                        }
                    });
                }
                context.bind("HandleDelegate", (Object)handleDelegateImpl);
                WorkContextHelper.bind((Context)context);
                DisconnectMonitorListImpl.bindToJNDI((Context)context);
                context.bind("ORB", (Object)new SimpleContext.SimpleReference(){

                    public Object get() throws NamingException {
                        return ORBHelper.getORBHelper().getLocalORB();
                    }
                });
            }
            catch (NamingException namingException) {
                throw new AssertionError((Object)namingException);
            }
            return simpleContext;
        }
    }
}

