/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.factories.t3;

import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.jndi.internal.AbstractURLContext;
import weblogic.protocol.ServerURL;

public class t3URLContextFactory
implements ObjectFactory {
    private static final boolean DEBUG = false;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        }
        return new T3Context(hashtable, string);
    }

    private static final void p(String string) {
        System.out.println("<t3URLContextFactory>: " + string);
    }

    private static class T3Context
    extends AbstractURLContext {
        private Hashtable env;
        private ServerURL url;

        public T3Context(Hashtable hashtable, String string) throws InvalidNameException {
            this.env = hashtable;
            if (string != null) {
                try {
                    this.url = new ServerURL(ServerURL.DEFAULT_URL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    InvalidNameException invalidNameException = new InvalidNameException();
                    invalidNameException.setRootCause(malformedURLException);
                    throw invalidNameException;
                }
            } else {
                this.url = ServerURL.DEFAULT_URL;
            }
        }

        protected String getURL(String string) throws InvalidNameException {
            try {
                if (string.indexOf(":") < 0) {
                    return this.url.asUnsyncStringBuffer().append(string).toString();
                }
                return new ServerURL(this.url, string).asUnsyncStringBuffer().toString();
            }
            catch (MalformedURLException malformedURLException) {
                InvalidNameException invalidNameException = new InvalidNameException();
                invalidNameException.setRootCause(malformedURLException);
                throw invalidNameException;
            }
        }

        protected Context getContext(String string) throws NamingException {
            if (this.env == null) {
                this.env = new Hashtable(5);
            }
            this.env.put("java.naming.provider.url", this.getURL(string));
            this.env.put("java.naming.factory.initial", WLInitialContextFactory.class.getName());
            return new InitialContext(this.env);
        }
    }
}

