/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.ServerNamingNode;

class AbstractAdminModeHandler {
    protected final ServerNamingNode node;
    private HashSet adminModeSet = new HashSet();
    private final Object adminModeSetLock = new String("AdminModeSetLock");
    protected final boolean debug = NamingDebugLogger.isDebugEnabled();

    AbstractAdminModeHandler(ServerNamingNode serverNamingNode) {
        this.node = serverNamingNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAdminModeBindings() {
        HashSet hashSet = null;
        Object object = this.adminModeSetLock;
        synchronized (object) {
            hashSet = this.adminModeSet;
        }
        return hashSet.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAdminMode(String string) {
        HashSet hashSet = null;
        Object object = this.adminModeSetLock;
        synchronized (object) {
            hashSet = this.adminModeSet;
        }
        if (hashSet.size() == 0) {
            return false;
        }
        return hashSet.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAdminMode(String string) {
        Object object = this.adminModeSetLock;
        synchronized (object) {
            HashSet<String> hashSet = new HashSet<String>(this.adminModeSet);
            if (this.debug) {
                NamingDebugLogger.debug("+++ AdminMode.setAdminMode name=" + string + ", ns=" + this.node.getNameInNamespace() + ", this=" + this);
            }
            hashSet.add(string);
            this.adminModeSet = hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetAdminMode(String string) {
        Object object = this.adminModeSetLock;
        synchronized (object) {
            if (this.adminModeSet.size() == 0) {
                return;
            }
            HashSet hashSet = new HashSet(this.adminModeSet);
            if (this.debug) {
                NamingDebugLogger.debug("+++ AdminMode.unsetAdminMode name=" + string + ", ns=" + this.node.getNameInNamespace() + ", this=" + this);
            }
            hashSet.remove(string);
            this.adminModeSet = hashSet;
        }
    }

    Set getAccessibleBindings(Set set) {
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ AdminMode.getAccessibleBindings hasAdminModeBindings=" + this.hasAdminModeBindings() + ", adminRequest=" + ApplicationVersionUtils.isAdminModeRequest() + ", this=" + this + ", ns=" + this.node.getNameInNamespace());
        }
        if (!this.hasAdminModeBindings() || ApplicationVersionUtils.isAdminModeRequest()) {
            return set;
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : set) {
            if (!this.isAdminMode((String)entry.getKey())) {
                if (NamingDebugLogger.isDebugEnabled()) {
                    NamingDebugLogger.debug("++++ non-admin binding: " + entry.getKey());
                }
                hashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!NamingDebugLogger.isDebugEnabled()) continue;
            NamingDebugLogger.debug("++++ admin binding: " + entry.getKey());
        }
        return hashMap.entrySet();
    }
}

