/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import weblogic.protocol.ServerURL;

public abstract class AbstractURLContext
implements Context {
    protected abstract Context getContext(String var1) throws NamingException;

    protected String removeURL(String string) throws InvalidNameException {
        try {
            if (string.indexOf(":") < 0) {
                return string;
            }
            return new ServerURL(ServerURL.DEFAULT_URL, string).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            InvalidNameException invalidNameException = new InvalidNameException();
            invalidNameException.setRootCause(malformedURLException);
            throw invalidNameException;
        }
    }

    public final Object addToEnvironment(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final void bind(String string, Object object) throws NamingException {
        this.getContext(string).bind(this.removeURL(string), object);
    }

    public final void bind(Name name, Object object) throws NamingException {
        this.getContext(name.toString()).bind(this.removeURL(name.toString()), object);
    }

    public final void close() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final String composeName(String string, String string2) throws NamingException {
        return string;
    }

    public final Name composeName(Name name, Name name2) throws NamingException {
        return (Name)name.clone();
    }

    public final Context createSubcontext(String string) throws NamingException {
        return this.getContext(string).createSubcontext(this.removeURL(string));
    }

    public final Context createSubcontext(Name name) throws NamingException {
        return this.getContext(name.toString()).createSubcontext(this.removeURL(name.toString()));
    }

    public final void destroySubcontext(String string) throws NamingException {
        this.getContext(string).destroySubcontext(this.removeURL(string));
    }

    public final void destroySubcontext(Name name) throws NamingException {
        this.getContext(name.toString()).destroySubcontext(this.removeURL(name.toString()));
    }

    public final Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final NameParser getNameParser(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final NamingEnumeration list(String string) throws NamingException {
        return this.getContext(string).list(this.removeURL(string));
    }

    public final NamingEnumeration list(Name name) throws NamingException {
        return this.getContext(name.toString()).list(this.removeURL(name.toString()));
    }

    public final NamingEnumeration listBindings(String string) throws NamingException {
        return this.getContext(string).listBindings(this.removeURL(string));
    }

    public final NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getContext(name.toString()).listBindings(this.removeURL(name.toString()));
    }

    public final Object lookup(String string) throws NamingException {
        return this.getContext(string).lookup(this.removeURL(string));
    }

    public final Object lookup(Name name) throws NamingException {
        return this.getContext(name.toString()).lookup(this.removeURL(name.toString()));
    }

    public final Object lookupLink(String string) throws NamingException {
        return this.getContext(string).lookupLink(this.removeURL(string));
    }

    public final Object lookupLink(Name name) throws NamingException {
        return this.getContext(name.toString()).lookupLink(this.removeURL(name.toString()));
    }

    public final void rebind(String string, Object object) throws NamingException {
        this.getContext(string).rebind(this.removeURL(string), object);
    }

    public final void rebind(Name name, Object object) throws NamingException {
        this.getContext(name.toString()).rebind(this.removeURL(name.toString()), object);
    }

    public final Object removeFromEnvironment(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public final void rename(String string, String string2) throws NamingException {
        this.getContext(string).rename(this.removeURL(string), string2);
    }

    public final void rename(Name name, Name name2) throws NamingException {
        this.getContext(name.toString()).rename(this.removeURL(name.toString()), name2.toString());
    }

    public final void unbind(String string) throws NamingException {
        this.getContext(string).unbind(this.removeURL(string));
    }

    public final void unbind(Name name) throws NamingException {
        this.getContext(name.toString()).unbind(this.removeURL(name.toString()));
    }
}

