/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jndi.internal.AbstractAdminModeHandler;
import weblogic.jndi.internal.AdminModeAccessException;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.ServerNamingNode;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

final class AdminModeHandler
extends AbstractAdminModeHandler {
    private Hashtable listeners = new Hashtable();

    AdminModeHandler(ServerNamingNode serverNamingNode) {
        super(serverNamingNode);
    }

    private void addListener(ApplicationRuntimeMBean applicationRuntimeMBean, String string, AdminModeStateChangeListener adminModeStateChangeListener) {
        AdminModeStateChangeListener adminModeStateChangeListener2;
        if (this.debug) {
            NamingDebugLogger.debug("+++ AdminMode.addListener: name=" + string + ")");
        }
        if ((adminModeStateChangeListener2 = this.listeners.put(string, adminModeStateChangeListener)) != null) {
            applicationRuntimeMBean.removePropertyChangeListener(adminModeStateChangeListener2);
        }
        applicationRuntimeMBean.addPropertyChangeListener(adminModeStateChangeListener);
    }

    private void removeListener(String string) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AdminModeStateChangeListener adminModeStateChangeListener = (AdminModeStateChangeListener)this.listeners.remove(string);
        if (adminModeStateChangeListener == null) {
            return;
        }
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getCurrentApplicationRuntime();
        if (applicationRuntimeMBean == null) {
            return;
        }
        if (this.debug) {
            NamingDebugLogger.debug("+++ AdminMode.removeListener: name=" + string);
        }
        ((RuntimeMBeanDelegate)applicationRuntimeMBean).removePropertyChangeListener((PropertyChangeListener)adminModeStateChangeListener);
    }

    void checkBind(String string, boolean bl) {
        if (bl) {
            return;
        }
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getCurrentApplicationRuntime();
        if (applicationRuntimeMBean == null) {
            return;
        }
        this.addListener(applicationRuntimeMBean, string, new AdminModeStateChangeListener(string, this));
        if (applicationRuntimeMBean.getActiveVersionState() == 1) {
            this.setAdminMode(string);
        }
    }

    void checkLookup(String string, String string2, Hashtable hashtable) throws NameNotFoundException {
        if (string2 != null && string2.length() > 0 || this.node.isVersioned() || !this.isAdminMode(string)) {
            return;
        }
        if (this.debug) {
            NamingDebugLogger.debug("+++ AdminMode.checkLookup: Attempt to look up admin mode binding, name=" + string + "), " + "adminRequest=" + ApplicationVersionUtils.isAdminModeRequest());
        }
        if (!ApplicationVersionUtils.isAdminModeRequest()) {
            if (this.debug) {
                NamingDebugLogger.debug("+++ AdminMode.checkLookup failed", new Exception());
            }
            throw this.node.newNameNotFoundException(new AdminModeAccessException("Unable to resolve '" + string + "'. Resolved '" + this.node.getNameInNamespace() + "'"), string2, hashtable);
        }
    }

    void checkUnbind(String string, boolean bl) {
        if (bl) {
            return;
        }
        this.unsetAdminMode(string);
        this.removeListener(string);
    }

    private final class AdminModeStateChangeListener
    implements PropertyChangeListener {
        String name;
        AdminModeHandler handler;

        private AdminModeStateChangeListener(String string, AdminModeHandler adminModeHandler2) {
            this.name = string;
            this.handler = adminModeHandler2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("ActiveVersionState")) {
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (object instanceof Integer && object2 instanceof Integer) {
                    int n = (Integer)object;
                    int n2 = (Integer)object2;
                    if (AdminModeHandler.this.debug) {
                        NamingDebugLogger.debug("+++ AdminModeStateChange for name=" + this.name + ", oldState=" + n + ", newState=" + n2);
                    }
                    if (n == n2) {
                        return;
                    }
                    if (n == 1) {
                        this.handler.unsetAdminMode(this.name);
                    } else if (n2 == 1) {
                        this.handler.setAdminMode(this.name);
                    }
                    if (n2 == 0) {
                        this.handler.removeListener(this.name);
                    }
                }
            }
        }
    }
}

