/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import weblogic.jndi.Environment;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.internal.ApplicationNamingInfo;
import weblogic.jndi.internal.BasicNamingNode;
import weblogic.jndi.internal.ForceCallByReference;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.WLEventContextImpl;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.CBVWrapper;
import weblogic.utils.classloaders.ClassLoaderUtils;

public class ApplicationNamingNode
extends BasicNamingNode {
    private static final String DEFAULT_SEPARATORS = "/";
    private String separators;
    private static final boolean DEBUG = false;
    private final ConcurrentHashMap cache = new ConcurrentHashMap(1);
    private String relativeName = "";
    ApplicationNamingNode parent;
    private final ApplicationNamingInfo info;

    public ApplicationNamingNode() {
        this(DEFAULT_SEPARATORS, null, "", null);
    }

    public ApplicationNamingNode(String string, ApplicationNamingInfo applicationNamingInfo) {
        this(string, null, "", applicationNamingInfo);
    }

    public ApplicationNamingNode(String string) {
        this(string, null, "", null);
    }

    public ApplicationNamingNode(String string, ApplicationNamingNode applicationNamingNode, String string2, ApplicationNamingInfo applicationNamingInfo) {
        super(string, applicationNamingNode, string2);
        this.separators = string;
        this.relativeName = string2;
        this.parent = applicationNamingNode;
        this.info = applicationNamingInfo == null ? new ApplicationNamingInfo() : applicationNamingInfo;
    }

    protected BasicNamingNode newSubnode(String string) {
        return new ApplicationNamingNode(this.separators, this, string, this.info);
    }

    public Context getContext(Hashtable hashtable) {
        return new WLEventContextImpl(hashtable, this, true);
    }

    protected NamingNode createSubnodeHere(String string, Hashtable hashtable) throws NoPermissionException, NamingException {
        NamingNode namingNode = super.createSubnodeHere(string, hashtable);
        return namingNode;
    }

    protected void destroySubnodeHere(String string, Hashtable hashtable) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        super.destroySubnodeHere(string, hashtable);
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ destroySubContext(" + string2 + ")");
        }
    }

    public Object lookup(String string, Hashtable hashtable) throws NamingException, RemoteException {
        try {
            Object object = super.lookup(string, hashtable);
            object = this.getObjectOrStub(object, string);
            return object;
        }
        catch (NameNotFoundException nameNotFoundException) {
            String string2 = this.getRelativeName();
            if (string2.endsWith("comp/env")) {
                string2 = "java:comp/env";
            }
            throw this.newNameNotFoundException("While trying to look up " + string + " in " + string2 + ".", string, hashtable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object resolveObject(String string, Object object, int n, Hashtable hashtable) throws NamingException {
        Object object2 = object;
        if (object == null) return super.resolveObject(string, object, n, hashtable);
        try {
            if (object instanceof NamingNode) {
                NamingNode namingNode = (NamingNode)object;
                return namingNode.getContext(hashtable);
            }
            if (n < 0) return super.resolveObject(string, object, n, hashtable);
            if (!(object instanceof LinkRef)) return super.resolveObject(string, object, n, hashtable);
            LinkRef linkRef = (LinkRef)object;
            String string2 = linkRef.getLinkName();
            Object var10_12 = null;
            var10_12 = this.cache.get(string);
            if (var10_12 != null) return var10_12;
            if (string2.indexOf("java:") > -1) {
                int n2 = string2.lastIndexOf(DEFAULT_SEPARATORS);
                String string3 = string2.substring(n2 + 1);
                String string4 = string2.substring(0, n2);
                InitialContext initialContext = new InitialContext();
                EventContext eventContext = (EventContext)initialContext.lookup(string4);
                object2 = eventContext.lookup(string3);
                if (this.isOpaqueReference(eventContext, string3)) return object2;
                this.cache.put(string, object2);
                new CacheInvalidationListener(string3, string, eventContext, this.cache);
                return object2;
            } else {
                if (this.linkRefResolvesToRemoteServer(string2)) return super.resolveObject(string, object, n, hashtable);
                object2 = super.resolveObject(string, object, n, hashtable);
                Environment environment = new Environment(hashtable);
                String[] stringArray = this.parseName(string2);
                if (hashtable == null) {
                    hashtable = new Hashtable();
                }
                hashtable.put("weblogic.jndi.events.enable", "true");
                environment = new Environment(hashtable);
                EventContext eventContext = (EventContext)environment.getContext(stringArray[0]);
                if (this.isOpaqueReference(eventContext, stringArray[1])) return object2;
                this.cache.put(string, object2);
                new CacheInvalidationListener(stringArray[1], string, eventContext, this.cache);
            }
            return object2;
        }
        catch (NamingException namingException) {
            this.cache.remove(string);
            throw namingException;
        }
        catch (Exception exception) {
            this.cache.remove(string);
            NamingException namingException = this.fillInException(new ConfigurationException("Call to NamingManager.getObjectInstance() failed: "), string, object2, null);
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private boolean isOpaqueReference(Context context, String string) {
        try {
            return context.lookupLink(string) instanceof OpaqueReference;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    private Object getObjectOrStub(Object object, String string) throws RemoteException {
        if (object instanceof ForceCallByReference || this.info.isForceCallByReferenceEnabled()) {
            if (object instanceof CBVWrapper) {
                CBVWrapper cBVWrapper = (CBVWrapper)object;
                return cBVWrapper.getDelegate();
            }
            return object;
        }
        if (ClassLoaderUtils.visibleToClassLoader((Object)object)) {
            return object;
        }
        Object object2 = object;
        if (object instanceof Remote) {
            if (ServerHelper.isIIOPStub((Remote)((Remote)object))) {
                return object;
            }
            if (ServerHelper.isClusterable((Remote)((Remote)object)) && RemoteHelper.isCollocated((Object)object)) {
                ServerHelper.exportObject((Remote)((Remote)object), (String)string);
            } else {
                ServerHelper.exportObject((Remote)((Remote)object));
            }
            object2 = StubFactory.getStub((Remote)((Remote)object));
        } else if (object instanceof StubReference) {
            object2 = StubFactory.getStub((StubReference)((StubReference)object));
        }
        return object2;
    }

    private String[] parseName(String string) {
        String string2 = "./";
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            char c = string.charAt(i);
            for (int j = 0; j < string2.length(); ++j) {
                if (c != string2.charAt(j)) continue;
                return new String[]{string.substring(0, i), string.substring(i + 1)};
            }
        }
        return new String[]{"", string};
    }

    private boolean linkRefResolvesToRemoteServer(String string) {
        return string.indexOf(58) > -1;
    }

    public String getRelativeName() throws NamingException {
        String string = this.relativeName;
        if (this.parent != null) {
            string = this.parent.getRelativeName() + DEFAULT_SEPARATORS + this.relativeName;
        }
        return string;
    }

    private static final class CacheInvalidationListener
    implements ObjectChangeListener {
        private final String name;
        private final EventContext eventContext;
        private final ConcurrentHashMap cache;
        private final String objectName;
        private final String fullName;

        private CacheInvalidationListener(String string, String string2, EventContext eventContext, ConcurrentHashMap concurrentHashMap) {
            this.name = string2;
            this.eventContext = eventContext;
            this.cache = concurrentHashMap;
            this.objectName = string;
            String string3 = null;
            try {
                this.eventContext.addNamingListener(string, 0, (NamingListener)this);
                string3 = eventContext.getNameInNamespace();
            }
            catch (NamingException namingException) {
                concurrentHashMap.remove(string2);
            }
            this.fullName = string3 + ApplicationNamingNode.DEFAULT_SEPARATORS + string;
        }

        public void objectChanged(NamingEvent namingEvent) {
            try {
                this.cache.remove(this.name);
                this.eventContext.removeNamingListener(this);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }

        public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CacheInvalidationListener) {
                CacheInvalidationListener cacheInvalidationListener = (CacheInvalidationListener)object;
                return this.fullName.equals(cacheInvalidationListener.fullName);
            }
            return false;
        }

        public int hashCode() {
            return this.fullName.hashCode();
        }
    }
}

