/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LinkException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.DirectoryManager;
import javax.naming.spi.NamingManager;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.WLContext;
import weblogic.jndi.internal.BindingEnumeration;
import weblogic.jndi.internal.NameClassPairEnumeration;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.NamingResolutionDebugLogger;
import weblogic.jndi.internal.NamingService;
import weblogic.jndi.internal.NotifyEventListeners;
import weblogic.jndi.internal.WLEventContextImpl;
import weblogic.jndi.internal.WLNameParser;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.work.WorkManagerFactory;

public class BasicNamingNode
implements NamingNode {
    private String separators;
    private String nameInNamespace;
    private BasicNamingNode parent;
    private final ConcurrentHashMap map = new ConcurrentHashMap(3);
    private final ArrayList onelevelNameListenerList = new ArrayList();
    private final ConcurrentHashMap objectListenerMap = new ConcurrentHashMap(5);
    protected final ArrayList subtreeScopeNameListenerList;
    private final Object lock = new Object(){};
    protected NameParser nameParser;
    static final int RESOLVE_TO_LINK = 0;
    private static final int RESOLVE_FULLY = 1;

    public BasicNamingNode() {
        this("/", null, "");
    }

    protected BasicNamingNode(String string) {
        this(string, null, "");
    }

    protected BasicNamingNode(String string, BasicNamingNode basicNamingNode, String string2) {
        this(string, basicNamingNode, string2, new ArrayList());
    }

    protected BasicNamingNode(String string, BasicNamingNode basicNamingNode, String string2, ArrayList arrayList) {
        this.separators = string;
        this.nameParser = basicNamingNode == null ? new WLNameParser(string) : basicNamingNode.nameParser;
        this.setParent(basicNamingNode, string2);
        this.subtreeScopeNameListenerList = arrayList;
    }

    public String getNameInNamespace() {
        return this.nameInNamespace;
    }

    public String getRelativeName() throws NamingException {
        String string = "";
        String string2 = this.getNameInNamespace();
        while (string2.length() > 0) {
            string = this.getPrefix(string2);
            string2 = this.getRest(string2);
        }
        return string;
    }

    public NamingNode getParent() {
        return this.parent;
    }

    public void setParent(BasicNamingNode basicNamingNode, String string) {
        this.parent = basicNamingNode;
        if (basicNamingNode == null) {
            this.nameInNamespace = "";
        } else {
            try {
                this.nameInNamespace = basicNamingNode.getNameInNamespace(string);
            }
            catch (NamingException namingException) {
                throw new AssertionError((Object)namingException);
            }
        }
    }

    public NameParser getNameParser(String string, Hashtable hashtable) throws NameNotFoundException, NamingException, RemoteException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string2.length() == 0) {
            return this.nameParser;
        }
        Object object = this.lookupHere(string2, hashtable, string3);
        try {
            NameParser nameParser = object instanceof NamingNode ? ((NamingNode)object).getNameParser(string3, hashtable) : this.getContinuationCtx(object, string2, string3, hashtable).getNameParser(string3);
            return nameParser;
        }
        catch (NamingException namingException) {
            throw this.prependResolvedNameToException(string2, namingException);
        }
    }

    private String composeName(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        return string2 + this.separators.charAt(0) + string;
    }

    public String getNameInNamespace(String string) throws NamingException {
        if (string.length() == 0) {
            return this.nameInNamespace;
        }
        if (this.nameInNamespace.length() > 0) {
            if (this.nameParser.equals(this.parent.nameParser)) {
                return this.composeName(this.escapeBinding(string), this.nameInNamespace);
            }
            return this.nameInNamespace + "/" + this.escapeBinding(string);
        }
        return string;
    }

    public Object lookup(String string, Hashtable hashtable) throws NamingException, RemoteException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        Object object = this.lookupHere(string2, hashtable, string3);
        if (string3.length() == 0) {
            return this.resolveObject(string2, object, hashtable);
        }
        try {
            object = object instanceof NamingNode ? ((NamingNode)object).lookup(string3, hashtable) : this.getContinuationCtx(object, string2, string3, hashtable).lookup(string3);
        }
        catch (NamingException namingException) {
            throw this.prependResolvedNameToException(string2, namingException);
        }
        return this.makeTransportable(object, string3, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookupHere(String string, Hashtable hashtable, String string2) throws NameNotFoundException, NamingException {
        if (string.length() == 0) {
            return this;
        }
        Object object = null;
        Object object2 = this;
        synchronized (object2) {
            object = this.map.get(string);
        }
        if (object == null) {
            if (NamingResolutionDebugLogger.isDebugEnabled()) {
                NamingResolutionDebugLogger.debug("--- failed to find " + string);
            }
            object2 = this.separators.length() == 0 ? string2 + this.getNameInNamespace(string) : this.composeName(string2, this.getNameInNamespace(string));
            if (string2 != null && string2.length() > 0) {
                throw this.newNameNotFoundException("While trying to lookup '" + (String)object2 + "' didn't find subcontext '" + string + "'. Resolved '" + this.getNameInNamespace() + "'", this.composeName(string2, string), hashtable);
            }
            throw this.newNameNotFoundException("Unable to resolve '" + (String)object2 + "'. Resolved '" + this.getNameInNamespace() + "'", this.composeName(string2, string), hashtable);
        }
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ lookup(" + this.getNameInNamespace(string) + ", " + object.getClass().getName() + ") succeeded");
        }
        return object;
    }

    private Object lookupHereOrCreate(String string, Hashtable hashtable, String string2) throws NamingException {
        try {
            return this.lookupHere(string, hashtable, string2);
        }
        catch (NameNotFoundException nameNotFoundException) {
            if ("true".equals(this.getProperty(hashtable, "weblogic.jndi.createIntermediateContexts"))) {
                return this.createSubnodeHere(string, hashtable);
            }
            throw nameNotFoundException;
        }
    }

    public Object lookupLink(String string, Hashtable hashtable) throws NamingException, RemoteException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        Object object = this.lookupHere(string2, hashtable, string3);
        if (string3.length() == 0) {
            return this.resolveObject(string2, object, 0, hashtable);
        }
        try {
            object = object instanceof NamingNode ? ((NamingNode)object).lookupLink(string3, hashtable) : this.getContinuationCtx(object, string2, string3, hashtable).lookupLink(string3);
        }
        catch (NamingException namingException) {
            throw this.prependResolvedNameToException(string2, namingException);
        }
        return object;
    }

    public void bind(String string, Object object, Hashtable hashtable) throws NamingException, RemoteException {
        if (object == null) {
            throw new NamingException("Cannot bind null object to jndi with name " + string);
        }
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            this.bindHere(string2, object, hashtable, true);
        } else {
            Object object2 = this.lookupHereOrCreate(string2, hashtable, string3);
            try {
                if (object2 instanceof NamingNode) {
                    ((NamingNode)object2).bind(string3, object, hashtable);
                } else {
                    this.getContinuationCtx(object2, string2, string3, hashtable).bind(string3, object);
                }
            }
            catch (NamingException namingException) {
                throw this.prependResolvedNameToException(string2, namingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindHere(String string, Object object, Hashtable hashtable, boolean bl) throws NamingException {
        Object v;
        try {
            if (!(object instanceof Aggregatable)) {
                ConcurrentHashMap concurrentHashMap = this.map;
                synchronized (concurrentHashMap) {
                    v = this.map.get(string);
                    if (v == null) {
                        if (object instanceof BasicNamingNode) {
                            ((BasicNamingNode)object).setParent(this, string);
                        }
                        this.map.put(string, object);
                    } else if (!object.equals(v)) {
                        throw this.fillInException(new NameAlreadyBoundException(string + " is already bound"), string, v, "");
                    }
                }
            }
            ConcurrentHashMap concurrentHashMap = this.map;
            synchronized (concurrentHashMap) {
                v = this.map.get(string);
                if (v == null) {
                    ((Aggregatable)object).onBind(this, string, null);
                    this.map.put(string, object);
                } else if (v instanceof Aggregatable) {
                    ((Aggregatable)v).onBind(this, string, (Aggregatable)object);
                } else {
                    throw this.fillInException(new NameAlreadyBoundException(string + " is already bound"), string, v, "");
                }
            }
            if (NamingDebugLogger.isDebugEnabled()) {
                NamingDebugLogger.debug("+++ bind(" + this.getNameInNamespace(string) + ", " + object.getClass().getName() + ") succeeded");
            }
        }
        catch (NamingException namingException) {
            NamingException namingException2 = this.fillInException(namingException, string, this, this.getNameInNamespace());
            if (NamingDebugLogger.isDebugEnabled()) {
                NamingDebugLogger.debug("+++ bind(" + string + ", " + object.getClass().getName() + ") failed due to: " + namingException2);
            }
            throw namingException2;
        }
        if (this.notifyNameListeners()) {
            this.fireNameListeners(string, this.setUpNotification(string, 0, hashtable, object, v));
        }
    }

    public void rebind(String string, Object object, Hashtable hashtable) throws NamingException, RemoteException {
        if (object == null) {
            throw new NamingException("Cannot rebind null object into jndi tree " + string);
        }
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            this.rebindHere(string2, object, hashtable, true);
        } else {
            Object object2 = this.lookupHereOrCreate(string2, hashtable, string3);
            try {
                if (object2 instanceof NamingNode) {
                    ((NamingNode)object2).rebind(string3, object, hashtable);
                } else {
                    this.getContinuationCtx(object2, string2, string3, hashtable).rebind(string3, object);
                }
            }
            catch (NamingException namingException) {
                throw this.prependResolvedNameToException(string2, namingException);
            }
        }
    }

    public void rebind(Name name, Object object, Hashtable hashtable) throws NamingException, RemoteException {
        int n = name.size();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            String string = name.get(0);
            this.rebindHere(string, object, hashtable, true);
        } else {
            String string = name.get(0);
            name.remove(0);
            Object object2 = this.lookupHereOrCreate(string, hashtable, name.toString());
            try {
                if (object2 instanceof NamingNode) {
                    ((NamingNode)object2).rebind(name, object, hashtable);
                } else {
                    this.getContinuationCtx(object2, string, name.toString(), hashtable).rebind(name, object);
                }
            }
            catch (NamingException namingException) {
                throw this.prependResolvedNameToException(string, namingException);
            }
        }
    }

    public void rebind(String string, Object object, Object object2, Hashtable hashtable) throws NamingException, RemoteException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            this.rebindHere(string2, object, object2, hashtable, true);
        } else {
            Object object3 = this.lookupHereOrCreate(string2, hashtable, string3);
            try {
                if (object3 instanceof NamingNode) {
                    ((NamingNode)object3).rebind(string3, object, object2, hashtable);
                } else {
                    ((WLContext)this.getContinuationCtx(object3, string2, string3, hashtable)).rebind(string3, object, object2);
                }
            }
            catch (NamingException namingException) {
                throw this.prependResolvedNameToException(string2, namingException);
            }
        }
    }

    protected void rebindHere(String string, Object object, Object object2, Hashtable hashtable, boolean bl) throws NamingException {
        this.rebindHere(string, object2, hashtable, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebindHere(String string, Object object, Hashtable hashtable, boolean bl) throws NamingException {
        Object v;
        try {
            if (!(object instanceof Aggregatable)) {
                ConcurrentHashMap concurrentHashMap = this.map;
                synchronized (concurrentHashMap) {
                    v = this.map.get(string);
                    if (v instanceof BasicNamingNode && ((BasicNamingNode)v).isVersioned()) {
                        throw this.fillInException(new NamingException(string + " was bound with version previously" + ".  Cannot rebind without version."), string, v, "");
                    }
                    this.map.put(string, object);
                }
            }
            ConcurrentHashMap concurrentHashMap = this.map;
            synchronized (concurrentHashMap) {
                v = this.map.get(string);
                if (v instanceof BasicNamingNode && ((BasicNamingNode)v).isVersioned()) {
                    throw this.fillInException(new NamingException(string + " was bound with version previously" + ".  Cannot rebind without version."), string, v, "");
                }
                if (v == null) {
                    ((Aggregatable)object).onBind(this, string, null);
                    this.map.put(string, object);
                } else if (v instanceof Aggregatable) {
                    ((Aggregatable)v).onRebind(this, string, (Aggregatable)object);
                }
            }
            if (NamingDebugLogger.isDebugEnabled()) {
                NamingDebugLogger.debug("+++ rebind(" + string + ", " + object.getClass().getName() + ") succeeded");
            }
        }
        catch (NamingException namingException) {
            NamingException namingException2 = this.fillInException(namingException, string, this, "");
            if (NamingDebugLogger.isDebugEnabled()) {
                NamingDebugLogger.debug("+++ rebind(" + string + ", " + object.getClass().getName() + ") failed due to: " + namingException2);
            }
            throw namingException2;
        }
        if (this.notifyNameListeners()) {
            this.fireNameListeners(string, this.setUpNotification(string, 3, hashtable, object, v));
        }
    }

    public void unbind(String string, Hashtable hashtable) throws NamingException, RemoteException {
        this.unbind(string, null, hashtable);
    }

    public void unbind(String string, Object object, Hashtable hashtable) throws NamingException, RemoteException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            this.unbindHere(string2, object, hashtable, true);
        } else {
            Object object2;
            try {
                object2 = this.lookupHere(string2, hashtable, string3);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
            try {
                if (object2 instanceof NamingNode) {
                    ((NamingNode)object2).unbind(string3, object, hashtable);
                } else {
                    this.getContinuationCtx(object2, string2, string3, hashtable).unbind(string3);
                }
            }
            catch (NamingException namingException) {
                throw this.prependResolvedNameToException(string2, namingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindHere(String string, Object object, Hashtable hashtable, boolean bl) throws NamingException {
        ConcurrentHashMap concurrentHashMap = this.map;
        synchronized (concurrentHashMap) {
            Object v = this.map.get(string);
            if (v instanceof Aggregatable) {
                if ((object == null || object instanceof Aggregatable) && ((Aggregatable)v).onUnbind(this, string, (Aggregatable)object)) {
                    this.map.remove(string);
                    if (this.notifyNameListeners()) {
                        this.fireNameListeners(string, this.setUpNotification(string, 1, hashtable, object, v));
                    }
                }
            } else {
                this.map.remove(string);
                if (this.notifyNameListeners()) {
                    this.fireNameListeners(string, this.setUpNotification(string, 1, hashtable, object, v));
                }
            }
        }
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ unbind(" + string + ") succeeded ");
        }
    }

    public void rename(String string, String string2, Hashtable hashtable) throws NamingException, RemoteException {
        Object object = this.lookupLink(string, hashtable);
        this.bind(string2, object, hashtable);
        this.unbind(string, hashtable);
    }

    public NamingEnumeration list(String string, Hashtable hashtable) throws NamingException, RemoteException {
        NamingEnumeration<NameClassPair> namingEnumeration;
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string2.length() == 0) {
            Set set = this.listThis(hashtable);
            Iterator iterator = set.iterator();
            NameClassPair[] nameClassPairArray = new NameClassPair[set.size()];
            for (int i = 0; i < nameClassPairArray.length; ++i) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string4 = (String)entry.getKey();
                String string5 = entry.getValue().getClass().getName();
                nameClassPairArray[i] = new NameClassPair(string4, string5);
            }
            return new NameClassPairEnumeration(nameClassPairArray);
        }
        Object object = this.lookupHere(string2, hashtable, string3);
        try {
            namingEnumeration = object instanceof NamingNode ? ((NamingNode)object).list(string3, hashtable) : this.getContinuationCtx(object, string2, string3, hashtable).list(string3);
        }
        catch (NamingException namingException) {
            throw this.prependResolvedNameToException(string2, namingException);
        }
        return (NamingEnumeration)this.makeTransportable(namingEnumeration, string3, hashtable);
    }

    protected Set listThis(Hashtable hashtable) throws NamingException {
        return this.map.entrySet();
    }

    public NamingEnumeration listBindings(String string, Hashtable hashtable) throws NamingException, RemoteException {
        NamingEnumeration<Binding> namingEnumeration;
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string2.length() == 0) {
            Set set = this.listThis(hashtable);
            Iterator iterator = set.iterator();
            Binding[] bindingArray = new Binding[set.size()];
            for (int i = 0; i < bindingArray.length; ++i) {
                Object object;
                Map.Entry entry = (Map.Entry)iterator.next();
                String string4 = (String)entry.getKey();
                try {
                    object = this.resolveObject(string4, entry.getValue(), hashtable);
                }
                catch (LinkException linkException) {
                    object = entry.getValue();
                }
                catch (NameNotFoundException nameNotFoundException) {
                    object = entry.getValue();
                }
                bindingArray[i] = new Binding(string4, object);
            }
            return new BindingEnumeration(bindingArray);
        }
        Object object = this.lookupHere(string2, hashtable, string3);
        try {
            namingEnumeration = object instanceof NamingNode ? ((NamingNode)object).listBindings(string3, hashtable) : this.getContinuationCtx(object, string2, string3, hashtable).listBindings(string3);
        }
        catch (NamingException namingException) {
            throw this.prependResolvedNameToException(string2, namingException);
        }
        return (NamingEnumeration)this.makeTransportable(namingEnumeration, string3, hashtable);
    }

    public Context createSubcontext(String string, Hashtable hashtable) throws NamingException, RemoteException {
        if (this.separators.length() == 0) {
            OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException("Cannot call createSubcontext is a flat namespace");
            throw this.fillInException(operationNotSupportedException, string, null, null);
        }
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            return this.createSubnodeHere(string2, hashtable).getContext(hashtable);
        }
        Object object = this.lookupHereOrCreate(string2, hashtable, string3);
        try {
            if (object instanceof NamingNode) {
                return ((NamingNode)object).createSubcontext(string3, hashtable);
            }
            return this.getContinuationCtx(object, string2, string3, hashtable).createSubcontext(string3);
        }
        catch (NamingException namingException) {
            throw this.prependResolvedNameToException(string2, namingException);
        }
    }

    protected NamingNode createSubnodeHere(String string, Hashtable hashtable) throws NamingException {
        ConcurrentHashMap concurrentHashMap = this.map;
        synchronized (concurrentHashMap) {
            Object v = this.map.get(string);
            if (v == null) {
                if (string.length() == 0) {
                    return this;
                }
                BasicNamingNode basicNamingNode = this.newSubnode(string);
                if (NamingResolutionDebugLogger.isDebugEnabled()) {
                    NamingResolutionDebugLogger.debug("--- created sub node " + string + " " + basicNamingNode);
                }
                this.map.put(string, basicNamingNode);
                if (this.notifyNameListeners()) {
                    this.fireNameListeners(string, this.setUpNotification(string, 0, hashtable, basicNamingNode.getContext(hashtable), null));
                }
                return basicNamingNode;
            }
            if (v instanceof NamingNode) {
                return (NamingNode)v;
            }
            throw this.fillInException(new NameAlreadyBoundException(string), string, null, "");
        }
    }

    protected BasicNamingNode newSubnode(String string) {
        return new BasicNamingNode(this.separators, this, string);
    }

    public void destroySubcontext(String string, Hashtable hashtable) throws NamingException, RemoteException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            this.destroySubnodeHere(string, hashtable);
        } else {
            Object v = this.map.get(string2);
            if (v == null) {
                throw this.newNameNotFoundException("Cannot destroy non exisiting context " + string2 + " in " + this.getNameInNamespace(string2), string3, hashtable);
            }
            try {
                if (v instanceof NamingNode) {
                    ((NamingNode)v).destroySubcontext(string3, hashtable);
                } else {
                    this.getContinuationCtx(v, string2, string3, hashtable).destroySubcontext(string3);
                }
            }
            catch (NamingException namingException) {
                throw this.prependResolvedNameToException(string2, namingException);
            }
        }
    }

    protected void destroySubnodeHere(String string, Hashtable hashtable) throws NameNotFoundException, ContextNotEmptyException, NamingException {
        block6: {
            Object v = this.map.get(string);
            if (v == null) {
                return;
            }
            if (!(v instanceof BasicNamingNode)) {
                throw this.newNameNotFoundException("Cannot destroy non existing subcontext " + string + " in " + this.getNameInNamespace(string), "", hashtable);
            }
            BasicNamingNode basicNamingNode = (BasicNamingNode)v;
            if (basicNamingNode.map.size() > 0) {
                throw this.fillInException(new ContextNotEmptyException(), string, v, "");
            }
            try {
                if (v instanceof Remote) {
                    ServerHelper.unexportObject((Remote)((Remote)v), (boolean)true);
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                if (!NamingDebugLogger.isDebugEnabled()) break block6;
                NamingDebugLogger.debug("No such object exception when trying to destroy the subcontext. Possibly a race condition between two threads both unexporting the object. This should not cause any errors in and of itself, however. Both threads have achieved  their goal. Exception: " + noSuchObjectException);
            }
        }
        this.map.remove(string);
    }

    public Context getContext(Hashtable hashtable) {
        return new WLEventContextImpl(hashtable, this);
    }

    private EventContext getEventContext(Hashtable hashtable) {
        return new WLEventContextImpl(hashtable, this);
    }

    private Object resolveObject(String string, Object object, Hashtable hashtable) throws NamingException {
        return this.resolveObject(string, object, 1, hashtable);
    }

    protected Object resolveObject(String string, Object object, int n, Hashtable hashtable) throws NamingException {
        Object object2 = object;
        if (object != null) {
            try {
                if (object instanceof NamingNode) {
                    object2 = ((NamingNode)object).getContext(hashtable);
                } else if (n != 0 && n >= 0) {
                    object2 = WLNamingManager.getObjectInstance(object, new CompositeName(string), null, hashtable);
                    object2 = this.makeTransportable(object2, string, hashtable);
                }
            }
            catch (NamingException namingException) {
                if (!NamingService.getNamingService().isRunning()) {
                    namingException.setRootCause(new ConnectIOException("Server is being shut down"));
                }
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = this.fillInException(new ConfigurationException("Call to NamingManager.getObjectInstance() failed: "), string, object2, null);
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return object2;
    }

    private String getPrefix(String string) throws NamingException {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"') {
            int n = string.indexOf(34, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !this.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            return string.substring(1, n);
        }
        if (string.charAt(0) == '\'') {
            int n = string.indexOf(39, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !this.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            return string.substring(1, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\\': {
                    if (++i == string.length()) {
                        throw new InvalidNameException("An escape at the end of a name must be escaped");
                    }
                    stringBuffer.append(string.charAt(i));
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    throw new InvalidNameException("Unescaped quote in a component");
                }
                default: {
                    if (this.isSeparator(string.charAt(i))) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private boolean isSeparator(char c) {
        for (int i = 0; i < this.separators.length(); ++i) {
            if (c != this.separators.charAt(i)) continue;
            return true;
        }
        return false;
    }

    private String getRest(String string) throws NamingException {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"') {
            int n = string.indexOf(34, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !this.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            if (++n < string.length() && this.isSeparator(string.charAt(n))) {
                ++n;
            }
            return string.substring(n);
        }
        if (string.charAt(0) == '\'') {
            int n = string.indexOf(39, 1);
            if (n < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (n < string.length() - 1 && !this.isSeparator(string.charAt(n + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            if (++n < string.length() && this.isSeparator(string.charAt(n))) {
                ++n;
            }
            return string.substring(n);
        }
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\\': {
                    if (++i != string.length()) continue block4;
                    throw new InvalidNameException("An escape at the end of a name must be escaped");
                }
                case '\"': 
                case '\'': {
                    throw new InvalidNameException("Unescaped quote in a component");
                }
                default: {
                    if (!this.isSeparator(string.charAt(i))) continue block4;
                    return string.substring(i + 1);
                }
            }
        }
        return "";
    }

    protected String escapeBinding(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && i != string.length() - 1 && BasicNamingNode.isQuote(string.charAt(i)) || this.isSeparator(string.charAt(i))) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    protected final Object makeTransportable(Object object, String string, Hashtable hashtable) throws NamingException {
        return this.makeTransportable(object, new CompositeName(string), hashtable);
    }

    protected final Object makeTransportable(Object object, Name name, Hashtable hashtable) throws NamingException {
        return WLNamingManager.getTransportableInstance(object, name, null, hashtable);
    }

    protected final NamingException fillInException(NamingException namingException, String string, Object object, String string2) {
        try {
            string2 = string2 == null ? "" : string2.replace('.', '/');
            namingException.setResolvedName(WLNameParser.defaultParse(string));
            namingException.setResolvedObj(object);
            namingException.setRemainingName(new CompositeName(string2));
            if (!NamingService.getNamingService().isRunning()) {
                namingException.setRootCause(new ConnectIOException("Server is being shut down"));
            }
            return namingException;
        }
        catch (NamingException namingException2) {
            throw new AssertionError((Object)namingException2);
        }
    }

    protected final NameNotFoundException newNameNotFoundException(String string, String string2, Hashtable hashtable) {
        return this.newNameNotFoundException(new NameNotFoundException(string), string2, hashtable);
    }

    public NameNotFoundException newNameNotFoundException(NamingException namingException, String string, Hashtable hashtable) {
        if (NamingService.getNamingService().isRunning()) {
            return (NameNotFoundException)this.fillInException(namingException, "", this.getContext(hashtable), string);
        }
        return (NameNotFoundException)this.fillInException(namingException, "", this, string);
    }

    private Context getContinuationCtx(Object object, String string, String string2, Hashtable hashtable) throws NamingException {
        CannotProceedException cannotProceedException = new CannotProceedException();
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        if (hashtable2.get("java.naming.factory.url.pkgs") == null) {
            hashtable2.put("java.naming.factory.url.pkgs", NamingService.getNamingService().getUrlPkgPrefixes());
        }
        cannotProceedException.setEnvironment(hashtable2);
        this.fillInException(cannotProceedException, string, object, string2);
        if (this instanceof DirContext) {
            return DirectoryManager.getContinuationDirContext(cannotProceedException);
        }
        return NamingManager.getContinuationContext(cannotProceedException);
    }

    private NamingException prependResolvedNameToException(String string, NamingException namingException) {
        try {
            Name name = namingException.getResolvedName();
            if (name == null) {
                try {
                    name = WLNameParser.defaultParse("");
                }
                catch (NamingException namingException2) {
                    throw new AssertionError((Object)namingException2);
                }
            } else {
                name.add(0, string);
            }
            namingException.setResolvedName(name);
        }
        catch (InvalidNameException invalidNameException) {
            throw new AssertionError((Object)invalidNameException);
        }
        return namingException;
    }

    protected final String getProperty(Hashtable hashtable, String string) {
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get(string);
        }
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        return string2 == null ? "" : string2;
    }

    protected int getNumOfBindings() {
        return this.map.size();
    }

    protected boolean isVersioned() {
        return false;
    }

    public void addNamingListener(String string, int n, NamingListener namingListener, Hashtable hashtable) throws NamingException {
        String string2 = this.getPrefix(string);
        String string3 = this.getRest(string);
        if (string3.length() == 0) {
            Object object;
            if (n == 1) {
                object = (NamingNode)this.lookupHereOrCreate(string2, hashtable, string3);
                object.addOneLevelScopeNamingListener(namingListener);
            } else {
                this.addListener(string2, n, namingListener);
            }
            if (NamingResolutionDebugLogger.isDebugEnabled()) {
                object = this.nameParser.parse(this.getNameInNamespace(string));
                NamingResolutionDebugLogger.debug("+++ Added listener of scope " + n + " at " + object);
            }
        } else {
            Object object = this.lookupHereOrCreate(string2, hashtable, string3);
            if (object instanceof NamingNode) {
                ((NamingNode)object).addNamingListener(string3, n, namingListener, hashtable);
            } else {
                throw new AssertionError((Object)("Tried to create context but failed" + object.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addListener(String string, int n, NamingListener namingListener) {
        if (n == 0) {
            ConcurrentHashMap concurrentHashMap = this.objectListenerMap;
            synchronized (concurrentHashMap) {
                ArrayList<NamingListener> arrayList = (ArrayList<NamingListener>)this.objectListenerMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<NamingListener>();
                    this.objectListenerMap.put(string, arrayList);
                }
                arrayList.add(namingListener);
            }
        } else if (n == 2) {
            this.subtreeScopeNameListenerList.add(namingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOneLevelScopeNamingListener(NamingListener namingListener) {
        Object object = this.lock;
        synchronized (object) {
            this.onelevelNameListenerList.add(namingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamingListener(NamingListener namingListener, Hashtable hashtable) {
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.onelevelNameListenerList.remove(namingListener);
        }
        for (String string : this.objectListenerMap.keySet()) {
            ArrayList arrayList = (ArrayList)this.objectListenerMap.get(string);
            int n = arrayList.indexOf(namingListener);
            if (n <= -1) continue;
            arrayList.remove(n);
            break;
        }
        if (NamingResolutionDebugLogger.isDebugEnabled()) {
            NamingResolutionDebugLogger.debug("--- Removed listener " + namingListener + " from current context ");
        }
    }

    public List getOneLevelScopeNamingListeners() {
        return this.onelevelNameListenerList;
    }

    protected boolean notifyNameListeners() {
        return this.getOneLevelScopeNamingListeners().size() > 0 || this.objectListenerMap.size() > 0 || this.subtreeScopeNameListenerList.size() > 0;
    }

    protected void fireNameListeners(String string, NamingEvent namingEvent) {
        Object object;
        ArrayList arrayList = new ArrayList();
        if (this.objectListenerMap.get(string) != null) {
            object = (ArrayList)this.objectListenerMap.get(string);
            arrayList.addAll(object);
        }
        if (this.getOneLevelScopeNamingListeners().size() > 0) {
            arrayList.addAll(0, this.getOneLevelScopeNamingListeners());
        }
        if (this.subtreeScopeNameListenerList.size() > 0) {
            arrayList.addAll(0, this.subtreeScopeNameListenerList);
        }
        object = new NotifyEventListeners(arrayList, namingEvent, namingEvent.getType());
        Runnable runnable = new Runnable((NotifyEventListeners)object){
            final /* synthetic */ NotifyEventListeners val$listeners;
            {
                this.val$listeners = notifyEventListeners;
            }

            public void run() {
                this.val$listeners.notifyListeners();
            }
        };
        WorkManagerFactory.getInstance().getSystem().schedule(runnable);
    }

    private NamingEvent setUpNotification(String string, int n, Hashtable hashtable, Object object, Object object2) throws NamingException {
        String string2 = this.nameParser.parse(this.getNameInNamespace(string)).toString();
        return new NamingEvent(this.getEventContext(hashtable), n, new Binding(string2, object), new Binding(string2, object2), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUnbound(String string) {
        ConcurrentHashMap concurrentHashMap = this.map;
        synchronized (concurrentHashMap) {
            return this.map.get(string) == null;
        }
    }
}

