/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import weblogic.jndi.internal.NameClassPairEnumeration;

public final class BindingEnumeration
extends NameClassPairEnumeration
implements Externalizable {
    static final long serialVersionUID = -1874230391047383407L;

    public BindingEnumeration(Binding[] bindingArray) {
        super(bindingArray);
    }

    public BindingEnumeration() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.list.length);
        for (int i = 0; i < this.list.length; ++i) {
            Binding binding = (Binding)this.list[i];
            objectOutput.writeObject(binding.getName());
            objectOutput.writeObject(binding.getClassName());
            try {
                objectOutput.writeObject(binding.getObject());
                continue;
            }
            catch (IOException iOException) {
                objectOutput.writeObject("non-serializable");
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.list = new Binding[objectInput.readInt()];
        int n = 0;
        for (int i = 0; i < this.list.length; ++i) {
            String string = (String)objectInput.readObject();
            String string2 = (String)objectInput.readObject();
            try {
                Object object = objectInput.readObject();
                this.list[n++] = new Binding(string, string2, object);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Skipping over incompatible object at name=" + string + ", className=" + string2);
            }
        }
        if (n < this.list.length) {
            NameClassPair[] nameClassPairArray = this.list;
            this.list = new Binding[n];
            System.arraycopy(nameClassPairArray, 0, this.list, 0, n);
        }
    }
}

