/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import weblogic.common.internal.PassivationUtils;
import weblogic.jndi.TransportableObjectFactory;
import weblogic.jndi.WLContext;
import weblogic.jndi.internal.NameClassPairEnumeration;
import weblogic.jndi.internal.NamingFactoriesDebugLogger;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.jndi.remote.AttributeWrapper;
import weblogic.jndi.remote.AttributesWrapper;
import weblogic.jndi.remote.ContextWrapper;
import weblogic.jndi.remote.DirContextWrapper;
import weblogic.jndi.remote.NamingEnumerationWrapper;

public final class BuiltinTransportableObjectFactory
implements TransportableObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Object object2 = object;
        if (!this.isAlreadyTransportable(object)) {
            object2 = object instanceof Context ? this.makeTransportable((Context)object, hashtable) : (object instanceof Binding ? this.makeTransportable((Binding)object, hashtable) : (object instanceof NamingEnumeration ? this.makeTransportable((NamingEnumeration)object, hashtable) : (object instanceof Attributes ? this.makeTransportable((Attributes)object, hashtable) : (object instanceof Attribute ? this.makeTransportable((Attribute)object, hashtable) : null))));
        }
        if (NamingFactoriesDebugLogger.isDebugEnabled() && object2 != null && object2 != object) {
            NamingFactoriesDebugLogger.debug("Wrapping " + object.getClass().getName() + " with " + object2.getClass().getName() + " to make transportable");
        }
        return object2;
    }

    private final Object makeTransportable(Context context, Hashtable hashtable) {
        if (context instanceof DirContext) {
            return new DirContextWrapper((DirContext)context, hashtable);
        }
        return new ContextWrapper(context, hashtable);
    }

    private final Object makeTransportable(NamingEnumeration namingEnumeration, Hashtable hashtable) {
        return new NamingEnumerationWrapper(namingEnumeration, hashtable);
    }

    private final Object makeTransportable(Binding binding, Hashtable hashtable) throws NamingException {
        Object object;
        if (binding instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)binding;
            Object object2 = searchResult.getObject();
            Object object3 = WLNamingManager.getTransportableInstance(object2, null, null, hashtable);
            Attributes attributes = searchResult.getAttributes();
            Attributes attributes2 = (Attributes)WLNamingManager.getTransportableInstance(attributes, null, null, hashtable);
            if (object2 != object3 || attributes != attributes2) {
                return new SearchResult(searchResult.getName(), object3, attributes2);
            }
            return binding;
        }
        Object object4 = binding.getObject();
        if (object4 != (object = WLNamingManager.getTransportableInstance(object4, null, null, hashtable))) {
            return new Binding(binding.getName(), object);
        }
        return binding;
    }

    private final Object makeTransportable(Attributes attributes, Hashtable hashtable) {
        if (this.isSerializable(attributes)) {
            return attributes;
        }
        return new AttributesWrapper(attributes, hashtable);
    }

    private final Object makeTransportable(Attribute attribute, Hashtable hashtable) {
        if (this.isSerializable(attribute)) {
            return attribute;
        }
        return new AttributeWrapper(attribute, hashtable);
    }

    public boolean isAlreadyTransportable(Object object) {
        return object instanceof WLContext || object instanceof Remote || object instanceof NameClassPairEnumeration;
    }

    public boolean isSerializable(Object object) {
        return PassivationUtils.isSerializable(object);
    }
}

