/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.IOException;
import java.io.NotSerializableException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnmarshalException;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.security.auth.login.LoginException;
import weblogic.jndi.internal.NameAlreadyUnboundException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public final class ExceptionTranslator {
    public static NamingException toNamingException(Throwable throwable) {
        NamingException namingException;
        if (throwable instanceof RemoteRuntimeException) {
            throwable = ((RemoteRuntimeException)throwable).getNested();
            Debug.assertion((boolean)(throwable instanceof RemoteException), (String)"RemoteRuntimeException must nest a RemoteException");
        }
        if (throwable instanceof NamingException) {
            namingException = (NamingException)throwable;
        } else {
            if (throwable instanceof RemoteException) {
                return ExceptionTranslator.toNamingException((RemoteException)throwable);
            }
            if (throwable instanceof UnknownHostException) {
                namingException = new ServiceUnavailableException();
            } else if (throwable instanceof MalformedURLException) {
                namingException = new ConfigurationException();
            } else if (throwable instanceof NotSerializableException) {
                namingException = new ConfigurationException();
            } else if (throwable instanceof IOException) {
                namingException = new CommunicationException();
            } else if (throwable instanceof SecurityException) {
                namingException = new AuthenticationException();
            } else if (throwable instanceof LoginException) {
                namingException = new AuthenticationException();
            } else {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                namingException = new NamingException("Unexpected exception: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
        namingException.setRootCause(throwable);
        return namingException;
    }

    public static NamingException toNamingException(RemoteException remoteException) {
        NamingException namingException;
        if (remoteException instanceof java.rmi.UnknownHostException) {
            namingException = new ServiceUnavailableException();
        } else if (remoteException instanceof ConnectException) {
            namingException = new CommunicationException();
        } else if (remoteException instanceof ConnectIOException) {
            namingException = new CommunicationException();
        } else if (remoteException instanceof MarshalException) {
            namingException = ExceptionTranslator.toNamingException(remoteException.detail);
        } else if (remoteException instanceof NoSuchObjectException) {
            namingException = new ServiceUnavailableException();
        } else if (remoteException instanceof StubNotFoundException) {
            namingException = new ConfigurationException();
        } else if (remoteException instanceof UnmarshalException) {
            namingException = new CommunicationException();
        } else if (remoteException instanceof ServerError) {
            namingException = new CommunicationException();
        } else {
            if (remoteException instanceof ServerException) {
                return ExceptionTranslator.toNamingException((ServerException)remoteException);
            }
            namingException = remoteException instanceof RequestTimeoutException ? new ServiceUnavailableException() : (remoteException instanceof NameAlreadyUnboundException ? new NameNotFoundException() : new NamingException());
        }
        namingException.setRootCause(remoteException);
        return namingException;
    }

    public static NamingException toNamingException(ServerException serverException) {
        NamingException namingException;
        Throwable throwable = serverException;
        Throwable throwable2 = serverException.detail;
        Debug.assertion((boolean)(throwable2 instanceof RemoteException), (String)"ServerException must nest a RemoteException");
        if (throwable2 instanceof UnmarshalException) {
            namingException = new CommunicationException();
        } else if (throwable2 instanceof MarshalException) {
            namingException = new ConfigurationException();
        } else if (throwable2 instanceof StubNotFoundException) {
            namingException = new ConfigurationException();
            throwable = throwable2;
        } else {
            namingException = new NamingException();
        }
        namingException.setRootCause(throwable);
        return namingException;
    }
}

