/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.internal.ForeignOpaqueReference;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ForeignJNDILinkMBean;
import weblogic.management.configuration.ForeignJNDIProviderMBean;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.utils.StackTraceUtils;

public class ForeignJNDILinkManager
implements BeanUpdateListener {
    private Hashtable jndiEnvironment;
    private Map local2remote = new HashMap();
    private Hashtable pendingChanges = new Hashtable();
    private InitialContext ic;
    private static ClearOrEncryptedService ces = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());

    public ForeignJNDILinkManager(ForeignJNDIProviderMBean foreignJNDIProviderMBean, ForeignJNDILinkMBean[] foreignJNDILinkMBeanArray, InitialContext initialContext) {
        String string;
        String string2;
        String string3;
        String string4;
        this.ic = initialContext;
        Properties properties = foreignJNDIProviderMBean.getProperties();
        if (properties != null && properties.size() != 0) {
            this.jndiEnvironment = new Hashtable<Object, Object>(properties);
        }
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Hashtable(4);
        }
        if ((string4 = foreignJNDIProviderMBean.getInitialContextFactory()) != null && string4.trim().length() != 0 && !string4.equals("weblogic.jndi.WLInitialContextFactory")) {
            this.jndiEnvironment.put("java.naming.factory.initial", string4);
        }
        if ((string3 = foreignJNDIProviderMBean.getProviderURL()) != null && string3.trim().length() != 0) {
            this.jndiEnvironment.put("java.naming.provider.url", string3);
        }
        if ((string2 = foreignJNDIProviderMBean.getUser()) != null && string2.trim().length() != 0) {
            this.jndiEnvironment.put("java.naming.security.principal", ces.encrypt(string2));
        }
        if ((string = foreignJNDIProviderMBean.getPassword()) != null && string.trim().length() != 0) {
            this.jndiEnvironment.put("java.naming.security.credentials", ces.encrypt(string));
        }
        if (this.jndiEnvironment.size() == 0) {
            this.jndiEnvironment = null;
        }
        foreignJNDIProviderMBean.addBeanUpdateListener(this);
        if (foreignJNDILinkMBeanArray != null) {
            for (int i = 0; i < foreignJNDILinkMBeanArray.length; ++i) {
                this.local2remote.put(foreignJNDILinkMBeanArray[i].getLocalJNDIName(), foreignJNDILinkMBeanArray[i].getRemoteJNDIName());
                foreignJNDILinkMBeanArray[i].addBeanUpdateListener(this);
            }
            this.bindAll(false);
        }
    }

    public void bindAll(boolean bl) {
        for (Map.Entry entry : this.local2remote.entrySet()) {
            this.bind(bl, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void unbindAll() {
        Iterator iterator = this.local2remote.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.unbind(string);
            iterator.remove();
        }
    }

    private void bind(boolean bl, String string, String string2) {
        ForeignOpaqueReference foreignOpaqueReference = new ForeignOpaqueReference(string2, this.jndiEnvironment);
        try {
            if (!bl) {
                this.ic.bind(string, (Object)foreignOpaqueReference);
            } else {
                this.ic.rebind(string, (Object)foreignOpaqueReference);
            }
        }
        catch (NamingException namingException) {
            JNDILogger.logUnableToBind((String)StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
    }

    private void unbind(String string) {
        try {
            this.ic.unbind(string);
        }
        catch (NamingException namingException) {
            JNDILogger.logUnableToUnBind((String)StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
    }

    private void checkDuplicate(String string) throws BeanUpdateRejectedException {
        if (this.local2remote.get(string) != null) {
            throw new BeanUpdateRejectedException("A JNDI name already Exists");
        }
        try {
            if (this.ic.lookup(string) != null) {
                throw new BeanUpdateRejectedException("A JNDI name already exists");
            }
        }
        catch (NamingException namingException) {
            if (namingException instanceof NameNotFoundException) {
                return;
            }
            throw new BeanUpdateRejectedException("A JNDI name already exists");
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        Object object;
        ConfigurationMBean configurationMBean;
        if (beanUpdateEvent.getSourceBean() instanceof ForeignJNDIProviderMBean) {
            configurationMBean = (ForeignJNDIProviderMBean)beanUpdateEvent.getSourceBean();
            object = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < ((BeanUpdateEvent.PropertyUpdate[])object).length; ++i) {
                if (!(object[i].getAddedObject() instanceof ForeignJNDILinkMBean)) continue;
                ForeignJNDILinkMBean foreignJNDILinkMBean = (ForeignJNDILinkMBean)object[i].getAddedObject();
                this.checkDuplicate(foreignJNDILinkMBean.getLocalJNDIName());
            }
        }
        if (beanUpdateEvent.getSourceBean() instanceof ForeignJNDILinkMBean) {
            configurationMBean = (ForeignJNDILinkMBean)beanUpdateEvent.getSourceBean();
            object = (ForeignJNDILinkMBean)beanUpdateEvent.getProposedBean();
            String string = object.getLocalJNDIName();
            if (!configurationMBean.getLocalJNDIName().equals(string)) {
                this.checkDuplicate(string);
                this.pendingChanges.put(string, configurationMBean.getLocalJNDIName());
            }
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        block6: {
            block5: {
                if (!(beanUpdateEvent.getSourceBean() instanceof ForeignJNDIProviderMBean)) break block5;
                ForeignJNDIProviderMBean foreignJNDIProviderMBean = (ForeignJNDIProviderMBean)beanUpdateEvent.getSourceBean();
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    if (propertyUpdateArray[i].getAddedObject() instanceof ForeignJNDILinkMBean) {
                        this.addLink(propertyUpdateArray[i]);
                        continue;
                    }
                    if (propertyUpdateArray[i].getRemovedObject() instanceof ForeignJNDILinkMBean) {
                        this.removeLink(propertyUpdateArray[i]);
                        continue;
                    }
                    this.updateJndiProvider(foreignJNDIProviderMBean, propertyUpdateArray[i]);
                }
                break block6;
            }
            if (!(beanUpdateEvent.getSourceBean() instanceof ForeignJNDILinkMBean)) break block6;
            ForeignJNDILinkMBean foreignJNDILinkMBean = (ForeignJNDILinkMBean)beanUpdateEvent.getSourceBean();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                String string = propertyUpdateArray[i].getPropertyName();
                if (string.equals("LocalJNDIName")) {
                    String string2 = foreignJNDILinkMBean.getLocalJNDIName();
                    String string3 = (String)this.pendingChanges.get(string2);
                    this.unbindOldJndi(string3);
                    this.bind(false, string2, foreignJNDILinkMBean.getRemoteJNDIName());
                    continue;
                }
                if (!string.equals("RemoteJNDIName")) continue;
                this.bind(true, foreignJNDILinkMBean.getLocalJNDIName(), foreignJNDILinkMBean.getRemoteJNDIName());
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    private void updateJndiProvider(ForeignJNDIProviderMBean foreignJNDIProviderMBean, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        Properties properties;
        String string;
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Hashtable(5);
        }
        if ((string = propertyUpdate.getPropertyName()).equals("InitialContextFactory")) {
            String string2 = foreignJNDIProviderMBean.getInitialContextFactory();
            if (string2 != null && string2.trim().length() != 0 && !string2.equals("weblogic.jndi.WLInitialContextFactory")) {
                this.jndiEnvironment.put("java.naming.factory.initial", string2);
                this.bindAll(true);
            } else if (string.equals("ProviderURL")) {
                String string3 = foreignJNDIProviderMBean.getProviderURL();
                if (string3 != null && string3.trim().length() != 0) {
                    this.jndiEnvironment.put("java.naming.provider.url", string3);
                    this.bindAll(true);
                }
            } else if (string.equals("Password")) {
                String string4 = foreignJNDIProviderMBean.getPassword();
                if (string4 != null && string4.trim().length() != 0) {
                    this.jndiEnvironment.put("java.naming.security.principal", ces.encrypt(string4));
                    this.bindAll(true);
                }
            } else if (string.equals("User")) {
                String string5 = foreignJNDIProviderMBean.getUser();
                if (string5 != null && string5.trim().length() != 0) {
                    this.jndiEnvironment.put("java.naming.security.credentials", ces.encrypt(string5));
                }
                this.bindAll(true);
            }
        } else if (string.equals("Properties") && (properties = foreignJNDIProviderMBean.getProperties()) != null && properties.size() != 0) {
            this.jndiEnvironment.putAll(properties);
            this.bindAll(true);
        }
    }

    private void unbindOldJndi(String string) {
        this.unbind(string);
        this.local2remote.remove(string);
    }

    private void addLink(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        ForeignJNDILinkMBean foreignJNDILinkMBean = (ForeignJNDILinkMBean)propertyUpdate.getAddedObject();
        String string = foreignJNDILinkMBean.getRemoteJNDIName();
        String string2 = foreignJNDILinkMBean.getLocalJNDIName();
        this.local2remote.put(string2, string);
        this.bind(false, string2, string);
        foreignJNDILinkMBean.addBeanUpdateListener(this);
    }

    private void removeLink(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        ForeignJNDILinkMBean foreignJNDILinkMBean = (ForeignJNDILinkMBean)propertyUpdate.getRemovedObject();
        String string = foreignJNDILinkMBean.getLocalJNDIName();
        this.unbind(string);
        this.local2remote.remove(string);
    }
}

