/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.internal.ForeignJNDILinkManager;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJNDIProviderMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;

public class ForeignJNDIManager
implements BeanUpdateListener {
    private static ForeignJNDIManager singleton = null;
    private Map<ForeignJNDIProviderMBean, ForeignJNDILinkManager> jndiLinkMngrs = new HashMap<ForeignJNDIProviderMBean, ForeignJNDILinkManager>();
    private InitialContext ic = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private ForeignJNDIManager() {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
            hashtable.put("weblogic.jndi.replicateBindings", "false");
            this.ic = new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            JNDILogger.logCannotCreateInitialContext((String)StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
    }

    static void initialize() {
        singleton = new ForeignJNDIManager();
        singleton.processForeignJNDIProviderLinks();
        ManagementService.getRuntimeAccess(kernelId).getDomain().addBeanUpdateListener(singleton);
    }

    private void processForeignJNDIProviderLinks() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string = runtimeAccess.getServer().getName();
        ForeignJNDIProviderMBean[] foreignJNDIProviderMBeanArray = runtimeAccess.getDomain().getForeignJNDIProviders();
        if (foreignJNDIProviderMBeanArray != null) {
            for (ForeignJNDIProviderMBean foreignJNDIProviderMBean : foreignJNDIProviderMBeanArray) {
                if (!this.isForeignJNDILinkTargettedTo(string, foreignJNDIProviderMBean)) continue;
                this.jndiLinkMngrs.put(foreignJNDIProviderMBean, new ForeignJNDILinkManager(foreignJNDIProviderMBean, foreignJNDIProviderMBean.getForeignJNDILinks(), this.ic));
            }
        }
    }

    private boolean isForeignJNDILinkTargettedTo(String string, ForeignJNDIProviderMBean foreignJNDIProviderMBean) {
        TargetMBean[] targetMBeanArray = foreignJNDIProviderMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return true;
        }
        for (TargetMBean targetMBean : targetMBeanArray) {
            if (!targetMBean.getServerNames().contains(string)) continue;
            return true;
        }
        return false;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (beanUpdateEvent.getSourceBean() instanceof DomainMBean) {
            String string = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
            block4: for (BeanUpdateEvent.PropertyUpdate propertyUpdate : beanUpdateEvent.getUpdateList()) {
                switch (propertyUpdate.getUpdateType()) {
                    case 2: {
                        ForeignJNDIProviderMBean foreignJNDIProviderMBean;
                        Object object = propertyUpdate.getAddedObject();
                        if (!(object instanceof ForeignJNDIProviderMBean) || !this.isForeignJNDILinkTargettedTo(string, foreignJNDIProviderMBean = (ForeignJNDIProviderMBean)object)) continue block4;
                        this.jndiLinkMngrs.put(foreignJNDIProviderMBean, new ForeignJNDILinkManager(foreignJNDIProviderMBean, foreignJNDIProviderMBean.getForeignJNDILinks(), this.ic));
                        continue block4;
                    }
                    case 3: {
                        ForeignJNDIProviderMBean foreignJNDIProviderMBean;
                        Object object = propertyUpdate.getRemovedObject();
                        if (!(object instanceof ForeignJNDIProviderMBean) || !this.isForeignJNDILinkTargettedTo(string, foreignJNDIProviderMBean = (ForeignJNDIProviderMBean)object)) continue block4;
                        this.jndiLinkMngrs.remove(foreignJNDIProviderMBean).unbindAll();
                        continue block4;
                    }
                }
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }
}

