/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.jndi.OpaqueReference;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;

public class ForeignOpaqueReference
implements OpaqueReference,
Serializable {
    static final long serialVersionUID = 4404892619941441265L;
    private Hashtable jndiEnvironment;
    private String remoteJNDIName;
    private static ClearOrEncryptedService ces = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());

    public ForeignOpaqueReference() {
    }

    public ForeignOpaqueReference(String string, Hashtable hashtable) {
        this.remoteJNDIName = string;
        this.jndiEnvironment = hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReferent(Name name, Context context) throws NamingException {
        Object object;
        InitialContext initialContext;
        if (this.jndiEnvironment == null) {
            initialContext = new InitialContext();
        } else {
            object = this.decrypt();
            initialContext = new InitialContext((Hashtable<?, ?>)object);
        }
        try {
            object = initialContext.lookup(this.remoteJNDIName);
        }
        finally {
            initialContext.close();
        }
        return object;
    }

    private Hashtable decrypt() {
        String string;
        Hashtable hashtable = (Hashtable)this.jndiEnvironment.clone();
        String string2 = (String)hashtable.get("java.naming.security.principal");
        if (string2 != null && string2.trim().length() != 0) {
            hashtable.put("java.naming.security.principal", ces.decrypt(string2));
        }
        if ((string = (String)hashtable.get("java.naming.security.credentials")) != null && string.trim().length() != 0) {
            hashtable.put("java.naming.security.credentials", ces.decrypt(string));
        }
        return hashtable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ForeignOpaqueReference: target=\"");
        stringBuffer.append(this.remoteJNDIName);
        stringBuffer.append('\"');
        if (this.jndiEnvironment != null) {
            Enumeration enumeration = this.jndiEnvironment.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.jndiEnvironment.get(string);
                stringBuffer.append(' ');
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }
}

