/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.common.internal.PassivationUtils;
import weblogic.diagnostics.image.ImageSource;
import weblogic.jndi.internal.JNDIHelper;
import weblogic.jndi.internal.JNDIImageSourceConstants;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.utils.classloaders.GenericClassLoader;

public final class JNDIImageSource
implements ImageSource,
JNDIImageSourceConstants {
    private boolean timedOutCreatingImage;

    public static final ImageSource getJNDIImageSource() {
        return SingletonMaker.singleton;
    }

    private JNDIImageSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void createDiagnosticImage(OutputStream outputStream) {
        InitialContext initialContext = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            GenericClassLoader genericClassLoader = new GenericClassLoader(classLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
            initialContext = new InitialContext();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            this.writeContextInfo(printWriter, initialContext.getNameInNamespace());
            this.printContextInfo(printWriter, initialContext);
            if (!this.timedOutCreatingImage && !printWriter.checkError()) {
                printWriter.flush();
            }
            this.closeContext(initialContext);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (NamingException namingException) {
            this.closeContext(initialContext);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (IOException iOException) {
            this.closeContext(initialContext);
            Thread.currentThread().setContextClassLoader(classLoader);
            {
                catch (Throwable throwable) {
                    this.closeContext(initialContext);
                    Thread.currentThread().setContextClassLoader(classLoader);
                    throw throwable;
                }
            }
        }
    }

    private void printContextInfo(PrintWriter printWriter, Context context) throws NamingException, IOException {
        NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
        while (namingEnumeration.hasMoreElements()) {
            NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
            String string = nameClassPair.getName();
            String string2 = nameClassPair.getClassName();
            try {
                Object object = context.lookup(string);
                if (object instanceof Context) {
                    Context context2 = (Context)object;
                    this.writeContextInfo(printWriter, context2.getNameInNamespace());
                    this.printContextInfo(printWriter, context2);
                    continue;
                }
                this.writeBindingInfo(printWriter, new Binding(string, nameClassPair.getClassName(), object));
            }
            catch (Exception exception) {}
        }
        printWriter.println("</context>");
    }

    private void closeContext(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public void timeoutImageCreation() {
        this.timedOutCreatingImage = true;
    }

    private void writeContextInfo(PrintWriter printWriter, String string) {
        printWriter.println();
        printWriter.print("<context");
        printWriter.println(">");
        printWriter.print("name=\"");
        printWriter.print(string);
        printWriter.println("\"");
    }

    private void writeBindingInfo(PrintWriter printWriter, Binding binding) throws IOException {
        Object object = binding.getObject();
        short s = this.getObjectType(object);
        printWriter.println("<binding");
        printWriter.print("jndi-name=\"");
        printWriter.print(binding.getName());
        printWriter.println("\"");
        printWriter.print("class-name=\"");
        printWriter.print(binding.getClassName());
        printWriter.println("\"");
        printWriter.print("size=\"");
        JNDIImageSource.printObjectSize(printWriter, s, object);
        printWriter.println("\"");
        printWriter.print("type=\"");
        JNDIImageSource.getTypeAsString(printWriter, s);
        printWriter.println("\"");
        printWriter.print("clusterable=\"");
        if (s == 1) {
            if (ServerHelper.isClusterable((Remote)((Remote)object))) {
                printWriter.print("true");
            } else {
                printWriter.print("false");
            }
        } else {
            printWriter.print("false");
        }
        printWriter.println("\"");
        printWriter.print("string-representation=\"");
        printWriter.print(object.toString());
        printWriter.print("\"");
        printWriter.println(">");
        printWriter.println("</binding>");
    }

    private short getObjectType(Object object) {
        if (JNDIHelper.isCorbaObject(object)) {
            return 0;
        }
        if (object instanceof Remote) {
            return 1;
        }
        if (object instanceof Externalizable) {
            return 2;
        }
        if (object == "non-serializable") {
            return 4;
        }
        if (object instanceof Serializable) {
            return 3;
        }
        return 4;
    }

    private static void getTypeAsString(PrintWriter printWriter, short s) {
        switch (s) {
            case 0: {
                printWriter.print("corba");
                break;
            }
            case 1: {
                printWriter.print("remote");
                break;
            }
            case 2: {
                printWriter.print("externalizable");
                break;
            }
            case 3: {
                printWriter.print("serializable");
                break;
            }
            case 4: {
                printWriter.print("non-serializable");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type " + s));
            }
        }
    }

    private static void printObjectSize(PrintWriter printWriter, short s, Object object) throws IOException {
        switch (s) {
            case 0: {
                printWriter.print(0);
                break;
            }
            case 1: {
                printWriter.print(0);
                break;
            }
            case 2: {
                printWriter.print(PassivationUtils.sizeOf(object));
                break;
            }
            case 3: {
                printWriter.print(PassivationUtils.sizeOf(object));
                break;
            }
            case 4: {
                printWriter.print(-1);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type " + s));
            }
        }
    }

    private static class SingletonMaker {
        static final ImageSource singleton = new JNDIImageSource();

        private SingletonMaker() {
        }
    }
}

