/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.AdminModeAccessException;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.cluster.ReplicaHandler;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.utils.Debug;

public class NamingNodeReplicaHandler
implements ReplicaHandler,
Externalizable {
    private static final int MAX_RETRIES = 3;
    private static final long serialVersionUID = -1480987318128214931L;
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugFailOver");
    private String name;
    private transient Environment env = ThreadEnvironment.get();

    public NamingNodeReplicaHandler(ReplicaAwareInfo replicaAwareInfo, RemoteReference remoteReference) {
        this();
        this.name = replicaAwareInfo.getJNDIName();
    }

    public void resetReplicaList(ReplicaList replicaList) {
    }

    public void resetRefreshedCount() {
    }

    public String toString() {
        return "NamingNodeReplicaHandler (for " + this.name + ")";
    }

    public RemoteReference loadBalance(RemoteReference remoteReference, Method method, Object[] objectArray) {
        return remoteReference;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteReference failOver(RemoteReference remoteReference, RuntimeMethodDescriptor runtimeMethodDescriptor, Method method, Object[] objectArray, RemoteException remoteException, RetryHandler retryHandler) throws RemoteException {
        RemoteReference remoteReference2;
        String string;
        Throwable throwable = remoteException.getCause();
        if (remoteReference.getHostID().isLocal()) {
            throw remoteException;
        }
        if (!(throwable instanceof AdminModeAccessException) && !RemoteHelper.isRecoverableFailure((RemoteException)remoteException)) {
            throw remoteException;
        }
        if (retryHandler.getRetryCount() >= 3) {
            throw remoteException;
        }
        String string2 = string = this.name.length() == 0 ? "<InitialContext>" : '\"' + this.name.toString() + '\"';
        if (NamingDebugLogger.isDebugEnabled() && logger.isDebugEnabled()) {
            NamingDebugLogger.debug(string + " attempting failover due to: " + remoteException);
        }
        Context context = null;
        try {
            try {
                context = this.env.getContext(this.name, remoteReference.getHostID());
                RemoteWrapper remoteWrapper = (RemoteWrapper)context;
                RemoteReference remoteReference3 = ((StubInfoIntf)remoteWrapper.getRemoteDelegate()).getStubInfo().getRemoteRef();
                Debug.assertion((boolean)(remoteReference3 instanceof ClusterableRemoteRef));
                RemoteReference remoteReference4 = ((ClusterableRemoteRef)remoteReference3).getCurrentReplica();
                if (NamingDebugLogger.isDebugEnabled() && logger.isDebugEnabled()) {
                    NamingDebugLogger.debug(string + " failing over to " + remoteReference4.getHostID());
                }
                remoteReference2 = remoteReference4;
                Object var15_15 = null;
                if (context == null) return remoteReference2;
            }
            catch (NamingException namingException) {
                if (!NamingDebugLogger.isDebugEnabled()) throw remoteException;
                if (!logger.isDebugEnabled()) throw remoteException;
                NamingDebugLogger.debug(string + " unable to failover due to " + namingException);
                throw remoteException;
            }
        }
        catch (Throwable throwable2) {
            Object var15_16 = null;
            if (context == null) throw throwable2;
            try {
                context.close();
                throw throwable2;
            }
            catch (NamingException namingException2) {
                throw throwable2;
            }
        }
        try {}
        catch (NamingException namingException) {
            // empty catch block
            return remoteReference2;
        }
        context.close();
        return remoteReference2;
    }

    public ReplicaList getReplicaList() {
        return null;
    }

    public NamingNodeReplicaHandler() {
        if (this.env == null) {
            if (KernelStatus.isServer()) {
                this.env = new Environment();
            } else {
                if (NamingDebugLogger.isDebugEnabled() && logger.isDebugEnabled()) {
                    NamingDebugLogger.debug("Environment not found on the thread");
                }
                this.env = new Environment();
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.name);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = objectInput.readUTF();
    }
}

