/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.security.AccessController;
import java.util.Properties;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.jndi.internal.RemoteContextFactoryImpl;
import weblogic.jndi.internal.RootNamingNode;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class NamingService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static NamingService singleton;
    private String urlPkgPrefixes;
    private int state = 0;

    public static NamingService getNamingService() {
        return singleton;
    }

    public NamingService() {
        singleton = this;
    }

    public void start() throws ServiceFailureException {
        Properties properties = System.getProperties();
        properties.put("java.naming.factory.initial", WLInitialContextFactory.class.getName());
        String string = (String)properties.get("java.naming.factory.url.pkgs");
        this.urlPkgPrefixes = string != null && string.length() > 0 ? string + ":" + "weblogic.jndi.factories:weblogic.corba.j2ee.naming.url" : "weblogic.jndi.factories:weblogic.corba.j2ee.naming.url";
        properties.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
        WLNamingManager.initialize();
        RootNamingNode.initialize();
        RemoteContextFactoryImpl.initialize();
        this.changeState(2);
    }

    public String getUrlPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public void stop() throws ServiceFailureException {
        this.changeState(0);
    }

    public void halt() throws ServiceFailureException {
        this.changeState(0);
    }

    private synchronized void changeState(int n) {
        this.state = n;
        ((Object)((Object)this)).notifyAll();
    }

    boolean isRunning() {
        return !ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown();
    }
}

