/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.util.List;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;

public final class NotifyEventListeners {
    private static final boolean DEBUG = true;
    private final List listeners;
    private final NamingEvent namingEvent;
    private final int action;

    NotifyEventListeners(List list, NamingEvent namingEvent, int n) {
        this.listeners = list;
        this.namingEvent = namingEvent;
        this.action = n;
    }

    public void notifyListeners() {
        for (NamingListener namingListener : this.listeners) {
            if (namingListener instanceof ObjectChangeListener) {
                this.handleObjectChangeListener(namingListener);
                continue;
            }
            if (namingListener instanceof NamespaceChangeListener) {
                this.handleNamespaceChangeListener(this.action, namingListener);
                continue;
            }
            throw new AssertionError((Object)(" Unknown event listener " + namingListener + '\t' + namingListener.getClass().getName()));
        }
    }

    private void handleObjectChangeListener(NamingListener namingListener) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)namingListener;
        objectChangeListener.objectChanged(this.namingEvent);
    }

    private void handleNamespaceChangeListener(int n, NamingListener namingListener) {
        NamespaceChangeListener namespaceChangeListener = (NamespaceChangeListener)namingListener;
        switch (n) {
            case 0: {
                namespaceChangeListener.objectAdded(this.namingEvent);
                break;
            }
            case 1: {
                namespaceChangeListener.objectRemoved(this.namingEvent);
                break;
            }
            case 2: {
                namespaceChangeListener.objectRenamed(this.namingEvent);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action: " + n + " on listener " + namingListener));
            }
        }
    }
}

