/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.naming.spi.InitialContextFactory;
import weblogic.jndi.internal.RemoteContextFactory;
import weblogic.jndi.internal.RootNamingNode;
import weblogic.jndi.internal.WLNamingManager;

public class RemoteContextFactoryImpl
implements RemoteContextFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Context getContext(Hashtable hashtable, String string) throws NamingException {
        Object object;
        Context context;
        Hashtable hashtable2 = null;
        try {
            if (hashtable != null) {
                hashtable2 = (Hashtable)hashtable.get("weblogic.jndi.delegate.environment");
            }
        }
        catch (ClassCastException classCastException) {
            throw new NoInitialContextException("Property weblogic.jndi.delegate.environment (" + hashtable.get("weblogic.jndi.delegate.environment") + ") " + "is not an instance of Hashtable");
        }
        if (hashtable2 == null) {
            context = RootNamingNode.getSingleton().getContext(hashtable);
        } else {
            InitialContextFactory initialContextFactory;
            object = (String)hashtable2.get("java.naming.factory.initial");
            if (object == null) {
                throw new NoInitialContextException("Property weblogic.jndi.delegate.environment.java.naming.factory.initial is null");
            }
            try {
                initialContextFactory = (InitialContextFactory)Class.forName((String)object).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoInitialContextException("Failed to find weblogic.jndi.delegate.environment.java.naming.factory.initial (" + (String)object + ") " + "on server");
            }
            catch (ClassCastException classCastException) {
                throw new NoInitialContextException("Class specified by weblogic.jndi.delegate.environment.java.naming.factory.initial (" + (String)object + ") " + "does not implement InitialContextFactory");
            }
            catch (Exception exception) {
                NoInitialContextException noInitialContextException = new NoInitialContextException("Failed to instantiate weblogic.jndi.delegate.environment.java.naming.factory.initial (" + (String)object + ") " + "on server");
                noInitialContextException.setRootCause(exception);
                throw noInitialContextException;
            }
            context = initialContextFactory.getInitialContext(hashtable2);
        }
        if (string == null) return (Context)WLNamingManager.getTransportableInstance(context, null, null, hashtable);
        object = context.lookup(string);
        if (!(object instanceof Context)) throw new NotContextException(string + " is no a context");
        return (Context)object;
    }

    static void initialize() {
    }
}

