/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Serializable;
import java.rmi.ConnectIOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.ServiceAdvertiser;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.internal.AdminModeHandler;
import weblogic.jndi.internal.BasicNamingNode;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.NamingService;
import weblogic.jndi.internal.VersionHandler;
import weblogic.jndi.internal.WLEventContextImpl;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.JNDIResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.AssertionError;
import weblogic.utils.StringUtils;

public class ServerNamingNode
extends BasicNamingNode {
    private static final String DEFAULT_NAME_SEPARATORS = "./";
    private static boolean areStaticsInitialized = false;
    private static ServiceAdvertiser advertiser;
    private static AuthorizationManager am;
    private static final AuthenticatedSubject kernelId;
    private final AdminModeHandler adminHandler = new AdminModeHandler(this);
    private final VersionHandler versionHandler = new VersionHandler(this);
    private String separators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeStatics() {
        if (areStaticsInitialized) return;
        Class<ServerNamingNode> clazz = ServerNamingNode.class;
        synchronized (ServerNamingNode.class) {
            String string;
            if (areStaticsInitialized) return;
            if (ManagementService.getRuntimeAccess(kernelId).getServer().getCluster() != null) {
                advertiser = ServiceAdvertiser.theOne();
            }
            if ((am = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)(string = "weblogicDEFAULT"), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE)) == null) {
                throw new RuntimeException("Security Services Unavailable");
            }
            areStaticsInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    ServerNamingNode() {
        this(DEFAULT_NAME_SEPARATORS, null, "");
    }

    public ServerNamingNode(String string) {
        this(string, null, "");
    }

    ServerNamingNode(String string, ServerNamingNode serverNamingNode, String string2) {
        this(string, serverNamingNode, string2, new ArrayList());
    }

    private ServerNamingNode(String string, ServerNamingNode serverNamingNode, String string2, ArrayList arrayList) {
        super(string, serverNamingNode, string2, arrayList);
        ServerNamingNode.initializeStatics();
        this.separators = string;
    }

    protected BasicNamingNode newSubnode(String string) {
        return new ServerNamingNode(this.separators, this, string, this.subtreeScopeNameListenerList);
    }

    public Context getContext(Hashtable hashtable) {
        try {
            String string = this.getNameInNamespace();
            ServerHelper.exportObject((Remote)this, (String)string);
            return new WLEventContextImpl(hashtable, this);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError("Failed to create stub for " + this.getClass().getName(), (Throwable)remoteException);
        }
    }

    protected void bindHere(String string, Object object, Hashtable hashtable, boolean bl) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        this.checkModify(string2);
        Name name = this.nameParser.parse(string2);
        Object object2 = WLNamingManager.getStateToBind(object, name, null, hashtable);
        boolean bl2 = this.versionHandler.isBindVersioned();
        if (bl && bl2) {
            this.versionHandler.bindHere(string, object2, hashtable);
            if (this.replicateBindings(hashtable)) {
                this.advertiseBinding(string2, object2);
            }
        } else {
            this.adminHandler.checkBind(string, bl2);
            super.bindHere(string, object2, hashtable, false);
            if (bl && this.replicateBindings(hashtable)) {
                this.advertiseBinding(string2, object2);
            }
        }
    }

    private void advertiseBinding(String string, Object object) throws NamingException {
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ advertise bind(" + string + ", " + object.getClass().getName() + ")");
        }
        if (object instanceof Serializable || object instanceof Remote) {
            ServiceAdvertiser.theOne().offerService(string, ApplicationVersionUtils.getBindApplicationId(), object);
        } else {
            JNDILogger.logCannotReplicateObjectInCluster((String)string);
        }
    }

    protected Set listThis(Hashtable hashtable) throws NoPermissionException, NamingException {
        String string = this.getNameInNamespace();
        this.checkList(string);
        if (this.isVersioned()) {
            return this.versionHandler.getAccessibleBindings(super.listThis(hashtable));
        }
        return this.adminHandler.getAccessibleBindings(super.listThis(hashtable));
    }

    protected Object lookupHere(String string, Hashtable hashtable, String string2) throws NoPermissionException, NamingException {
        String string3 = this.getNameInNamespace(string);
        this.checkLookup(string3);
        this.adminHandler.checkLookup(string, string2, hashtable);
        Object object = super.lookupHere(string, hashtable, string2);
        if (string2.length() > 0) {
            return object;
        }
        if (object instanceof ServerNamingNode) {
            object = this.versionHandler.getCurrentVersion((ServerNamingNode)object, hashtable);
        } else if (!this.isVersioned()) {
            this.versionHandler.checkGlobalResource(object, hashtable);
        }
        return object;
    }

    Object superLookupHere(String string, Hashtable hashtable, String string2) throws NoPermissionException, NamingException {
        return super.lookupHere(string, hashtable, string2);
    }

    protected void rebindHere(String string, Object object, Hashtable hashtable, boolean bl) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        this.checkModify(string2);
        Name name = this.nameParser.parse(string2);
        Object object2 = WLNamingManager.getStateToBind(object, name, null, hashtable);
        boolean bl2 = this.versionHandler.isBindVersioned();
        if (bl && bl2) {
            this.versionHandler.rebindHere(string, object2, hashtable);
            if (this.replicateBindings(hashtable)) {
                this.advertiseRebinding(string2, null, object2);
            }
        } else {
            this.adminHandler.checkBind(string, bl2);
            super.rebindHere(string, object2, hashtable, false);
            if (bl && this.replicateBindings(hashtable)) {
                this.advertiseRebinding(string2, null, object2);
            }
        }
    }

    protected void rebindHere(String string, Object object, Object object2, Hashtable hashtable, boolean bl) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        this.checkModify(string2);
        Name name = this.nameParser.parse(string2);
        Object object3 = WLNamingManager.getStateToBind(object2, name, null, hashtable);
        boolean bl2 = this.versionHandler.isBindVersioned();
        if (bl && bl2) {
            this.versionHandler.rebindHere(string, object3, hashtable);
            if (this.replicateBindings(hashtable)) {
                Object object4 = WLNamingManager.getStateToBind(object, name, null, hashtable);
                this.advertiseRebinding(string2, object4, object3);
            }
        } else {
            this.adminHandler.checkBind(string, bl2);
            super.rebindHere(string, object3, hashtable, false);
            if (bl && this.replicateBindings(hashtable)) {
                Object object5 = WLNamingManager.getStateToBind(object, name, null, hashtable);
                this.advertiseRebinding(string2, object5, object3);
            }
        }
    }

    private void advertiseRebinding(String string, Object object, Object object2) throws NamingException {
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ advertise rebind(" + string + ", " + object2.getClass().getName() + ")");
        }
        ServiceAdvertiser.theOne().replaceService(string, ApplicationVersionUtils.getBindApplicationId(), object, object2);
    }

    protected NamingNode createSubnodeHere(String string, Hashtable hashtable) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        this.checkModify(string2);
        NamingNode namingNode = super.createSubnodeHere(string, hashtable);
        if (this.replicateBindings(hashtable)) {
            if (NamingDebugLogger.isDebugEnabled()) {
                NamingDebugLogger.debug("+++ advertise createSubContext(" + string2 + ")");
            }
            ServiceAdvertiser.theOne().createSubcontext(string2);
        }
        return namingNode;
    }

    protected void destroySubnodeHere(String string, Hashtable hashtable) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        this.checkModify(string2);
        super.destroySubnodeHere(string, hashtable);
        if (NamingDebugLogger.isDebugEnabled()) {
            NamingDebugLogger.debug("+++ destroySubContext(" + string2 + ")");
        }
    }

    public void unbindHere(String string, Object object, Hashtable hashtable, boolean bl) throws NoPermissionException, NamingException {
        String string2 = this.getNameInNamespace(string);
        this.checkModify(string2);
        boolean bl2 = this.versionHandler.isBindVersioned();
        if (bl && bl2) {
            this.versionHandler.unbindHere(string, object, hashtable);
            if (this.replicateBindings(hashtable)) {
                this.advertiseUnbinding(string2, object);
            }
        } else {
            this.adminHandler.checkUnbind(string, bl2);
            super.unbindHere(string, object, hashtable, false);
            if (bl && this.replicateBindings(hashtable)) {
                this.advertiseUnbinding(string2, object);
            }
            this.versionHandler.checkUnbind(string, hashtable);
        }
    }

    private void advertiseUnbinding(String string, Object object) throws NamingException {
        if (NamingDebugLogger.isDebugEnabled()) {
            if (object == null) {
                NamingDebugLogger.debug("+++ advertise unbind(" + string + ")");
            } else {
                NamingDebugLogger.debug("+++ advertise unbind(" + string + ", " + object.getClass().getName() + ")");
            }
        }
        ServiceAdvertiser.theOne().retractService(string, ApplicationVersionUtils.getBindApplicationId(), object);
    }

    public void rename(String string, String string2, Hashtable hashtable) throws OperationNotSupportedException, NamingException, RemoteException {
        if (this.replicateBindings(hashtable)) {
            throw new OperationNotSupportedException("replicated rename not supported");
        }
        super.rename(string, string2, hashtable);
    }

    protected Object resolveObject(String string, Object object, int n, Hashtable hashtable) throws NamingException {
        Object object2 = object;
        if (object != null) {
            try {
                if (object instanceof NamingNode) {
                    object2 = ((NamingNode)object).getContext(hashtable);
                } else if (n != 0 && n >= 0) {
                    CompositeName compositeName = new CompositeName(string);
                    object2 = WLNamingManager.getObjectInstance(object, compositeName, null, hashtable);
                    object2 = this.makeTransportable(object2, compositeName, hashtable);
                }
            }
            catch (NamingException namingException) {
                if (!NamingService.getNamingService().isRunning()) {
                    namingException.setRootCause(new ConnectIOException("Server is being shut down"));
                }
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = this.fillInException(new ConfigurationException("Call to NamingManager.getObjectInstance() failed: "), string, object2, null);
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return object2;
    }

    final boolean replicateBindings(Hashtable hashtable) {
        return advertiser != null && (hashtable == null || !"false".equals(this.getProperty(hashtable, "weblogic.jndi.replicateBindings")));
    }

    private final void checkList(String string) throws NoPermissionException {
        this.checkPermission(string, "list");
    }

    private final void checkLookup(String string) throws NoPermissionException {
        this.checkPermission(string, "lookup");
    }

    private final void checkModify(String string) throws NoPermissionException {
        this.checkPermission(string, "modify");
    }

    private final void checkPermission(String string, String string2) throws NoPermissionException {
        String[] stringArray;
        JNDIResource jNDIResource;
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (!am.isAccessAllowed(authenticatedSubject, (Resource)(jNDIResource = new JNDIResource(null, stringArray = StringUtils.splitCompletely((String)string, (String)DEFAULT_NAME_SEPARATORS), string2)), null)) {
            throw new NoPermissionException("User " + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + " does not have permission on " + string + " to perform " + string2 + " operation.");
        }
    }

    protected boolean isVersioned() {
        return this.versionHandler.isVersioned();
    }

    final VersionHandler getVersionHandler() {
        return this.versionHandler;
    }

    static {
        am = null;
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    }
}

