/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.internal.AbstractAdminModeHandler;
import weblogic.jndi.internal.NamingDebugLogger;
import weblogic.jndi.internal.ServerNamingNode;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;

final class VersionHandler
extends AbstractAdminModeHandler {
    private ActiveVersionInfo activeVersionInfo = null;
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");
    private static final boolean debug = DEBUG_APP_VERSION.isEnabled() || NamingDebugLogger.isDebugEnabled();
    private static final Class[] globalResources = new Class[]{DataSource.class, Destination.class, XADataSource.class};

    VersionHandler(ServerNamingNode serverNamingNode) {
        super(serverNamingNode);
    }

    boolean isVersioned() {
        return this.getActiveVersionInfo() != null;
    }

    private ActiveVersionInfo getActiveVersionInfo() {
        return this.activeVersionInfo;
    }

    private ActiveVersionInfo getOrCreateActiveVersionInfo(String string, String string2) {
        if (this.activeVersionInfo == null) {
            this.activeVersionInfo = new ActiveVersionInfo(string, string2);
        }
        return this.activeVersionInfo;
    }

    Object getCurrentVersion(ServerNamingNode serverNamingNode, Hashtable hashtable) throws NoPermissionException, NamingException {
        ActiveVersionInfo activeVersionInfo = serverNamingNode.getVersionHandler().getActiveVersionInfo();
        if (activeVersionInfo == null) {
            return serverNamingNode;
        }
        String string = ApplicationVersionUtils.getCurrentVersionId(activeVersionInfo.appName);
        if (string == null) {
            if (this.allowExternalAppLookup(hashtable)) {
                return this.getActiveVersionObjectAndInit(activeVersionInfo, serverNamingNode, hashtable);
            }
            string = this.getCurrentVersionIdFromEnv(activeVersionInfo.appName, hashtable);
            if (string != null) {
                return this.getActiveVersionObject(activeVersionInfo, serverNamingNode, hashtable);
            }
            if (debug) {
                NamingDebugLogger.debug("+++ allowExternalAppLookup check failed: ActiveVersionInfo=" + activeVersionInfo + ", CurrentApp=" + ApplicationVersionUtils.getCurrentApplicationId() + ", CurrentWorkContext=" + ApplicationVersionUtils.getDebugWorkContexts() + ", JNDIEnv=" + (hashtable == null ? "" : hashtable.toString()) + "\n" + StackTraceUtils.throwable2StackTrace((Throwable)new Exception()));
            }
            JNDILogger.logExternalAppLookupWarning((String)serverNamingNode.getNameInNamespace(""));
            return this.getActiveVersionObjectAndInit(activeVersionInfo, serverNamingNode, hashtable);
        }
        try {
            Object object = serverNamingNode.lookupHere(string, hashtable, "");
            if (debug) {
                NamingDebugLogger.debug("+++ lookupHere(" + serverNamingNode.getNameInNamespace(string) + ") returns " + object);
            }
            return object;
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (this.relaxVersionLookup(hashtable)) {
                return this.getActiveVersionObjectAndInit(activeVersionInfo, serverNamingNode, hashtable);
            }
            throw this.node.newNameNotFoundException(nameNotFoundException.getMessage() + "  Possibly version '" + string + "' of " + "application '" + activeVersionInfo.appName + "' was retired.  To relax " + "lookup to return the active version, set context environment " + "property defined by weblogic.jndi.WLContext.RELAX_VERSION_LOOKUP " + "to \"true\".", "", hashtable);
        }
    }

    private boolean allowExternalAppLookup(Hashtable hashtable) {
        return hashtable != null && "true".equalsIgnoreCase(this.node.getProperty(hashtable, "weblogic.jndi.allowExternalAppLookup"));
    }

    private boolean relaxVersionLookup(Hashtable hashtable) {
        return hashtable != null && "true".equalsIgnoreCase(this.node.getProperty(hashtable, "weblogic.jndi.relaxVersionLookup"));
    }

    private String getCurrentVersionIdFromEnv(String string, Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        String string2 = this.node.getProperty(hashtable, "weblogic.jndi.lookupApplicationId");
        String string3 = ApplicationVersionUtils.getApplicationName(string2);
        if (string != null && string.equals(string3)) {
            return ApplicationVersionUtils.getVersionId(string2);
        }
        return null;
    }

    private Object getActiveVersionObject(ActiveVersionInfo activeVersionInfo, ServerNamingNode serverNamingNode, Hashtable hashtable) throws NameNotFoundException, NamingException {
        return this.getActiveVersionObject(activeVersionInfo, serverNamingNode, hashtable, false);
    }

    private Object getActiveVersionObjectAndInit(ActiveVersionInfo activeVersionInfo, ServerNamingNode serverNamingNode, Hashtable hashtable) throws NameNotFoundException, NamingException {
        return this.getActiveVersionObject(activeVersionInfo, serverNamingNode, hashtable, true);
    }

    private Object getActiveVersionObject(ActiveVersionInfo activeVersionInfo, ServerNamingNode serverNamingNode, Hashtable hashtable, boolean bl) throws NameNotFoundException, NamingException {
        String string;
        boolean bl2 = this.isAdminModeRequest(activeVersionInfo);
        String string2 = string = bl2 ? activeVersionInfo.adminModeVersionId : activeVersionInfo.versionId;
        if (string == null) {
            if (debug) {
                NamingDebugLogger.debug("+++ getActiveVersion failed, info=" + activeVersionInfo + ", isAdmin=" + this.isAdminModeRequest(activeVersionInfo));
            }
            throw this.node.newNameNotFoundException("Unable to resolve '" + serverNamingNode.getNameInNamespace("") + "'.  " + "Possibly previously active version was already unbound.", "", hashtable);
        }
        Object object = bl2 ? activeVersionInfo.adminModeObject : activeVersionInfo.object;
        if (bl) {
            ApplicationVersionUtils.setCurrentVersionId(activeVersionInfo.appName, string);
            if (debug) {
                NamingDebugLogger.debug("+++ setCurrentVersionId(appName=" + activeVersionInfo.appName + ", versionId=" + string + ", admin=" + bl2 + ")");
            }
        }
        return object;
    }

    private boolean isAdminModeRequest(ActiveVersionInfo activeVersionInfo) {
        if (activeVersionInfo.adminModeVersionId == null) {
            return false;
        }
        return ApplicationVersionUtils.isAdminModeRequest();
    }

    boolean isBindVersioned() {
        return ApplicationVersionUtils.getBindApplicationId() != null;
    }

    void bindHere(String string, Object object, Hashtable hashtable) throws NoPermissionException, NamingException {
        Object object2;
        if (object instanceof Context) {
            throw new NamingException("Context cannot be versioned");
        }
        ServerNamingNode serverNamingNode = null;
        String string2 = ApplicationVersionUtils.getBindApplicationId();
        String string3 = ApplicationVersionUtils.getApplicationName(string2);
        try {
            object2 = this.node.superLookupHere(string, hashtable, "");
            if (!(object2 instanceof ServerNamingNode)) {
                throw this.node.fillInException(new NameAlreadyBoundException(string + " is already bound"), string, object2, "");
            }
            serverNamingNode = (ServerNamingNode)object2;
            this.checkApp(serverNamingNode, string3, string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            serverNamingNode = (ServerNamingNode)this.node.createSubnodeHere(string, this.getNoReplicateBindingsEnv(hashtable));
        }
        object2 = ApplicationVersionUtils.getVersionId(string2);
        if (debug) {
            NamingDebugLogger.debug("+++ >>> bindVersionHere(" + string + ", " + serverNamingNode.getNameInNamespace((String)object2) + ", " + object.getClass().getName() + ")");
        }
        serverNamingNode.bindHere((String)object2, object, hashtable, false);
        if (debug) {
            NamingDebugLogger.debug("+++ <<< bindVersionHere(" + string + ", " + serverNamingNode.getNameInNamespace((String)object2) + ", " + object.getClass().getName() + ") succeeded");
        }
        this.updateActiveVersionInfo(serverNamingNode, string3, (String)object2, object);
    }

    void rebindHere(String string, Object object, Hashtable hashtable) throws NoPermissionException, NamingException {
        if (object instanceof Context) {
            throw new NamingException("Context cannot be versioned");
        }
        ServerNamingNode serverNamingNode = null;
        String string2 = ApplicationVersionUtils.getBindApplicationId();
        String string3 = ApplicationVersionUtils.getApplicationName(string2);
        String string4 = ApplicationVersionUtils.getVersionId(string2);
        try {
            Object object2 = this.node.superLookupHere(string, hashtable, "");
            if (!(object2 instanceof ServerNamingNode)) {
                throw this.node.fillInException(new NamingException(string + " was bound without version previously." + "  Cannot rebind with version '" + string4 + "'."), string, object2, "");
            }
            serverNamingNode = (ServerNamingNode)object2;
            this.checkApp(serverNamingNode, string3, string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            serverNamingNode = (ServerNamingNode)this.node.createSubnodeHere(string, this.getNoReplicateBindingsEnv(hashtable));
        }
        if (debug) {
            NamingDebugLogger.debug("+++ >>> rebindVersionHere(" + serverNamingNode.getNameInNamespace(string4) + ", " + object.getClass().getName() + ")");
        }
        serverNamingNode.rebindHere(string4, object, hashtable, false);
        if (debug) {
            NamingDebugLogger.debug("+++ <<< rebindVersionHere(" + serverNamingNode.getNameInNamespace(string4) + ", " + object.getClass().getName() + ") succeeded");
        }
        this.updateActiveVersionInfo(serverNamingNode, string3, string4, object);
    }

    void unbindHere(String string, Object object, Hashtable hashtable) throws NoPermissionException, NamingException {
        ActiveVersionInfo activeVersionInfo;
        Object object2 = this.node.superLookupHere(string, hashtable, "");
        String string2 = ApplicationVersionUtils.getBindApplicationId();
        String string3 = ApplicationVersionUtils.getApplicationName(string2);
        String string4 = ApplicationVersionUtils.getVersionId(string2);
        if (!(object2 instanceof ServerNamingNode)) {
            throw this.node.fillInException(new NamingException(string + " is bound without version previously.  Cannot unbind " + "with version '" + string4 + "'."), string, object2, "");
        }
        ServerNamingNode serverNamingNode = (ServerNamingNode)object2;
        this.checkApp(serverNamingNode, string3, string);
        if (debug) {
            NamingDebugLogger.debug("+++ >>> unbindVersionHere(" + serverNamingNode.getNameInNamespace(string4) + ")");
        }
        serverNamingNode.unbindHere(string4, object, hashtable, false);
        if (debug) {
            NamingDebugLogger.debug("+++ <<< unbindVersionHere(" + serverNamingNode.getNameInNamespace(string4) + ") succeeded");
        }
        if ((activeVersionInfo = serverNamingNode.getVersionHandler().getActiveVersionInfo()) != null && serverNamingNode.isUnbound(string4)) {
            activeVersionInfo.unsetActive(string4);
        }
    }

    void checkUnbind(String string, Hashtable hashtable) throws NamingException {
        if (this.isVersioned() && this.node.getNumOfBindings() == 0) {
            if (debug) {
                NamingDebugLogger.debug("+++ No more versions after unbinding " + string + ", unbindHere(" + this.node.getNameInNamespace() + ")");
            }
            String string2 = this.node.getRelativeName();
            ServerNamingNode serverNamingNode = (ServerNamingNode)this.node.getParent();
            serverNamingNode.destroySubnodeHere(string2, this.getNoReplicateBindingsEnv(hashtable));
        }
    }

    private void checkApp(ServerNamingNode serverNamingNode, String string, String string2) throws NamingException {
        if (!serverNamingNode.isVersioned()) {
            return;
        }
        ActiveVersionInfo activeVersionInfo = serverNamingNode.getVersionHandler().getActiveVersionInfo();
        if (activeVersionInfo != null && activeVersionInfo.name != null && !activeVersionInfo.appName.equals(string) && serverNamingNode.getNumOfBindings() > 0) {
            throw this.node.fillInException(new NamingException(string2 + " was previously bound from another application '" + activeVersionInfo.appName + "'"), string2, null, "");
        }
    }

    private Hashtable getNoReplicateBindingsEnv(Hashtable hashtable) {
        if (!this.node.replicateBindings(hashtable)) {
            return hashtable;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
        hashtable2.put("weblogic.jndi.replicateBindings", "false");
        return hashtable2;
    }

    private void updateActiveVersionInfo(ServerNamingNode serverNamingNode, String string, String string2, Object object) throws NoPermissionException, NamingException {
        ActiveVersionInfo activeVersionInfo = serverNamingNode.getVersionHandler().getOrCreateActiveVersionInfo(serverNamingNode.getNameInNamespace(), string);
        activeVersionInfo.delaySetActive(string2, object);
    }

    private boolean allowGlobalResourceLookup(Hashtable hashtable) {
        return hashtable != null && "true".equalsIgnoreCase(this.node.getProperty(hashtable, "weblogic.jndi.allowGlobalResourceLookup"));
    }

    void checkGlobalResource(Object object, Hashtable hashtable) throws NamingException {
        if (ApplicationVersionUtils.getCurrentVersionId() == null) {
            return;
        }
        int n = globalResources.length;
        for (int i = 0; i < n; ++i) {
            if (!globalResources[i].isInstance(object)) continue;
            if (this.allowGlobalResourceLookup(hashtable)) {
                return;
            }
            if (debug) {
                NamingDebugLogger.debug("+++ checkGlobalResource failed: CurrentApp=" + ApplicationVersionUtils.getCurrentApplicationId() + ", CurrentWorkContext=" + ApplicationVersionUtils.getDebugWorkContexts() + ", JNDIEnv=" + (hashtable == null ? "" : hashtable.toString()) + ", object=" + object + ", class=" + object.getClass().getName() + "\n" + StackTraceUtils.throwable2StackTrace((Throwable)new Exception()));
            }
            String string = ApplicationVersionUtils.getDisplayName(ApplicationVersionUtils.getCurrentApplicationId());
            JNDILogger.logGlobalResourceLookupWarning((String)this.node.getNameInNamespace(""), (String)string);
        }
    }

    private final class ActiveVersionInfo {
        private String name;
        private String appName;
        private String versionId;
        private Object object;
        private String adminModeVersionId;
        private Object adminModeObject;
        private Hashtable listeners = new Hashtable();

        private ActiveVersionInfo(String string, String string2) {
            this.name = string;
            this.appName = string2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ActiveVersionInfo[name=").append(this.name).append(",appName=").append(this.appName).append(",version=").append(this.versionId).append(",adminVersion=").append(this.adminModeVersionId).append("]");
            return stringBuffer.toString();
        }

        private void setActive(String string, Object object, boolean bl) {
            if (bl) {
                this.adminModeVersionId = string;
                this.adminModeObject = object;
                VersionHandler.this.setAdminMode(string);
            } else {
                this.versionId = string;
                this.object = object;
            }
            if (debug) {
                NamingDebugLogger.debug("+++ ActiveVersionInfo.setActive(name=" + this.name + ", appName=" + this.appName + ", versionId=" + string + ", admin=" + bl + "), info=" + this);
            }
        }

        private void delaySetActive(String string, Object object) {
            ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getCurrentApplicationRuntime();
            if (applicationRuntimeMBean == null) {
                this.setActive(string, object, false);
            } else {
                if (debug) {
                    NamingDebugLogger.debug("+++ ActiveVersionInfo.delaySetActive(name=" + this.name + ", appName=" + this.appName + ", versionId=" + string + ")");
                }
                StateChangeListener stateChangeListener = new StateChangeListener(this, string, object);
                applicationRuntimeMBean.addPropertyChangeListener(stateChangeListener);
                this.listeners.put(string, stateChangeListener);
                int n = applicationRuntimeMBean.getActiveVersionState();
                if (this.isActiveState(n)) {
                    this.setActive(string, object, n == 1);
                }
            }
        }

        private void unsetActive(String string) {
            if (debug) {
                NamingDebugLogger.debug("+++ ActiveVersionInfo.unsetActive(name=" + this.name + ", appName=" + this.appName + ", versionId=" + string + ", info=" + this);
            }
            if (string.equals(this.versionId)) {
                this.versionId = null;
                this.object = null;
            } else if (string.equals(this.adminModeVersionId)) {
                this.adminModeVersionId = null;
                this.adminModeObject = null;
            }
            VersionHandler.this.unsetAdminMode(string);
            StateChangeListener stateChangeListener = (StateChangeListener)this.listeners.remove(string);
            if (stateChangeListener == null) {
                return;
            }
            ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getCurrentApplicationRuntime();
            if (applicationRuntimeMBean == null) {
                return;
            }
            try {
                applicationRuntimeMBean.removePropertyChangeListener(stateChangeListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void adminTransition(String string, Object object, boolean bl, boolean bl2) {
            if (bl && !bl2) {
                if (this.adminModeVersionId != null && this.adminModeVersionId.equals(string)) {
                    this.adminModeVersionId = null;
                    this.adminModeObject = null;
                }
                this.versionId = string;
                this.object = object;
                VersionHandler.this.unsetAdminMode(string);
            } else if (!bl && bl2) {
                if (this.versionId != null && this.versionId.equals(string)) {
                    this.versionId = null;
                    this.object = null;
                }
                this.adminModeVersionId = string;
                this.adminModeObject = object;
                VersionHandler.this.setAdminMode(string);
            }
            if (debug) {
                NamingDebugLogger.debug("+++ ActiveVersionInfo.adminTransition(name=" + this.name + ", appName=" + this.appName + ", versionId=" + string + ", admin=" + bl2 + "), info=" + this);
            }
        }

        private boolean isActiveState(int n) {
            return n == 2 || n == 1;
        }

        private final class StateChangeListener
        implements PropertyChangeListener {
            ActiveVersionInfo info;
            String versionId;
            Object object;

            private StateChangeListener(ActiveVersionInfo activeVersionInfo2, String string, Object object) {
                this.info = activeVersionInfo2;
                this.versionId = string;
                this.object = object;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("ActiveVersionState")) {
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object instanceof Integer && object2 instanceof Integer) {
                        int n = (Integer)object;
                        int n2 = (Integer)object2;
                        if (debug) {
                            NamingDebugLogger.debug("+++ StateChange for name=" + ActiveVersionInfo.this.name + ", appName=" + ActiveVersionInfo.this.appName + ", versionId=" + this.versionId + ", oldState=" + n + ", newState=" + n2);
                        }
                        if (n == n2) {
                            return;
                        }
                        if (ActiveVersionInfo.this.isActiveState(n2)) {
                            if (n == 0) {
                                ActiveVersionInfo.this.setActive(this.versionId, this.object, n2 == 1);
                            } else if (ActiveVersionInfo.this.isActiveState(n)) {
                                ActiveVersionInfo.this.adminTransition(this.versionId, this.object, n == 1, n2 == 1);
                            }
                        } else if (ActiveVersionInfo.this.isActiveState(n)) {
                            ActiveVersionInfo.this.unsetActive(this.versionId);
                        }
                    }
                }
            }
        }
    }
}

