/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.jndi.Alias;
import weblogic.jndi.JNDILogger;
import weblogic.jndi.internal.ExceptionTranslator;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.WLInternalContext;
import weblogic.jndi.internal.WLNameParser;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ProtocolStack;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TransactionHelper;

public class WLContextImpl
implements WLInternalContext,
RemoteWrapper,
Externalizable {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static final long serialVersionUID = -7759756621062870766L;
    private NamingNode node;
    private Hashtable env;
    private transient Thread loginThread = null;
    private transient boolean disableWarning = false;
    private transient boolean enableLogout;

    public WLContextImpl(Hashtable hashtable, NamingNode namingNode) {
        this.node = namingNode;
        this.env = hashtable;
        if (!this.isLocalURL()) {
            String string;
            this.loginThread = Thread.currentThread();
            if (hashtable != null && (string = (String)hashtable.get("weblogic.jndi.disableLoggingOfWarningMsg")) != null) {
                this.disableWarning = Boolean.parseBoolean(string);
            }
        }
    }

    public Remote getRemoteDelegate() {
        return this.node;
    }

    public void enableLogoutOnClose() {
        this.loginThread = Thread.currentThread();
        this.enableLogout = true;
    }

    public void disableThreadWarningOnClose() {
        this.disableWarning = true;
    }

    public void close() throws NamingException {
        if (this.loginThread != null) {
            if (this.loginThread != Thread.currentThread()) {
                if (!this.disableWarning) {
                    JNDILogger.logDiffThread();
                }
            } else {
                if (!this.isLocalURL()) {
                    ProtocolStack.pop();
                }
                if (this.enableLogout) {
                    SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
                    JNDIEnvironment.getJNDIEnvironment().nullSSLClientCertificate();
                }
            }
            this.loginThread = null;
        }
        TransactionHelper.popTransactionHelper();
        if (RemoteHelper.getClientTimeout() > 0L) {
            RemoteHelper.setClientTimeout((long)0L);
        }
    }

    private final boolean isLocalURL() {
        return this.env != null && this.env.get("java.naming.provider.url") == null && KernelStatus.isServer();
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        try {
            return this.node.createSubcontext(string, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        try {
            return this.node.lookupLink(string, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        try {
            this.node.destroySubcontext(string, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        try {
            this.node.rebind(name, object, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rebind(String string, Object object) throws NamingException {
        try {
            this.node.rebind(string, object, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rebind(String string, Object object, Object object2) throws NamingException {
        try {
            this.node.rebind(string, object, object2, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        try {
            return this.node.getNameParser(string, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        try {
            return this.node.list(string, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        Object var2_2 = null;
        if (this.env != null) {
            var2_2 = this.env.remove(string);
        }
        if (this.env.size() == 0) {
            this.env = null;
        }
        return var2_2;
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String string) throws NamingException {
        try {
            this.node.unbind(string, null, this.env);
        }
        catch (RemoteException remoteException) {
            this.translateException(remoteException);
        }
    }

    public void unbind(Name name, Object object) throws NamingException {
        this.unbind(name.toString(), object);
    }

    public void unbind(String string, Object object) throws NamingException {
        try {
            this.node.unbind(string, object, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return new CompositeName(this.composeName(name.toString(), name2.toString()));
    }

    public String composeName(String string, String string2) throws NamingException {
        if (string2.length() == 0) {
            return string2;
        }
        try {
            NamingNode namingNode = this.node.getParent();
            NameParser nameParser = this.getNameParser("");
            if (namingNode == null || !namingNode.getNameParser("", this.env).equals(nameParser)) {
                if (string.length() == 0) {
                    return string2;
                }
                return string2 + "." + string;
            }
            if (string.length() == 0) {
                return string2;
            }
            return string2 + "." + string;
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public String getNameInNamespace() throws NamingException {
        try {
            return this.node.getNameInNamespace();
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public String getNameInNamespace(String string) throws NamingException {
        try {
            return this.node.getNameInNamespace(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        try {
            return this.node.listBindings(string, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        try {
            this.node.rename(string, string2, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public Object lookup(Name name) throws NamingException {
        Object object = this.lookup(name, name.toString());
        if (object instanceof Alias) {
            String string = ((Alias)object).getRealName();
            object = this.lookup(string);
        }
        return object;
    }

    public Object lookup(String string) throws NamingException {
        Object object = this.lookup(WLNameParser.defaultParse(string), string);
        if (object instanceof Alias) {
            string = ((Alias)object).getRealName();
            object = this.lookup(string);
        }
        return object;
    }

    protected Object lookup(Name name, String string) throws NamingException {
        try {
            Object object = this.node.lookup(string, this.env);
            ServerHelper.ensureJNDIName((Object)object, (String)string);
            return NamingManager.getObjectInstance(object, name, this, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new NamingException(exception.getMessage());
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void bind(String string, Object object) throws NamingException {
        try {
            this.node.bind(string, object, this.env);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(5);
        }
        return this.env.put(string, object);
    }

    public NamingNode getNode() {
        return this.node;
    }

    protected NamingException translateException(RemoteException remoteException) {
        return ExceptionTranslator.toNamingException(remoteException);
    }

    public boolean equals(Object object) {
        return this.node.equals(((WLContextImpl)object).getNode());
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        try {
            return "WLContext (" + this.getNameInNamespace() + ")";
        }
        catch (NamingException namingException) {
            return "WLContext ( NAME UNKNOWN )";
        }
    }

    public WLContextImpl() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof WLObjectOutput) {
            WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
            wLObjectOutput.writeObjectWL((Object)this.node);
            wLObjectOutput.writeObjectWL((Object)this.env);
        } else {
            ObjectOutput objectOutput2 = JNDIEnvironment.getJNDIEnvironment().getReplacerObjectOutputStream(objectOutput);
            objectOutput2.writeObject(this.node);
            objectOutput2.writeObject(this.env);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput instanceof WLObjectInput) {
            WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
            this.node = (NamingNode)wLObjectInput.readObjectWL();
            this.env = (Hashtable)wLObjectInput.readObjectWL();
        } else {
            ObjectInput objectInput2 = JNDIEnvironment.getJNDIEnvironment().getReplacerObjectInputStream(objectInput);
            this.node = (NamingNode)objectInput2.readObject();
            this.env = (Hashtable)objectInput2.readObject();
        }
    }
}

