/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;
import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingNode;
import weblogic.jndi.internal.WLContextImpl;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.utils.AssertionError;

public final class WLEventContextImpl
extends WLContextImpl
implements EventContext,
Externalizable,
InteropWriteReplaceable {
    private List listeners = Collections.synchronizedList(new ArrayList());
    public static final String ENABLE_EVENTS = "weblogic.jndi.events.enable";
    private static final long serialVersionUID = -570490474896887060L;
    private NamingNode node;
    private Hashtable env;
    private boolean copyNotRequired;

    public WLEventContextImpl(Hashtable hashtable, NamingNode namingNode, boolean bl) {
        super(hashtable, namingNode);
        this.node = namingNode;
        this.env = hashtable;
        this.copyNotRequired = bl;
    }

    public WLEventContextImpl(Hashtable hashtable, NamingNode namingNode) {
        this(hashtable, namingNode, false);
    }

    public Context createSubcontext(String string) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.createSubcontext(string, this.env);
            }
            return super.createSubcontext(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public java.lang.Object lookupLink(String string) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.lookupLink(string, this.env);
            }
            return super.lookupLink(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void destroySubcontext(String string) throws NamingException {
        try {
            if (this.node != null) {
                this.node.destroySubcontext(string, this.env);
            } else {
                super.destroySubcontext(string);
            }
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rebind(String string, java.lang.Object object) throws NamingException {
        try {
            if (this.node != null) {
                java.lang.Object object2 = this.copyObject(object);
                this.node.rebind(string, object2, this.env);
            } else {
                super.rebind(string, object);
            }
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rebind(String string, java.lang.Object object, java.lang.Object object2) throws NamingException {
        try {
            if (this.node != null) {
                java.lang.Object object3 = this.copyObject(object2);
                java.lang.Object object4 = this.copyObject(object);
                this.node.rebind(string, object4, object3, this.env);
            } else {
                super.rebind(string, object, object2);
            }
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public NameParser getNameParser(String string) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.getNameParser(string, this.env);
            }
            return super.getNameParser(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public NamingEnumeration list(String string) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.list(string, this.env);
            }
            return super.list(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void unbind(String string) throws NamingException {
        try {
            if (this.node != null) {
                this.node.unbind(string, null, this.env);
            } else {
                super.unbind(string);
            }
        }
        catch (RemoteException remoteException) {
            this.translateException(remoteException);
        }
    }

    public void unbind(String string, java.lang.Object object) throws NamingException {
        try {
            if (this.node != null) {
                this.node.unbind(string, object, this.env);
            } else {
                super.unbind(string, object);
            }
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public String getNameInNamespace() throws NamingException {
        try {
            if (this.node != null) {
                return this.node.getNameInNamespace();
            }
            return super.getNameInNamespace();
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public String getNameInNamespace(String string) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.getNameInNamespace(string);
            }
            return super.getNameInNamespace(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        try {
            if (this.node != null) {
                return this.node.listBindings(string, this.env);
            }
            return super.listBindings(string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public void rename(String string, String string2) throws NamingException {
        try {
            if (this.node != null) {
                this.node.rename(string, string2, this.env);
            } else {
                super.rename(string, string2);
            }
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    protected java.lang.Object lookup(Name name, String string) throws NamingException {
        try {
            if (this.node != null) {
                java.lang.Object object = this.node.lookup(string, this.env);
                return NamingManager.getObjectInstance(this.copyObject(object), name, this, this.env);
            }
            return super.lookup(name, string);
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new NamingException(exception.getMessage());
        }
    }

    public void bind(String string, java.lang.Object object) throws NamingException {
        try {
            if (this.node != null) {
                java.lang.Object object2 = this.copyObject(object);
                this.node.bind(string, object2, this.env);
            } else {
                super.bind(string, object);
            }
        }
        catch (RemoteException remoteException) {
            throw this.translateException(remoteException);
        }
    }

    public boolean equals(java.lang.Object object) {
        if (this.node != null) {
            return this.node.equals(((WLEventContextImpl)object).getNode());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.node == null ? super.hashCode() : this.node.hashCode();
    }

    public void addNamingListener(Name name, int n, NamingListener namingListener) throws NamingException {
        this.addNamingListener(name.toString(), n, namingListener);
    }

    public void addNamingListener(String string, int n, NamingListener namingListener) throws NamingException {
        if (this.node == null) {
            throw new OperationNotSupportedException("Unsupported operationaddNamingListener");
        }
        this.node.addNamingListener(string, n, namingListener, this.env);
        this.listeners.add(namingListener);
    }

    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        if (this.node == null) {
            throw new OperationNotSupportedException("Unsupported operationaddNamingListener");
        }
        this.node.removeNamingListener(namingListener, this.env);
        this.listeners.remove(namingListener);
    }

    public boolean targetMustExist() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws NamingException {
        super.close();
        List list = this.listeners;
        synchronized (list) {
            for (NamingListener namingListener : this.listeners) {
                if (this.node != null) {
                    this.node.removeNamingListener(namingListener, this.env);
                }
                this.removeNamingListener(namingListener);
            }
        }
    }

    public String toString() {
        try {
            return "EventContext (" + this.getNameInNamespace() + ")";
        }
        catch (NamingException namingException) {
            return "EventContext ( NAME UNKNOWN )";
        }
    }

    private java.lang.Object copyObject(java.lang.Object object) throws RemoteException {
        if (this.copyNotRequired) {
            return object;
        }
        try {
            if (object instanceof Proxy) {
                return JNDIEnvironment.getJNDIEnvironment().copyObject(object);
            }
            if (object instanceof Object || object instanceof Servant || JNDIEnvironment.getJNDIEnvironment().isCorbaStub(object)) {
                java.lang.Object object2 = JNDIEnvironment.getJNDIEnvironment().iiopReplaceObject(object);
                return JNDIEnvironment.getJNDIEnvironment().iiopResolveObject(object2);
            }
            if (object instanceof Remote) {
                Remote remote = (Remote)object;
                return ServerHelper.replaceAndResolveRemoteObject((Remote)remote);
            }
            if (object instanceof Serializable) {
                return JNDIEnvironment.getJNDIEnvironment().copyObject(object);
            }
            return object;
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteException(classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    public java.lang.Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        int n = peerInfo.getMajor();
        int n2 = peerInfo.getMinor();
        int n3 = peerInfo.getServicePack();
        if (n == 7 && n2 == 0 && n3 >= 3 || n == 8 && n2 == 1 && n3 >= 1) {
            return new WLEventContextImpl(this.env, this.node);
        }
        return new WLContextImpl(this.env, this.node);
    }

    public WLEventContextImpl() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        try {
            NamingNode namingNode = this.getNode();
            if (ServerHelper.isLocal((Remote)namingNode)) {
                this.node = (NamingNode)ServerHelper.getServerReference((Remote)namingNode).getImplementation();
                this.env = this.getEnvironment();
                this.copyNotRequired = false;
                this.listeners = new ArrayList();
            }
        }
        catch (NamingException namingException) {
            throw new AssertionError("Unexpected exception", (Throwable)namingException);
        }
    }

    public java.lang.Object readResolve() throws ObjectStreamException {
        if (this.node != null) {
            return this;
        }
        try {
            return new WLContextImpl(this.getEnvironment(), this.getNode());
        }
        catch (NamingException namingException) {
            throw new AssertionError("Unexpected exception", (Throwable)namingException);
        }
    }
}

