/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;

public final class WLNameParser
implements NameParser,
Externalizable {
    private static final long serialVersionUID = 8031032025200514222L;
    private static final Properties defaultProps = new Properties();
    private Properties nameProps;

    public WLNameParser() {
        this.nameProps = defaultProps;
    }

    public WLNameParser(String string) {
        this.nameProps = (Properties)defaultProps.clone();
        if (string.length() > 0) {
            this.nameProps.put("jndi.syntax.separator", "" + string.charAt(0));
            if (string.length() > 1) {
                this.nameProps.put("jndi.syntax.separator2", "" + string.charAt(1));
            }
        } else {
            this.nameProps.put("jndi.syntax.ignorecase", "false");
            this.nameProps.put("jndi.syntax.direction", "flat");
        }
    }

    public Name parse(String string) throws NamingException {
        return new CompoundName(string, this.nameProps);
    }

    public static Name defaultParse(String string) throws NamingException {
        return new CompoundName(string, defaultProps);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof WLObjectOutput) {
            ((WLObjectOutput)objectOutput).writeProperties(this.nameProps);
        } else {
            objectOutput.writeObject(this.nameProps);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.nameProps = objectInput instanceof WLObjectInput ? ((WLObjectInput)objectInput).readProperties() : (Properties)objectInput.readObject();
    }

    static {
        defaultProps.put("jndi.syntax.direction", "left_to_right");
        defaultProps.put("jndi.syntax.separator", ".");
        defaultProps.put("jndi.syntax.ignorecase", "false");
        defaultProps.put("jndi.syntax.escape", "\\");
        defaultProps.put("jndi.syntax.beginquote", "\"");
        defaultProps.put("jndi.syntax.endquote", "\"");
        defaultProps.put("jndi.syntax.beginquote2", "'");
        defaultProps.put("jndi.syntax.endquote2", "'");
        defaultProps.put("jndi.syntax.separator.ava", ",");
        defaultProps.put("jndi.syntax.separator.typeval", "=");
    }
}

