/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.NamingFactoriesDebugLogger;
import weblogic.jndi.internal.WLContextImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;

public final class WLNamingManager {
    private static List transportableFactories = null;
    private static List stateFactories = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws ServiceFailureException {
        Class<WLNamingManager> clazz = WLNamingManager.class;
        synchronized (WLNamingManager.class) {
            if (transportableFactories == null) {
                transportableFactories = new ArrayList();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                JNDIEnvironment.getJNDIEnvironment().loadTransportableFactories(transportableFactories);
            }
            catch (ConfigurationException configurationException) {
                throw new ServiceFailureException((Throwable)configurationException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStateFactory(StateFactory stateFactory) throws NamingException {
        if (stateFactories == null) {
            WLNamingManager.loadStateFactories();
        }
        List list = stateFactories;
        synchronized (list) {
            stateFactories.add(0, stateFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTransportableFactory(ObjectFactory objectFactory) {
        List list = transportableFactories;
        synchronized (list) {
            transportableFactories.add(0, objectFactory);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (object instanceof OpaqueReference) {
            return ((OpaqueReference)object).getReferent(name, context);
        }
        if (!(object instanceof LinkRef)) return object;
        String string = ((LinkRef)object).getLinkName();
        InitialContext initialContext = null;
        try {
            try {
                initialContext = new InitialContext(hashtable);
                object = initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                LinkException linkException = new LinkException("");
                linkException.setLinkRemainingName(new CompositeName(string));
                linkException.setLinkResolvedName(name);
                linkException.setLinkResolvedObj(object);
                linkException.setRootCause(namingException);
                throw linkException;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            try {
                initialContext.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        initialContext.close();
        return object;
    }

    public static Object getTransportableInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        return WLNamingManager.getReplacement(transportableFactories, object, name, context, hashtable);
    }

    public static Object getStateToBind(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (object instanceof WLContextImpl) {
            return ((WLContextImpl)object).getNode();
        }
        if (object instanceof Referenceable) {
            return ((Referenceable)object).getReference();
        }
        Object object2 = NamingManager.getStateToBind(object, name, context, hashtable);
        if (object2 == object) {
            if (stateFactories == null) {
                WLNamingManager.loadStateFactories();
            }
            object2 = WLNamingManager.getReplacement(stateFactories, object, name, context, hashtable);
        }
        return object2;
    }

    private static Object getReplacement(List list, Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Object object2 = object;
        if (list == null) {
            return object2;
        }
        for (Object e : list) {
            Object object3 = null;
            try {
                object3 = e instanceof ObjectFactory ? ((ObjectFactory)e).getObjectInstance(object, name, context, hashtable) : ((StateFactory)e).getStateToBind(object, name, context, hashtable);
                if (object3 == null) continue;
                object2 = object3;
                break;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                ConfigurationException configurationException = new ConfigurationException(e.getClass().getName() + " threw an exception");
                configurationException.setRootCause(exception);
                throw configurationException;
            }
        }
        if (NamingFactoriesDebugLogger.isDebugEnabled() && object2 != object) {
            NamingFactoriesDebugLogger.debug("Replacing " + object.getClass().getName() + " with " + object2.getClass().getName());
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStateFactories() {
        Class<WLNamingManager> clazz = WLNamingManager.class;
        synchronized (WLNamingManager.class) {
            if (stateFactories == null) {
                stateFactories = new ArrayList();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

