/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.remote;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.jndi.remote.RemoteAttribute;
import weblogic.rmi.extensions.RemoteRuntimeException;

public final class AttributeWrapper
implements RemoteAttribute {
    private Attribute delegate;
    private Hashtable env;

    protected Hashtable env() {
        return this.env;
    }

    public Attribute delegate() {
        return this.delegate;
    }

    public AttributeWrapper(Attribute attribute, Hashtable hashtable) {
        this.delegate = attribute;
        this.env = hashtable;
    }

    public boolean add(Object object) {
        return this.delegate.add(object);
    }

    public void add(int n, Object object) {
        this.delegate.add(n, object);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Object clone() {
        try {
            return this.makeTransportable(this.delegate.clone());
        }
        catch (NamingException namingException) {
            throw new RemoteRuntimeException("Failed to create a transportable instance of " + this.delegate + " due to :", (Throwable)namingException);
        }
    }

    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    public Object get() throws NamingException {
        return this.makeTransportable(this.delegate.get());
    }

    public Object get(int n) throws NamingException {
        return this.makeTransportable(this.delegate.get(n));
    }

    public NamingEnumeration getAll() throws NamingException {
        return this.makeTransportable(this.delegate.getAll());
    }

    public DirContext getAttributeDefinition() throws NamingException {
        return this.makeTransportable(this.delegate.getAttributeDefinition());
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        return this.makeTransportable(this.delegate.getAttributeSyntaxDefinition());
    }

    public String getID() {
        return this.delegate.getID();
    }

    public boolean isOrdered() {
        return this.delegate.isOrdered();
    }

    public Object remove(int n) {
        try {
            return this.makeTransportable(this.delegate.remove(n));
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public boolean remove(Object object) {
        return this.delegate.remove(object);
    }

    public Object set(int n, Object object) {
        try {
            return this.makeTransportable(this.delegate.set(n, object));
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public int size() {
        return this.delegate.size();
    }

    protected final Object makeTransportable(Object object) throws NamingException {
        return WLNamingManager.getTransportableInstance(object, null, null, this.env);
    }

    protected final NamingEnumeration makeTransportable(NamingEnumeration namingEnumeration) throws NamingException {
        return (NamingEnumeration)this.makeTransportable((Object)namingEnumeration);
    }

    protected final DirContext makeTransportable(DirContext dirContext) throws NamingException {
        return (DirContext)this.makeTransportable((Object)dirContext);
    }
}

