/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.remote;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.jndi.remote.AttributeWrapper;
import weblogic.jndi.remote.RemoteAttributes;
import weblogic.rmi.extensions.RemoteRuntimeException;

public final class AttributesWrapper
implements RemoteAttributes {
    private Attributes delegate;
    private Hashtable env;

    protected Hashtable env() {
        return this.env;
    }

    protected Attributes delegate() {
        return this.delegate;
    }

    public AttributesWrapper(Attributes attributes, Hashtable hashtable) {
        this.delegate = attributes;
        this.env = hashtable;
    }

    public Object clone() {
        return this.makeTransportable(this.delegate.clone());
    }

    public Attribute get(String string) {
        return this.makeTransportable(this.delegate.get(string));
    }

    public NamingEnumeration getAll() {
        return this.makeTransportable(this.delegate.getAll());
    }

    public NamingEnumeration getIDs() {
        return this.makeTransportable(this.delegate.getIDs());
    }

    public boolean isCaseIgnored() {
        return this.delegate.isCaseIgnored();
    }

    public Attribute put(Attribute attribute) {
        Attribute attribute2 = attribute;
        if (attribute instanceof AttributeWrapper) {
            attribute2 = ((AttributeWrapper)attribute).delegate();
        }
        return this.makeTransportable(this.delegate.put(attribute2));
    }

    public Attribute put(String string, Object object) {
        return this.makeTransportable(this.delegate.put(string, object));
    }

    public Attribute remove(String string) {
        return this.makeTransportable(this.delegate.remove(string));
    }

    public int size() {
        return this.delegate.size();
    }

    protected final Object makeTransportable(Object object) {
        try {
            return WLNamingManager.getTransportableInstance(object, null, null, this.env);
        }
        catch (NamingException namingException) {
            throw new RemoteRuntimeException("Failed to create a transportable instance of " + object + " due to :", (Throwable)namingException);
        }
    }

    protected final NamingEnumeration makeTransportable(NamingEnumeration namingEnumeration) {
        return (NamingEnumeration)this.makeTransportable((Object)namingEnumeration);
    }

    protected final Attribute makeTransportable(Attribute attribute) {
        return (Attribute)this.makeTransportable((Object)attribute);
    }
}

