/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.remote;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.jndi.remote.NamingEnumerationWrapper;
import weblogic.jndi.remote.RemoteContext;

public class ContextWrapper
implements RemoteContext {
    private static final Hashtable DEFAULT_ENV = new Hashtable();
    private Context delegate;
    private Hashtable env = DEFAULT_ENV;

    protected Hashtable env() {
        return this.env;
    }

    public ContextWrapper(Context context) {
        this.delegate = context;
    }

    public ContextWrapper(Context context, Hashtable hashtable) {
        this(context);
        this.env = hashtable;
    }

    public void bind(String string, Object object) throws NamingException {
        this.delegate.bind(string, object);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.delegate.bind(name, object);
    }

    public void close() throws NamingException {
        this.delegate.close();
    }

    public String composeName(String string, String string2) throws NamingException {
        return this.delegate.composeName(string, string2);
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return this.delegate.composeName(name, name2);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.createSubcontext(name));
    }

    public void destroySubcontext(String string) throws NamingException {
        this.delegate.destroySubcontext(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.delegate.destroySubcontext(name);
    }

    public String getNameInNamespace() throws NamingException {
        return this.delegate.getNameInNamespace();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.delegate.getNameParser(string);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.delegate.getNameParser(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.list(string), this.env);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.list(name), this.env);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.listBindings(string), this.env);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.listBindings(name), this.env);
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    public Object lookup(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.lookup(name));
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(new CompositeName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.lookupLink(name));
    }

    public void rebind(String string, Object object) throws NamingException {
        this.delegate.rebind(string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.delegate.rebind(name, object);
    }

    public void rename(String string, String string2) throws NamingException {
        this.delegate.rename(string, string2);
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.delegate.rename(name, name2);
    }

    public void unbind(String string) throws NamingException {
        this.delegate.unbind(string);
    }

    public void unbind(Name name) throws NamingException {
        this.delegate.unbind(name);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.delegate.removeFromEnvironment(string);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.delegate.addToEnvironment(string, object);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.delegate.getEnvironment();
    }

    protected final Object makeTransportable(Object object) throws NamingException {
        return WLNamingManager.getTransportableInstance(object, null, null, this.env);
    }

    protected final Context makeTransportable(Context context) throws NamingException {
        try {
            return (Context)this.makeTransportable((Object)context);
        }
        catch (ClassCastException classCastException) {
            throw new ConfigurationException("A TransportableObjectFactory converted " + context.toString() + " into a object that does not implement Context");
        }
    }
}

