/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.remote;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import weblogic.jndi.remote.ContextWrapper;
import weblogic.jndi.remote.NamingEnumerationWrapper;
import weblogic.jndi.remote.RemoteDirContext;

public final class DirContextWrapper
extends ContextWrapper
implements RemoteDirContext {
    private DirContext delegate;

    public DirContextWrapper(DirContext dirContext) {
        super(dirContext);
        this.delegate = dirContext;
    }

    public DirContextWrapper(DirContext dirContext, Hashtable hashtable) {
        super(dirContext, hashtable);
        this.delegate = dirContext;
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.delegate.bind(string, object, attributes);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.delegate.bind(name, object, attributes);
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.createSubcontext(new CompositeName(string), attributes);
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.makeTransportable(this.delegate.createSubcontext(name, attributes));
    }

    public Attributes getAttributes(String string) throws NamingException {
        return (Attributes)this.makeTransportable(this.delegate.getAttributes(string));
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return (Attributes)this.makeTransportable(this.delegate.getAttributes(name));
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return (Attributes)this.makeTransportable(this.delegate.getAttributes(string, stringArray));
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.delegate.getAttributes(name, stringArray);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.delegate.modifyAttributes(string, n, attributes);
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.delegate.modifyAttributes(name, n, attributes);
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.delegate.modifyAttributes(string, modificationItemArray);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.delegate.modifyAttributes(name, modificationItemArray);
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.delegate.rebind(string, object, attributes);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.delegate.rebind(name, object, attributes);
    }

    public DirContext getSchema(String string) throws NamingException {
        return this.getSchema(new CompositeName(string));
    }

    public DirContext getSchema(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.getSchema(name));
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        return this.getSchemaClassDefinition(new CompositeName(string));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.getSchemaClassDefinition(name));
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(string, attributes), this.env());
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(name, attributes), this.env());
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(string, attributes, stringArray), this.env());
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(name, attributes, stringArray), this.env());
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(string, string2, searchControls), this.env());
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(name, string, searchControls), this.env());
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(string, string2, objectArray, searchControls), this.env());
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return new NamingEnumerationWrapper(this.delegate.search(name, string, objectArray, searchControls), this.env());
    }

    protected final DirContext makeTransportable(DirContext dirContext) throws NamingException {
        try {
            return (DirContext)this.makeTransportable((Object)dirContext);
        }
        catch (ClassCastException classCastException) {
            throw new ConfigurationException("A TransportableObjectFactory converted " + dirContext.toString() + " into a object that does not implement DirContext");
        }
    }
}

