/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.security.internal.server;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.omg.CORBA.portable.ObjectImpl;
import weblogic.corba.j2ee.naming.ContextImpl;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.iiop.IIOPClient;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.spi.IORDelegate;
import weblogic.jndi.Environment;
import weblogic.jndi.internal.ExceptionTranslator;
import weblogic.jndi.security.SubjectPusher;
import weblogic.kernel.Kernel;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.internal.InitialReferenceConstants;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.SubjectManagerImpl;
import weblogic.security.subject.AbstractSubject;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class ServerSubjectPusher
implements SubjectPusher,
InitialReferenceConstants {
    private static final boolean DEBUG = false;
    private static AuthenticatedSubject kernelId;
    private static final DebugCategory debugSecurity;

    public ServerSubjectPusher() {
        SubjectManagerImpl.ensureInitialized();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    public final void pushSubject(Hashtable hashtable, Context context) throws NamingException {
        Environment environment = new Environment(hashtable);
        if (Kernel.isServer()) {
            ServerSubjectPusher.serverPushSubject(environment, context);
        } else {
            ServerSubjectPusher.clientPushSubject(environment, context);
        }
    }

    public final void popSubject() {
        SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
    }

    private static final void clientPushSubject(Environment environment, Context context) throws NamingException {
        UserInfo userInfo = environment.getSecurityUser();
        if (userInfo == null && environment.isClientCertAvailable()) {
            userInfo = new DefaultUserInfoImpl(null, null);
        }
        if (userInfo != null && userInfo instanceof DefaultUserInfoImpl) {
            AuthenticatedSubject authenticatedSubject = environment.getSecuritySubject();
            if (authenticatedSubject == null) {
                ContextImpl contextImpl = (ContextImpl)context;
                if (IIOPClient.isEnabled() && contextImpl.getContext() != null && ((IORDelegate)((ObjectImpl)contextImpl.getContext())._get_delegate()).getIOR().getProfile().useSAS()) {
                    authenticatedSubject = new AuthenticatedSubject();
                    authenticatedSubject.getPrincipals().add(userInfo);
                    if (debugSecurity.isEnabled()) {
                        IIOPLogger.logDebugSecurity((String)("pushing user " + userInfo + " using CSIv2"));
                    }
                    ServerSubjectPusher.addPasswordCreds((DefaultUserInfoImpl)userInfo, authenticatedSubject);
                } else {
                    if (debugSecurity.isEnabled()) {
                        IIOPLogger.logDebugSecurity((String)("authenticating " + userInfo));
                    }
                    Object object = context.lookup("weblogic/security/SecurityManager");
                    SecurityService securityService = (SecurityService)PortableRemoteObject.narrow((Object)object, SecurityService.class);
                    try {
                        AuthenticatedUser authenticatedUser = securityService.authenticate(userInfo);
                        authenticatedSubject = SecurityServiceManager.getASFromAU((AuthenticatedUser)authenticatedUser);
                    }
                    catch (RemoteException remoteException) {
                        throw ExceptionTranslator.toNamingException(remoteException);
                    }
                }
                environment.setSecuritySubject(authenticatedSubject);
            }
            SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject);
            if (context instanceof ContextImpl) {
                ((ContextImpl)context).enableLogoutOnClose();
            }
        }
    }

    private static final void serverPushSubject(Environment environment, Context context) throws NamingException {
        UserInfo userInfo = environment.getSecurityUser();
        AuthenticatedSubject authenticatedSubject = null;
        if (debugSecurity.isEnabled()) {
            IIOPLogger.logDebugSecurity((String)("pushing user: " + userInfo));
        }
        if (userInfo != null && userInfo.getName() != null && userInfo.getName().length() != 0) {
            authenticatedSubject = environment.getSecuritySubject();
            if (authenticatedSubject != null) {
                authenticatedSubject = environment.getSecuritySubject();
            } else {
                try {
                    if (userInfo instanceof DefaultUserInfoImpl) {
                        DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
                        if (environment.getProviderUrl() == "local://" || NameParser.getProtocol(environment.getProviderUrl()) == "tgiop") {
                            authenticatedSubject = ServerSubjectPusher.authenticateLocally(defaultUserInfoImpl);
                        }
                        if (defaultUserInfoImpl.getName() != null && defaultUserInfoImpl.getPassword() != null) {
                            if (ServerSubjectPusher.isLocalServer(context)) {
                                authenticatedSubject = ServerSubjectPusher.authenticateLocally(defaultUserInfoImpl);
                            } else {
                                if (authenticatedSubject == null) {
                                    authenticatedSubject = new AuthenticatedSubject();
                                    authenticatedSubject.getPrincipals().add(userInfo);
                                }
                                ServerSubjectPusher.addPasswordCreds(defaultUserInfoImpl, authenticatedSubject);
                            }
                        } else if (authenticatedSubject == null) {
                            authenticatedSubject = ServerSubjectPusher.authenticateLocally(defaultUserInfoImpl);
                        }
                    }
                }
                catch (LoginException loginException) {
                    AuthenticationException authenticationException = new AuthenticationException();
                    authenticationException.setRootCause(loginException);
                    throw authenticationException;
                }
            }
        }
        if (authenticatedSubject != null) {
            environment.setSecuritySubject(authenticatedSubject);
            SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, authenticatedSubject);
            if (context instanceof ContextImpl) {
                ((ContextImpl)context).enableLogoutOnClose();
            }
        }
    }

    private static boolean isLocalServer(Context context) {
        if (!(context instanceof ContextImpl)) {
            return false;
        }
        ContextImpl contextImpl = (ContextImpl)context;
        try {
            boolean bl = contextImpl.getContext() != null && ((IORDelegate)((ObjectImpl)contextImpl.getContext())._get_delegate()).getIOR().isLocal();
            return bl;
        }
        catch (Throwable throwable) {
            if (debugSecurity.isEnabled()) {
                IIOPLogger.logDebugSecurity((String)("isLocalServer: false; Unable to determine whether is local or not; will treat it as remote. Exception: " + throwable));
            }
            return false;
        }
    }

    private static AuthenticatedSubject authenticateLocally(DefaultUserInfoImpl defaultUserInfoImpl) throws LoginException {
        String string = "weblogicDEFAULT";
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(defaultUserInfoImpl.getName(), defaultUserInfoImpl.getPassword());
        return principalAuthenticator.authenticate((CallbackHandler)simpleCallbackHandler);
    }

    private static void addPasswordCreds(DefaultUserInfoImpl defaultUserInfoImpl, AuthenticatedSubject authenticatedSubject) {
        if (defaultUserInfoImpl.getName() != null && defaultUserInfoImpl.getPassword() != null) {
            if (debugSecurity.isEnabled()) {
                IIOPLogger.logDebugSecurity((String)("adding password credentials to " + defaultUserInfoImpl));
            }
            final PasswordCredential passwordCredential = new PasswordCredential(defaultUserInfoImpl.getName(), defaultUserInfoImpl.getPassword());
            final AuthenticatedSubject authenticatedSubject2 = authenticatedSubject;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    authenticatedSubject2.getPrivateCredentials((AbstractSubject)kernelId).add(passwordCredential);
                    return null;
                }
            });
        }
    }

    static void p(String string) {
        System.err.println("<ServerSecurityManager> " + string);
    }

    static {
        debugSecurity = Debug.getCategory((String)"weblogic.jndi.security");
    }
}

