/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.spi;

import java.util.Locale;
import javax.naming.NamingException;
import weblogic.jndi.WLInitialContextFactoryDelegate;
import weblogic.jndi.spi.EnvironmentFactory;
import weblogic.utils.collections.ConcurrentHashMap;

public final class EnvironmentManager {
    public static final ConcurrentHashMap registeredFactories = new ConcurrentHashMap(11);
    private static final Object NULL_FACTORY = new Object();

    public static EnvironmentFactory getInstance(String string) throws NamingException {
        Object object = registeredFactories.get((Object)(string = string.toLowerCase(Locale.ENGLISH)));
        if (object == null) {
            try {
                object = Class.forName("weblogic.factories." + string + "." + string + "EnvironmentFactory", true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = DefaultFactoryMaker.DEFAULT_FACTORY;
            }
            catch (InstantiationException instantiationException) {
                object = NULL_FACTORY;
            }
            catch (IllegalAccessException illegalAccessException) {
                object = NULL_FACTORY;
            }
            registeredFactories.put((Object)string, object);
        }
        if (object == NULL_FACTORY) {
            throw new NamingException("No registered factory for " + string);
        }
        return (EnvironmentFactory)object;
    }

    private static final class DefaultFactoryMaker {
        private static final EnvironmentFactory DEFAULT_FACTORY = WLInitialContextFactoryDelegate.theOne();

        private DefaultFactoryMaker() {
        }
    }
}

