/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.security.AccessController;
import javax.management.MalformedObjectNameException;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicObjectName;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ExecuteQueueRuntimeMBean;
import weblogic.management.runtime.JTATransaction;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.AssertionError;

public final class ExecuteQueueRuntime
extends RuntimeMBeanDelegate
implements ExecuteQueueRuntimeMBean {
    private static final long serialVersionUID = 8609236957899063575L;
    private long lastDepartureSnapshot;
    private long lastDepartureSnapshotTime;
    private long lastWaitTime;
    private final ExecuteThreadManager queue;
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    static void addExecuteQueueRuntime(ExecuteThreadManager executeThreadManager) {
        try {
            new ExecuteQueueRuntime(executeThreadManager.getName(), executeThreadManager);
        }
        catch (ManagementException managementException) {
            T3SrvrLogger.logErrorCreatingExecuteQueueRuntime((String)executeThreadManager.getName(), (Throwable)managementException);
        }
    }

    public ExecuteQueueRuntime() throws ManagementException {
        throw new AssertionError("constructor for JMX compliance only");
    }

    private ExecuteQueueRuntime(String string, ExecuteThreadManager executeThreadManager) throws ManagementException {
        super(string);
        if ("weblogic.kernel.Default".equalsIgnoreCase(string) || "default".equalsIgnoreCase(string)) {
            ManagementService.getRuntimeAccess(kernelID).getServerRuntime().setDefaultExecuteQueueRuntime(this);
        }
        ManagementService.getRuntimeAccess(kernelID).getServerRuntime().addExecuteQueueRuntime(this);
        this.queue = executeThreadManager;
        this.lastDepartureSnapshot = 0L;
        this.lastDepartureSnapshotTime = this.lastWaitTime = System.currentTimeMillis();
    }

    public weblogic.management.runtime.ExecuteThread[] getExecuteThreads() {
        ExecuteThread[] executeThreadArray = this.queue.getExecuteThreads();
        int n = executeThreadArray.length;
        weblogic.management.runtime.ExecuteThread[] executeThreadArray2 = new weblogic.management.runtime.ExecuteThread[n];
        for (int i = 0; i < n; ++i) {
            executeThreadArray2[i] = new ExecuteThreadRuntime(executeThreadArray[i], this);
        }
        return executeThreadArray2;
    }

    public int getExecuteThreadCurrentIdleCount() {
        return this.queue.getIdleThreadCount();
    }

    public int getPendingRequestCurrentCount() {
        return this.queue.getExecuteQueueDepth();
    }

    public long getPendingRequestOldestTime() {
        long l = this.getServicedRequestTotalCount();
        long l2 = l - this.lastDepartureSnapshot;
        long l3 = System.currentTimeMillis();
        long l4 = l3 - this.lastDepartureSnapshotTime;
        long l5 = l3;
        if (l2 != 0L) {
            long l6 = l4 / l2;
            l5 = l3 - l6 * (long)this.getPendingRequestCurrentCount();
        } else if (this.getPendingRequestCurrentCount() != 0) {
            l5 = this.lastWaitTime;
        }
        this.lastDepartureSnapshot = l;
        this.lastDepartureSnapshotTime = l3;
        this.lastWaitTime = l5;
        return l5;
    }

    public int getServicedRequestTotalCount() {
        return this.queue.getExecuteQueueDepartures();
    }

    public weblogic.management.runtime.ExecuteThread[] getStuckExecuteThreads() {
        weblogic.management.runtime.ExecuteThread[] executeThreadArray = null;
        long l = ExecuteQueueRuntime.getConfiguredStuckThreadMaxTime(ManagementService.getRuntimeAccess(kernelID).getServer());
        ExecuteThread[] executeThreadArray2 = this.queue.getStuckExecuteThreads(l);
        if (executeThreadArray2 != null) {
            int n = executeThreadArray2.length;
            executeThreadArray = new weblogic.management.runtime.ExecuteThread[n];
            for (int i = 0; i < n; ++i) {
                executeThreadArray[i] = new ExecuteThreadRuntime(executeThreadArray2[i], this);
            }
        }
        return executeThreadArray;
    }

    private static final long getConfiguredStuckThreadMaxTime(ServerMBean serverMBean) {
        return serverMBean.getOverloadProtection().getServerFailureTrigger() != null ? (long)serverMBean.getOverloadProtection().getServerFailureTrigger().getMaxStuckThreadTime() * 1000L : (long)serverMBean.getStuckThreadMaxTime() * 1000L;
    }

    public int getExecuteThreadTotalCount() {
        return this.queue.getExecuteThreadCount();
    }

    private static final class ExecuteThreadRuntime
    implements weblogic.management.runtime.ExecuteThread {
        private static final long serialVersionUID = -716311114026904319L;
        private final String name;
        private WebLogicObjectName queueName;
        private final String currentRequest;
        private final String lastRequest;
        private final int servicedRequests;
        private final JTATransaction transaction;
        private final String user;
        private final long startTime;
        private final boolean isStuck;
        private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        private final transient Thread executeThread;

        private ExecuteThreadRuntime(ExecuteThread executeThread, ExecuteQueueRuntimeMBean executeQueueRuntimeMBean) {
            Object object;
            this.executeThread = executeThread;
            ExecuteRequest executeRequest = executeThread.getCurrentRequest();
            this.currentRequest = executeRequest != null ? executeRequest.toString() : null;
            this.lastRequest = null;
            this.servicedRequests = executeThread.getExecuteCount();
            TransactionManager transactionManager = TxHelper.getTransactionManager();
            this.transaction = transactionManager != null && transactionManager instanceof ServerTransactionManager ? ((ServerTransactionManager)transactionManager).getJTATransactionForThread((AuditableThread)executeThread) : null;
            String string = null;
            try {
                object = SecurityManager.getCurrentSubject((AuthenticatedSubject)kernelID, (AuditableThread)executeThread);
                if (object != null) {
                    string = SubjectUtils.getUsername((AuthenticatedSubject)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.user = string;
            this.name = executeThread.getName();
            try {
                object = ManagementService.getRuntimeAccess(kernelID);
                this.queueName = new WebLogicObjectName(object.getServerName(), "ExecuteQueueRuntime", object.getDomainName(), object.getServerName());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            this.startTime = executeThread.getTimeStamp();
            this.isStuck = executeThread.getPrintStuckThreadMessage();
        }

        public String getName() {
            return this.name;
        }

        public WebLogicObjectName getExecuteQueueRuntimeName() {
            return this.queueName;
        }

        public String getWorkManagerName() {
            return null;
        }

        public String getApplicationName() {
            return null;
        }

        public String getModuleName() {
            return null;
        }

        public String getApplicationVersion() {
            return null;
        }

        public String getCurrentRequest() {
            return this.currentRequest;
        }

        public String getLastRequest() {
            return this.lastRequest;
        }

        public int getServicedRequestTotalCount() {
            return this.servicedRequests;
        }

        public JTATransaction getTransaction() {
            return this.transaction;
        }

        public String getUser() {
            return this.user;
        }

        public boolean isIdle() {
            return this.currentRequest == null;
        }

        public boolean isStuck() {
            return this.isStuck;
        }

        public boolean isHogger() {
            return this.isStuck;
        }

        public boolean isStandby() {
            return false;
        }

        public long getCurrentRequestStartTime() {
            return this.startTime;
        }

        public Thread getExecuteThread() {
            return this.executeThread;
        }
    }
}

