/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.AuditableThread;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelLogger;

public class ExecuteThread
extends AuditableThread {
    private static final Throwable REQUEST_DEATH = new RequestDeath();
    private ExecuteThreadManager em;
    private int hashcode;
    private ExecuteRequest req = null;
    private boolean printStuckMessage = false;
    private boolean started = false;
    private int executeCount = 0;
    private long timeStamp = 0L;
    private boolean systemThread = false;

    ExecuteThread(int n, ExecuteThreadManager executeThreadManager) {
        super("ExecuteThread: '" + n + "' for queue: '" + executeThreadManager.getName() + "'");
        this.init(executeThreadManager);
    }

    ExecuteThread(int n, ExecuteThreadManager executeThreadManager, ThreadGroup threadGroup) {
        super(threadGroup, "ExecuteThread: '" + n + "' for queue: '" + executeThreadManager.getName() + "'");
        this.init(executeThreadManager);
    }

    protected void init(ExecuteThreadManager executeThreadManager) {
        this.em = executeThreadManager;
        this.hashcode = this.getName().hashCode();
    }

    public int hashCode() {
        return this.hashcode;
    }

    boolean isStarted() {
        return this.started;
    }

    public ExecuteRequest getCurrentRequest() {
        return this.req;
    }

    int getExecuteCount() {
        return this.executeCount;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    long getTimeStamp() {
        return this.timeStamp;
    }

    void setPrintStuckThreadMessage(boolean bl) {
        this.printStuckMessage = bl;
    }

    boolean getPrintStuckThreadMessage() {
        return this.printStuckMessage;
    }

    public void setSystemThread(boolean bl) {
        this.systemThread = bl;
    }

    boolean getSystemThread() {
        return this.systemThread;
    }

    public ExecuteThreadManager getExecuteThreadManager() {
        return this.em;
    }

    synchronized void notifyRequest(ExecuteRequest executeRequest) {
        this.setTimeStamp(System.currentTimeMillis());
        this.req = executeRequest;
        ((Object)((Object)this)).notify();
    }

    void setRequest(ExecuteRequest executeRequest) {
        this.req = executeRequest;
    }

    private synchronized void waitForRequest() {
        while (this.req == null) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void readyToRun() {
        this.started = true;
        super.readyToRun();
        ((Object)((Object)this)).notify();
    }

    public void run() {
        this.readyToRun();
        while (true) {
            try {
                while (true) {
                    this.reset();
                    this.em.registerIdle(this);
                    if (this.req == null) {
                        this.waitForRequest();
                    }
                    this.execute(this.req);
                }
            }
            catch (ExecuteThreadManager.ShutdownError shutdownError) {
            }
            catch (ThreadDeath threadDeath) {
                if (!Kernel.isServer()) continue;
                if (!Kernel.isIntentionalShutdown()) {
                    KernelLogger.logStopped((String)this.getName());
                }
                throw threadDeath;
            }
            break;
        }
        if (Kernel.isServer() && !Kernel.isIntentionalShutdown()) {
            KernelLogger.logStopped((String)this.getName());
        }
    }

    void execute(ExecuteRequest executeRequest) {
        try {
            ++this.executeCount;
            this.setTimeStamp(System.currentTimeMillis());
            executeRequest.execute(this);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (ExecuteThreadManager.ShutdownError shutdownError) {
            throw shutdownError;
        }
        catch (RequestDeath requestDeath) {
            KernelLogger.logExecuteCancelled((String)executeRequest.toString());
        }
        catch (Throwable throwable) {
            if (!Kernel.isApplet()) {
                KernelLogger.logExecuteFailed((Throwable)throwable);
            }
            throwable.printStackTrace();
        }
    }

    protected void reset() {
        super.reset();
        this.req = null;
    }

    private static final class RequestDeath
    extends Error {
        private RequestDeath() {
        }
    }
}

