/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.ArrayList;
import weblogic.health.HealthState;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.QueueFullException;
import weblogic.kernel.ServerExecuteThread;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.utils.collections.Stack;

public class ExecuteThreadManager {
    private static boolean netscape = false;
    private static final ShutdownRequest SHUTDOWN_REQUEST = new ShutdownRequest();
    private final String name;
    private final ThreadGroup threadGroup;
    private final UnsyncCircularQueue q;
    private final ArrayList threads;
    private final Stack idleThreads;
    private boolean shutdownRequested = false;
    private int departures = 0;
    private final Object printOnceLock = new Object();
    private boolean capacityGreaterThanThreshold = false;
    private final String[] healthReason = new String[]{""};
    private int healthState = 0;
    private final ExecuteQueueMBean queueMBean;

    protected ExecuteThreadManager(String string) {
        this.name = string;
        this.threadGroup = null;
        this.q = null;
        this.threads = null;
        this.idleThreads = null;
        this.queueMBean = null;
    }

    ExecuteThreadManager(String string, ExecuteQueueMBean executeQueueMBean) {
        this.name = string;
        this.queueMBean = executeQueueMBean;
        this.q = new UnsyncCircularQueue(256, executeQueueMBean.getQueueLength());
        this.idleThreads = new Stack(executeQueueMBean.getThreadCount());
        this.threads = new ArrayList(executeQueueMBean.getThreadCount());
        ThreadGroup threadGroup = null;
        try {
            threadGroup = new ThreadGroup("Thread Group for Queue: '" + string + "'");
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a security exception. That's okay.");
            netscape = true;
        }
        this.threadGroup = threadGroup;
        this.setThreadCount(executeQueueMBean.getThreadCount());
    }

    private int getThreadsIncrease() {
        return this.queueMBean != null ? this.queueMBean.getThreadsIncrease() : 0;
    }

    private int getThreadsMaximum() {
        return this.queueMBean != null ? this.queueMBean.getThreadsMaximum() : 0;
    }

    private int getCalculatedPercent() {
        if (this.queueMBean == null) {
            return 0;
        }
        return Math.max(this.queueMBean.getQueueLength() * this.queueMBean.getQueueLengthThresholdPercent() / 100, 1);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownRequested;
    }

    ExecuteThread[] getExecuteThreads() {
        return this.threads.toArray(new ExecuteThread[this.threads.size()]);
    }

    public int getExecuteQueueDepth() {
        return this.q.size();
    }

    public int getExecuteQueueSize() {
        return this.q.capacity();
    }

    public int getExecuteQueueDepartures() {
        return this.departures;
    }

    public int getExecuteThreadCount() {
        return this.threads.size();
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCount(int n) throws SecurityException {
        int n2;
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (this.shutdownRequested) {
                throw new IllegalStateException("Shutdown in progress");
            }
            int n3 = this.getThreadsMaximum();
            if (n > n3) {
                n = n3;
            }
            if (n <= this.threads.size()) {
                return;
            }
            int n4 = this.queueMBean != null ? this.queueMBean.getThreadPriority() : 5;
            for (int i = n2 = this.threads.size(); i < n; ++i) {
                ExecuteThread executeThread;
                if (netscape) {
                    executeThread = ExecuteThreadManager.createExecuteThread(i, this);
                } else {
                    try {
                        executeThread = ExecuteThreadManager.createExecuteThread(i, this, this.threadGroup);
                        executeThread.setDaemon(true);
                    }
                    catch (SecurityException securityException) {
                        System.err.println("Caught a security exception. That's okay.");
                        netscape = true;
                        executeThread = ExecuteThreadManager.createExecuteThread(i, this);
                    }
                }
                executeThread.setPriority(n4);
                this.threads.add(executeThread);
            }
        }
        this.startThreads(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads(int n) {
        ArrayList arrayList = this.threads;
        synchronized (arrayList) {
            for (int i = n; i < this.threads.size(); ++i) {
                ExecuteThread executeThread = (ExecuteThread)((Object)this.threads.get(i));
                if (executeThread == null) continue;
                executeThread.start();
                if (executeThread.isStarted()) continue;
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void expandThreadPool() {
        int n = this.getThreadsIncrease();
        if (this.threads.size() == 0) {
            this.setThreadCount(n);
        } else if (this.q.size() + 1 >= this.getCalculatedPercent()) {
            this.capacityGreaterThanThreshold = true;
            this.setHealthState(1, "Queue Capacity greater than configured threshold of " + this.queueMBean.getQueueLengthThresholdPercent() + "%.  Will" + " try to allocate: '" + n + "' threads to help.");
            this.setThreadCount(this.threads.size() + n);
        } else if (this.healthState != 0) {
            this.capacityGreaterThanThreshold = false;
            this.setHealthState(0, "");
        }
    }

    synchronized ExecuteThread[] getStuckExecuteThreads(long l) {
        int n;
        long l2 = System.currentTimeMillis();
        ArrayList<ExecuteThread> arrayList = null;
        if (this.threads.size() == 0 || l == 0L) {
            return null;
        }
        for (n = 0; n < this.threads.size(); ++n) {
            long l3;
            long l4;
            ExecuteThread executeThread = (ExecuteThread)((Object)this.threads.get(n));
            if (executeThread == null || executeThread.getSystemThread() || executeThread.getCurrentRequest() == null || (l4 = executeThread.getTimeStamp()) <= 0L || (l3 = l2 - l4) <= l) continue;
            executeThread.setPrintStuckThreadMessage(true);
            if (arrayList == null) {
                arrayList = new ArrayList<ExecuteThread>();
            }
            arrayList.add(executeThread);
        }
        n = this.getThreadsIncrease();
        if (arrayList != null && arrayList.size() == this.threads.size()) {
            this.setHealthState(2, "All Threads are stuck.  Will try to allocate: '" + n + "' threads to help.");
            this.setThreadCount(this.threads.size() + n);
        } else if (this.healthState != 0) {
            this.setHealthState(0, "");
        }
        return arrayList != null ? arrayList.toArray(new ExecuteThread[arrayList.size()]) : null;
    }

    synchronized void shutdown() throws SecurityException {
        if (this.shutdownRequested) {
            return;
        }
        this.shutdownRequested = true;
        while (this.idleThreads.size() != 0) {
            ExecuteThread executeThread = (ExecuteThread)((Object)this.idleThreads.pop());
            executeThread.notifyRequest(SHUTDOWN_REQUEST);
        }
    }

    public int getIdleThreadCount() {
        return this.idleThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIdle(ExecuteThread executeThread) {
        ExecuteRequest executeRequest;
        if (executeThread.getPrintStuckThreadMessage()) {
            T3SrvrLogger.logInfoUnstuckThread((String)executeThread.getName());
            executeThread.setPrintStuckThreadMessage(false);
        }
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            executeRequest = this.shutdownRequested ? SHUTDOWN_REQUEST : (ExecuteRequest)this.q.get();
            if (executeRequest == null) {
                this.idleThreads.push((Object)executeThread);
                return;
            }
        }
        executeThread.setRequest(executeRequest);
        ++this.departures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ExecuteRequest executeRequest, boolean bl) {
        ExecuteThread executeThread;
        if (bl && Kernel.isQueueThrottleAllowed()) {
            int n = this.queueMBean.getQueueLength();
            if (this.q.size() >= n) {
                throw new QueueFullException(n);
            }
        }
        try {
            ExecuteThreadManager executeThreadManager = this;
            synchronized (executeThreadManager) {
                block10: {
                    if (this.idleThreads.size() != 0) break block10;
                    this.expandThreadPool();
                    this.q.put((Object)executeRequest);
                    return;
                }
                executeThread = (ExecuteThread)((Object)this.idleThreads.pop());
            }
        }
        finally {
            this.logQueueCapacityWarning();
        }
        ++this.departures;
        executeThread.notifyRequest(executeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logQueueCapacityWarning() {
        boolean bl = false;
        Object object = this.printOnceLock;
        synchronized (object) {
            if (this.capacityGreaterThanThreshold) {
                bl = true;
                this.capacityGreaterThanThreshold = false;
            }
        }
        int n = this.getThreadsIncrease();
        if (bl && n != 0 && this.threads.size() + n <= this.getThreadsMaximum()) {
            T3SrvrLogger.logWarnQueueCapacityGreaterThanThreshold((int)this.queueMBean.getQueueLengthThresholdPercent(), (int)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeIfIdle(ExecuteRequest executeRequest) {
        ExecuteThread executeThread;
        ExecuteThreadManager executeThreadManager = this;
        synchronized (executeThreadManager) {
            if (this.idleThreads.size() == 0) {
                return false;
            }
            executeThread = (ExecuteThread)((Object)this.idleThreads.pop());
        }
        ++this.departures;
        executeThread.notifyRequest(executeRequest);
        return true;
    }

    private void setHealthState(int n, String string) {
        this.healthState = n;
        this.healthReason[0] = string;
    }

    public HealthState getHealthState() {
        return new HealthState(this.healthState, this.healthReason);
    }

    int getPendingTasksCount() {
        int n = 0;
        if (this.threads.size() == 0) {
            return 0;
        }
        for (int i = 0; i < this.threads.size(); ++i) {
            ExecuteRequest executeRequest;
            ExecuteThread executeThread = (ExecuteThread)((Object)this.threads.get(i));
            if (executeThread == null || executeThread.getSystemThread() || (executeRequest = executeThread.getCurrentRequest()) == null) continue;
            ++n;
        }
        return n += this.getExecuteQueueDepth();
    }

    public final synchronized String toString() {
        return super.toString() + " - name: '" + this.getName() + "' threads: '" + this.getExecuteThreadCount() + "' idle: '" + this.getIdleThreadCount() + " departures: '" + this.getExecuteQueueDepartures() + "' queue:\n\t" + this.q;
    }

    private static ExecuteThread createExecuteThread(int n, ExecuteThreadManager executeThreadManager) {
        if (KernelStatus.isApplet()) {
            return new ExecuteThread(n, executeThreadManager);
        }
        return new ServerExecuteThread(n, executeThreadManager);
    }

    private static ExecuteThread createExecuteThread(int n, ExecuteThreadManager executeThreadManager, ThreadGroup threadGroup) {
        if (KernelStatus.isApplet()) {
            return new ExecuteThread(n, executeThreadManager, threadGroup);
        }
        return new ServerExecuteThread(n, executeThreadManager, threadGroup);
    }

    static final class ShutdownError
    extends Error {
        ShutdownError() {
        }
    }

    private static final class ShutdownRequest
    implements ExecuteRequest {
        private ShutdownRequest() {
        }

        public void execute(ExecuteThread executeThread) {
            throw new ShutdownError();
        }
    }
}

