/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.MBeanStub;
import weblogic.management.configuration.IIOPMBean;

final class IIOPMBeanStub
extends MBeanStub
implements IIOPMBean {
    private int defaultGIOPMinorVersion = 2;
    private String iiopLocationForwardPolicy = "failover";
    private boolean useIIOPLocateRequest = false;
    private boolean useFullRepositoyIdList = false;
    private String iiopTxMechanism = "ots";
    private int idleIIOPConnectionTimeout = 240000;
    private String charCodeset = "US-ASCII";
    private String wcharCodeset = "UCS-2";
    public String systemSecurity = "none";
    private boolean statefulAuthentication = true;
    private boolean useSFV2 = false;
    private boolean enableIORServlet = false;
    private boolean useJavaSerialization = false;

    IIOPMBeanStub() {
        this.initializeFromSystemProperties("weblogic.iiop.");
    }

    public int getMaxMessageSize() {
        return 10000000;
    }

    public void setMaxMessageSize(int n) {
    }

    public int getCompleteMessageTimeout() {
        return 60;
    }

    public void setCompleteMessageTimeout(int n) {
    }

    public int getDefaultMinorVersion() {
        return this.defaultGIOPMinorVersion;
    }

    public void setDefaultMinorVersion(int n) {
        this.defaultGIOPMinorVersion = n;
    }

    public String getLocationForwardPolicy() {
        return this.iiopLocationForwardPolicy;
    }

    public void setLocationForwardPolicy(String string) {
        this.iiopLocationForwardPolicy = string;
    }

    public boolean getUseLocateRequest() {
        return this.useIIOPLocateRequest;
    }

    public void setUseLocateRequest(boolean bl) {
        this.useIIOPLocateRequest = bl;
    }

    public boolean getUseFullRepositoryIdList() {
        return this.useFullRepositoyIdList;
    }

    public void setUseFullRepositoryIdList(boolean bl) {
        this.useFullRepositoyIdList = bl;
    }

    public String getTxMechanism() {
        return this.iiopTxMechanism;
    }

    public void setTxMechanism(String string) {
        this.iiopTxMechanism = string;
    }

    public int getIdleConnectionTimeout() {
        return this.idleIIOPConnectionTimeout / 1000;
    }

    public void setIdleConnectionTimeout(int n) {
        this.idleIIOPConnectionTimeout = n * 1000;
    }

    public String getDefaultCharCodeset() {
        return this.charCodeset;
    }

    public void setDefaultCharCodeset(String string) {
        this.charCodeset = string;
    }

    public String getDefaultWideCharCodeset() {
        return this.wcharCodeset;
    }

    public void setDefaultWideCharCodeset(String string) {
        this.wcharCodeset = string;
    }

    public String getSystemSecurity() {
        return this.systemSecurity;
    }

    public void setSystemSecurity(String string) {
        this.systemSecurity = string;
    }

    public boolean getUseStatefulAuthentication() {
        return this.statefulAuthentication;
    }

    public void setUseStatefulAuthentication(boolean bl) {
        this.statefulAuthentication = bl;
    }

    public boolean getUseSerialFormatVersion2() {
        return this.useSFV2;
    }

    public void setUseSerialFormatVersion2(boolean bl) {
        this.useSFV2 = bl;
    }

    public boolean getEnableIORServlet() {
        return this.enableIORServlet;
    }

    public void setEnableIORServlet(boolean bl) {
        this.enableIORServlet = bl;
    }

    public boolean getUseJavaSerialization() {
        return this.useJavaSerialization;
    }

    public void setUseJavaSerialization(boolean bl) {
        this.useJavaSerialization = bl;
    }
}

