/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.InvalidAttributeValueException;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.kernel.ExecuteQueueMBeanStub;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.KernelEnvironment;
import weblogic.kernel.KernelLogger;
import weblogic.kernel.KernelMBeanStub;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.protocol.ClientEnvironment;
import weblogic.utils.StackTraceUtils;
import weblogic.work.ExecuteQueueFactory;

public final class Kernel
extends KernelStatus {
    private static final String ALLOW_QUEUE_THROTTLE = "weblogic.kernel.allowQueueThrottling";
    private static final int DIRECT = 0;
    private static KernelMBean config;
    private static ExecuteThreadManager[] queues;
    private static final HashMap policyNameAlias;
    private static final ArrayList applicationQueueNames;
    private static int defaultDispatchIndex;
    private static boolean isTracingEnabled;
    private static final boolean allowQueueThrottling;

    private static final boolean initAllowThrottleProp() {
        if (Kernel.isApplet()) {
            return false;
        }
        return Boolean.getBoolean(ALLOW_QUEUE_THROTTLE);
    }

    public static final boolean isTracingEnabled() {
        return isTracingEnabled;
    }

    public static boolean isInitialized() {
        return config != null;
    }

    public static synchronized void ensureInitialized() {
        Kernel.initialized();
        if (config == null) {
            try {
                KernelMBeanStub kernelMBeanStub = new KernelMBeanStub();
                Kernel.initialize(kernelMBeanStub);
            }
            catch (Throwable throwable) {
                throw new InternalError("error initializing kernel caused by: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
    }

    public static synchronized void initialize(KernelMBean kernelMBean) {
        Kernel.initialized();
        if (config != null) {
            throw new AssertionError((Object)"Kernel was initialized more than once");
        }
        config = kernelMBean;
        Kernel.setIsConfigured();
        isTracingEnabled = config.getTracingEnabled();
        VersionInfoFactory.initialize(Kernel.isServer());
        ClientEnvironment.loadEnvironment();
        policyNameAlias.put("weblogic.kernel.Default", "default");
        if (kernelMBean.getUse81StyleExecuteQueues()) {
            if (Kernel.isServer()) {
                KernelLogger.logInitializingKernelDelegator();
            }
            ExecuteQueueFactory.initialize(kernelMBean);
        }
        defaultDispatchIndex = Kernel.getDispatchPolicyIndex("weblogic.kernel.Default");
    }

    public static KernelMBean getConfig() {
        if (!Kernel.isServer() && !Kernel.isInitialized()) {
            Kernel.ensureInitialized();
        }
        return config;
    }

    public static KernelDebugMBean getDebug() {
        return config.getKernelDebug();
    }

    public static ExecuteThreadManager getExecuteThreadManager(String string) {
        int n = Kernel.getDispatchPolicyIndex(string);
        return queues[n];
    }

    static ExecuteThreadManager[] getExecuteThreadManagers() {
        return queues;
    }

    public static void execute(ExecuteRequest executeRequest) {
        Kernel.execute(executeRequest, false);
    }

    public static void execute(ExecuteRequest executeRequest, boolean bl) {
        queues[defaultDispatchIndex].execute(executeRequest, bl);
    }

    public static void execute(ExecuteRequest executeRequest, int n) {
        Kernel.execute(executeRequest, n, false);
    }

    public static void execute(ExecuteRequest executeRequest, int n, boolean bl) {
        if (n == 0) {
            Kernel.executeLocally(executeRequest);
        } else {
            queues[n].execute(executeRequest, bl);
        }
    }

    private static void executeLocally(ExecuteRequest executeRequest) {
        try {
            executeRequest.execute(null);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (ExecuteThreadManager.ShutdownError shutdownError) {
            throw shutdownError;
        }
        catch (Throwable throwable) {
            if (!Kernel.isApplet()) {
                KernelLogger.logExecuteFailed((Throwable)throwable);
            }
            throwable.printStackTrace();
        }
    }

    public static void execute(ExecuteRequest executeRequest, String string) {
        Kernel.execute(executeRequest, string, false);
    }

    public static void execute(ExecuteRequest executeRequest, String string, boolean bl) {
        Kernel.execute(executeRequest, Kernel.getDispatchPolicyIndex(string), bl);
    }

    public static void executeIfIdle(ExecuteRequest executeRequest, int n) {
        if (n == 0 || !queues[n].executeIfIdle(executeRequest)) {
            Thread thread2 = Thread.currentThread();
            if (thread2 instanceof ExecuteThread) {
                ((ExecuteThread)((Object)thread2)).execute(executeRequest);
            } else {
                try {
                    executeRequest.execute(null);
                }
                catch (Exception exception) {
                    throw new InternalError("Error executing the request on a Non-kernel Thread: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
            }
        }
    }

    public static void executeIfIdle(ExecuteRequest executeRequest, String string) {
        Kernel.executeIfIdle(executeRequest, Kernel.getDispatchPolicyIndex(string));
    }

    public static int getExecuteQueueDepth() {
        return queues[defaultDispatchIndex].getExecuteQueueDepth();
    }

    public static int getExecuteQueueDepth(int n) {
        if (n == 0) {
            return 0;
        }
        return queues[n].getExecuteQueueDepth();
    }

    public static int getDispatchPolicyIndex(String string) {
        if ("direct".equalsIgnoreCase(string)) {
            return 0;
        }
        int n = queues.length;
        for (int i = 1; i < n; ++i) {
            String string2 = queues[i].getName();
            if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase((String)policyNameAlias.get(string))) continue;
            return i;
        }
        Kernel.ensureInitialized();
        return Kernel.getDispatchPolicyIndex("weblogic.kernel.Default");
    }

    public static boolean isDispatchPolicy(String string) {
        if ("direct".equalsIgnoreCase(string)) {
            return true;
        }
        int n = queues.length;
        for (int i = 1; i < n; ++i) {
            String string2 = queues[i].getName();
            if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase((String)policyNameAlias.get(string))) continue;
            return true;
        }
        return false;
    }

    public static void addExecuteQueue(String string, int n) {
        Kernel.addInternalExecuteQueue(string, n, 0, n);
    }

    public static void addExecuteQueue(String string, String string2, int n) {
        policyNameAlias.put(string, string2);
        Kernel.addInternalExecuteQueue(string, n, 0, n);
    }

    public static void addExecuteQueue(String string, int n, int n2, int n3) {
        Kernel.addInternalExecuteQueue(string, n, n2, n3);
    }

    private static void addInternalExecuteQueue(String string, int n, int n2, int n3) {
        ExecuteQueueMBeanStub executeQueueMBeanStub = new ExecuteQueueMBeanStub();
        try {
            executeQueueMBeanStub.setThreadCount(n);
            executeQueueMBeanStub.setThreadsIncrease(n2);
            executeQueueMBeanStub.setThreadsMaximum(n3);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)("Invalid ExecuteQueueMBean attributes specified for " + string));
        }
        Kernel.addExecuteQueue(string, executeQueueMBeanStub, false);
    }

    private static void addExecuteQueue(String string, ExecuteQueueMBean executeQueueMBean) {
        Kernel.addExecuteQueue(string, executeQueueMBean, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExecuteQueue(String string, ExecuteQueueMBean executeQueueMBean, boolean bl) {
        if (bl) {
            if (!applicationQueueNames.contains(string)) {
                applicationQueueNames.add(string);
            }
        } else {
            applicationQueueNames.remove(string);
            applicationQueueNames.remove(policyNameAlias.get(string));
        }
        if (Kernel.isDispatchPolicy(string)) {
            return;
        }
        Class<Kernel> clazz = Kernel.class;
        synchronized (Kernel.class) {
            if (Kernel.isDispatchPolicy(string)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            ExecuteThreadManager executeThreadManager = new ExecuteThreadManager(string, executeQueueMBean);
            KernelEnvironment.getKernelEnvironment().addExecuteQueueRuntime(executeThreadManager);
            ExecuteThreadManager[] executeThreadManagerArray = new ExecuteThreadManager[queues.length + 1];
            System.arraycopy(queues, 0, executeThreadManagerArray, 0, queues.length);
            executeThreadManagerArray[Kernel.queues.length] = executeThreadManager;
            queues = executeThreadManagerArray;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void initializeExecuteQueue(ExecuteQueueMBean executeQueueMBean) {
        Kernel.addExecuteQueue(executeQueueMBean.getName(), executeQueueMBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        KernelStatus.shutdown();
        Class<Kernel> clazz = Kernel.class;
        synchronized (Kernel.class) {
            int n = queues.length;
            for (int i = 1; i < n; ++i) {
                queues[i].shutdown();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean checkStuckThreads(String string, long l) {
        boolean bl = false;
        ExecuteThreadManager[] executeThreadManagerArray = Kernel.getExecuteThreadManagers();
        if (string != null) {
            ExecuteThread[] executeThreadArray;
            ExecuteThreadManager executeThreadManager;
            int n = Kernel.getDispatchPolicyIndex(string);
            if (l > 0L && n > 0 && (executeThreadManager = executeThreadManagerArray[n]) != null && (executeThreadArray = executeThreadManager.getStuckExecuteThreads(l)) != null && executeThreadArray.length == executeThreadManager.getExecuteThreadCount()) {
                bl = true;
            }
        }
        return bl;
    }

    public static int getPendingTasksCount(String string) {
        ExecuteThreadManager executeThreadManager;
        int n;
        int n2 = 0;
        ExecuteThreadManager[] executeThreadManagerArray = Kernel.getExecuteThreadManagers();
        if (string != null && (n = Kernel.getDispatchPolicyIndex(string)) > 0 && (executeThreadManager = executeThreadManagerArray[n]) != null) {
            n2 = executeThreadManager.getPendingTasksCount();
        }
        return n2;
    }

    public static List getApplicationDispatchPolicies() {
        return applicationQueueNames;
    }

    public static boolean isApplicationDispatchPolicy(int n) {
        if (n == 0) {
            return false;
        }
        return applicationQueueNames.contains(queues[n].getName());
    }

    private Kernel() {
    }

    static boolean isQueueThrottleAllowed() {
        return allowQueueThrottling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDummyDefaultQueue(ExecuteThreadManager executeThreadManager) {
        Class<Kernel> clazz = Kernel.class;
        synchronized (Kernel.class) {
            ExecuteThreadManager[] executeThreadManagerArray = new ExecuteThreadManager[queues.length + 1];
            System.arraycopy(queues, 0, executeThreadManagerArray, 0, queues.length);
            executeThreadManagerArray[Kernel.queues.length] = executeThreadManager;
            queues = executeThreadManagerArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        queues = new ExecuteThreadManager[1];
        policyNameAlias = new HashMap();
        applicationQueueNames = new ArrayList();
        isTracingEnabled = false;
        allowQueueThrottling = Kernel.initAllowThrottleProp();
    }
}

