/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import com.bea.logging.LogBufferHandler;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.diagnostics.debug.KernelDebugService;
import weblogic.kernel.KernelMBeanStub;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.ConsoleHandler;
import weblogic.logging.FileStreamHandler;
import weblogic.management.configuration.KernelMBean;

public class KernelLogManager {
    public static Logger getLogger() {
        return LoggerMaker.LOGGER;
    }

    public static void setLogger(Logger logger) {
        if (logger != null) {
            LoggerMaker.LOGGER = logger;
        }
    }

    public static void initialize(KernelMBean kernelMBean) {
        LoggerMaker.LOGGER = KernelLogManager.createServerLogger(kernelMBean);
    }

    private static Logger createClientLogger(KernelMBean kernelMBean) {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
        ConsoleHandler consoleHandler = new ConsoleHandler(kernelMBean);
        consoleHandler.setFormatter(new ConsoleFormatter(kernelMBean));
        logger.addHandler(consoleHandler);
        if (kernelMBean.getLog().getFileName() != null) {
            try {
                FileStreamHandler fileStreamHandler = new FileStreamHandler(kernelMBean.getLog());
                fileStreamHandler.setFormatter(new ConsoleFormatter(kernelMBean));
                logger.addHandler((Handler)((Object)fileStreamHandler));
            }
            catch (IOException iOException) {
                System.err.println("Error opening log file " + kernelMBean.getLog().getFileName());
            }
        }
        logger.addHandler((Handler)LogBufferHandler.getInstance());
        KernelDebugService.getKernelDebugService().initializeDebugLogging(logger);
        return logger;
    }

    private static Logger createServerLogger(KernelMBean kernelMBean) {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
        Handler[] handlerArray = logger.getHandlers();
        if (handlerArray != null) {
            for (int i = 0; i < handlerArray.length; ++i) {
                logger.removeHandler(handlerArray[i]);
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(kernelMBean);
        consoleHandler.setFormatter(new ConsoleFormatter(kernelMBean));
        logger.addHandler(consoleHandler);
        logger.addHandler((Handler)LogBufferHandler.getInstance());
        return logger;
    }

    static /* synthetic */ Logger access$000(KernelMBean kernelMBean) {
        return KernelLogManager.createClientLogger(kernelMBean);
    }

    private static final class LoggerMaker {
        private static Logger LOGGER = KernelLogManager.access$000(new KernelMBeanStub());

        private LoggerMaker() {
        }
    }
}

