/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.io.File;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import weblogic.kernel.MBeanStub;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.LogMBean;

final class LogMBeanStub
extends MBeanStub
implements LogMBean {
    private static final String TRACE = "Trace";
    private static final String INFO = "Info";
    private String fname = null;
    private String rotationType = "none";
    private boolean filesLtd = false;
    private int fileCount = 7;
    private int timeSpan = 24;
    private int fileSize = 500;
    private String logRotationTime;
    private boolean rotateLogOnStartup = false;
    private String rotationDir = null;
    private boolean log4jLoggingEnabled = false;
    private int memoryBufferSize = 500;
    private String stdoutSeverty = "Info";
    private String logFileSeverity = "Trace";
    private String domainLogBroadcastSeverity;
    private String memoryBufferSeverity;
    private LogFilterMBean stdoutFilter;
    private LogFilterMBean logFileFilter;
    private LogFilterMBean domainLogBroadcastFilter;
    private LogFilterMBean memoryBufferFilter;
    private boolean redirectStdoutToServerLogEnabled = false;
    private boolean redirectStderrToServerLogEnabled = false;
    private String stdoutFormat = "standard";
    private boolean stdoutLogStack = true;
    private int stacktraceDepth = 5;
    private String dateFormatPattern;

    LogMBeanStub() {
        this.initializeFromSystemProperties("weblogic.log.");
    }

    public String getFileName() {
        return this.fname;
    }

    public void setFileName(String string) {
        this.fname = string;
    }

    public String getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(String string) {
        this.rotationType = string;
    }

    public boolean isNumberOfFilesLimited() {
        return this.filesLtd;
    }

    public void setNumberOfFilesLimited(boolean bl) {
        this.filesLtd = bl;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int n) {
        this.fileCount = n;
    }

    public int getFileTimeSpan() {
        return this.timeSpan;
    }

    public void setFileTimeSpan(int n) {
        this.timeSpan = n;
    }

    public int getFileMinSize() {
        return this.fileSize;
    }

    public void setFileMinSize(int n) {
        this.fileSize = n;
    }

    public String getRotationTime() {
        return this.logRotationTime;
    }

    public void setRotationTime(String string) {
        this.logRotationTime = string;
    }

    public boolean getRotateLogOnStartup() {
        return this.rotateLogOnStartup;
    }

    public void setRotateLogOnStartup(boolean bl) {
        this.rotateLogOnStartup = bl;
    }

    public String getLogFileRotationDir() {
        return this.rotationDir;
    }

    public void setLogFileRotationDir(String string) {
        this.rotationDir = string;
    }

    public LogFilterMBean getLogFileFilter() {
        return this.logFileFilter;
    }

    public void setLogFileFilter(LogFilterMBean logFilterMBean) {
        this.logFileFilter = logFilterMBean;
    }

    public LogFilterMBean getStdoutFilter() {
        return this.stdoutFilter;
    }

    public void setStdoutFilter(LogFilterMBean logFilterMBean) {
        this.stdoutFilter = logFilterMBean;
    }

    public LogFilterMBean getMemoryBufferFilter() {
        return this.memoryBufferFilter;
    }

    public void setMemoryBufferFilter(LogFilterMBean logFilterMBean) {
        this.memoryBufferFilter = logFilterMBean;
    }

    public LogFilterMBean getDomainLogBroadcastFilter() {
        return this.domainLogBroadcastFilter;
    }

    public void setDomainLogBroadcastFilter(LogFilterMBean logFilterMBean) {
        this.domainLogBroadcastFilter = logFilterMBean;
    }

    public boolean isLog4jLoggingEnabled() {
        return this.log4jLoggingEnabled;
    }

    public void setLog4jLoggingEnabled(boolean bl) {
        this.log4jLoggingEnabled = bl;
    }

    public int getMemoryBufferSize() {
        return this.memoryBufferSize;
    }

    public void setMemoryBufferSize(int n) {
        this.memoryBufferSize = n;
    }

    public String getStdoutSeverity() {
        return this.stdoutSeverty;
    }

    public void setStdoutSeverity(String string) {
        this.stdoutSeverty = string;
    }

    public String getLogFileSeverity() {
        return this.logFileSeverity;
    }

    public void setLogFileSeverity(String string) {
        this.logFileSeverity = string;
    }

    public String getMemoryBufferSeverity() {
        return this.memoryBufferSeverity;
    }

    public void setMemoryBufferSeverity(String string) {
        this.memoryBufferSeverity = string;
    }

    public String getDomainLogBroadcastSeverity() {
        return this.domainLogBroadcastSeverity;
    }

    public void setDomainLogBroadcastSeverity(String string) {
        this.domainLogBroadcastSeverity = string;
    }

    public boolean isRedirectStdoutToServerLogEnabled() {
        return this.redirectStdoutToServerLogEnabled;
    }

    public void setRedirectStdoutToServerLogEnabled(boolean bl) {
        this.redirectStdoutToServerLogEnabled = bl;
    }

    public boolean isRedirectStderrToServerLogEnabled() {
        return this.redirectStderrToServerLogEnabled;
    }

    public void setRedirectStderrToServerLogEnabled(boolean bl) {
        this.redirectStderrToServerLogEnabled = bl;
    }

    public int getDomainLogBroadcasterBufferSize() {
        return 0;
    }

    public void setDomainLogBroadcasterBufferSize(int n) {
    }

    public String computeLogFilePath() {
        return new File(this.getFileName()).getAbsolutePath();
    }

    public String getStdoutFormat() {
        return this.stdoutFormat;
    }

    public void setStdoutFormat(String string) {
        this.stdoutFormat = string;
    }

    public boolean isStdoutLogStack() {
        return this.stdoutLogStack;
    }

    public void setStdoutLogStack(boolean bl) {
        this.stdoutLogStack = bl;
    }

    public int getStacktraceDepth() {
        return this.stacktraceDepth;
    }

    public void setStacktraceDepth(int n) {
        this.stacktraceDepth = n;
    }

    public long getFileTimeSpanFactor() {
        return 3600000L;
    }

    public void setFileTimeSpanFactor(long l) {
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public void setOutputStream(OutputStream outputStream) {
    }

    public int getBufferSizeKB() {
        return 8;
    }

    public void setBufferSizeKB(int n) {
    }

    public String getDateFormatPattern() {
        if (this.dateFormatPattern == null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 0);
            this.dateFormatPattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : "MMM d, yyyy h:mm:ss a z";
        }
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String string) {
    }

    public String getLoggerSeverity() {
        return TRACE;
    }

    public void setLoggerSeverity(String string) {
    }

    public Properties getLoggerSeverityProperties() {
        return null;
    }

    public void setLoggerSeverityProperties(Properties properties) {
    }

    public boolean isServerLoggingBridgeUseParentLoggersEnabled() {
        return false;
    }

    public void setServerLoggingBridgeUseParentLoggersEnabled(boolean bl) {
    }
}

